/*
 * Decompiled with CFR 0.152.
 */
package net.stalosir.createkart.entity;

import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import net.minecraftforge.items.wrapper.EntityArmorInvWrapper;
import net.minecraftforge.items.wrapper.EntityHandsInvWrapper;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import net.minecraftforge.registries.ForgeRegistries;
import net.stalosir.createkart.ConfigCreateKart;
import net.stalosir.createkart.init.CreateKartModEntities;
import net.stalosir.createkart.init.CreateKartModItems;
import org.joml.Vector3f;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class KartEntity
extends PathfinderMob
implements GeoEntity,
ICapabilityProvider {
    public static final EntityDataAccessor<Boolean> SHOOT = SynchedEntityData.m_135353_(KartEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<String> ANIMATION = SynchedEntityData.m_135353_(KartEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    public static final EntityDataAccessor<String> TEXTURE = SynchedEntityData.m_135353_(KartEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    public static final EntityDataAccessor<String> DATA_COLOR = SynchedEntityData.m_135353_(KartEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<Integer> DATA_FUEL = SynchedEntityData.m_135353_(KartEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> DATA_FUEL_OVER = SynchedEntityData.m_135353_(KartEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private boolean swinging;
    private boolean lastloop;
    private long lastSwing;
    boolean hurtAnimation = false;
    int hurtTimeAnim = 0;
    public String animationprocedure = "empty";
    public boolean fuelOverCheck;
    public int fuelOverTimer;
    private int MaxFuelfuelAmount;
    public float MaxUpStep = (float)ConfigCreateKart.CONFIG_MAX_UP_STEP;
    public float Fuel_Consumption = (float)ConfigCreateKart.CONFIG_FUEL_CONSUMPTION;
    private final ItemStackHandler inventory = new ItemStackHandler(1){

        public int getSlotLimit(int slot) {
            return 64;
        }
    };
    private final CombinedInvWrapper combined = new CombinedInvWrapper(new IItemHandlerModifiable[]{this.inventory, new EntityHandsInvWrapper((LivingEntity)this), new EntityArmorInvWrapper((LivingEntity)this)});
    private Vec3 lastPosition = Vec3.f_82478_;
    private int ticksSinceLoad = 0;
    boolean OldMovementCheck;
    String prevAnim;

    public KartEntity(PlayMessages.SpawnEntity packet, Level world) {
        this((EntityType<KartEntity>)((EntityType)CreateKartModEntities.KART.get()), world);
    }

    public KartEntity(EntityType<KartEntity> type, Level world) {
        super(type, world);
        this.OldMovementCheck = (Boolean)ConfigCreateKart.CLIENT.Old_Movement_Check.get();
        this.prevAnim = "empty";
        this.f_21364_ = 0;
        this.MaxFuelfuelAmount = 16000;
        this.m_21557_(false);
        this.m_274367_(this.MaxUpStep);
        this.m_21530_();
    }

    private Item getKartItemByColor(String color) {
        return switch (color) {
            case "white" -> (Item)CreateKartModItems.KART_WHITE.get();
            case "light_gray" -> (Item)CreateKartModItems.KART_LIGHT_GRAY.get();
            case "gray" -> (Item)CreateKartModItems.KART_GRAY.get();
            case "black" -> (Item)CreateKartModItems.KART_BLACK.get();
            case "brown" -> (Item)CreateKartModItems.KART_BROWN.get();
            case "red" -> (Item)CreateKartModItems.KART_RED.get();
            case "orange" -> (Item)CreateKartModItems.KART_ORANGE.get();
            case "yellow" -> (Item)CreateKartModItems.KART_YELLOW.get();
            case "lime" -> (Item)CreateKartModItems.KART_LIME.get();
            case "green" -> (Item)CreateKartModItems.KART_GREEN.get();
            case "cyan" -> (Item)CreateKartModItems.KART_CYAN.get();
            case "light_blue" -> (Item)CreateKartModItems.KART_LIGHT_BLUE.get();
            case "blue" -> (Item)CreateKartModItems.KART_BLUE.get();
            case "purple" -> (Item)CreateKartModItems.KART_PURPLE.get();
            case "magenta" -> (Item)CreateKartModItems.KART_MAGENTA.get();
            case "pink" -> (Item)CreateKartModItems.KART_PINK.get();
            default -> (Item)CreateKartModItems.KART_RED.get();
        };
    }

    public InteractionResult m_6071_(Player sourceentity, InteractionHand hand) {
        InteractionResult retval = InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
        if (sourceentity.m_6144_()) {
            Item added3;
            ItemStack itemInHand = sourceentity.m_21120_(hand);
            if (itemInHand.m_41720_() == ForgeRegistries.ITEMS.getValue(new ResourceLocation("create:wrench")) && !this.m_9236_().f_46443_) {
                int remainingFuel;
                int coalDrop;
                if (this.getFuel() > 0 && (coalDrop = (remainingFuel = this.getFuel()) / 250) > 0) {
                    ItemStack coalStack = new ItemStack((ItemLike)Items.f_42413_, coalDrop);
                    boolean added2 = sourceentity.m_150109_().m_36054_(coalStack);
                    if (!added2) {
                        sourceentity.m_36176_(coalStack, false);
                    }
                }
                ItemStack kartItem = new ItemStack((ItemLike)this.getKartItemByColor(this.getColor()));
                boolean added3 = sourceentity.m_150109_().m_36054_(kartItem);
                if (!added3) {
                    sourceentity.m_36176_(kartItem, false);
                }
                this.m_146870_();
            }
            if ((added3 = itemInHand.m_41720_()) instanceof DyeItem) {
                DyeItem dye = (DyeItem)added3;
                String colorName = dye.m_41089_().m_7912_();
                this.f_19804_.m_135381_(DATA_COLOR, (Object)colorName);
                if (!this.m_9236_().f_46443_) {
                    itemInHand.m_41774_(1);
                }
                this.spawnColorParticles(colorName);
                return InteractionResult.SUCCESS;
            }
            if (itemInHand.m_41720_() == Items.f_42413_ || itemInHand.m_41720_() == Items.f_42414_ || itemInHand.m_41720_() == Items.f_42200_) {
                int fuelToAdd = itemInHand.m_41720_() == Items.f_42200_ ? 2250 : 250;
                int fuelSpaceLeft = this.getMaxFuel() - this.getFuel();
                if (fuelSpaceLeft <= 0) {
                    if (!this.m_9236_().f_46443_) {
                        sourceentity.m_5661_((Component)Component.m_237113_((String)"Le r\u00e9servoir est d\u00e9j\u00e0 plein !"), true);
                    }
                    return InteractionResult.FAIL;
                }
                if (fuelToAdd > fuelSpaceLeft) {
                    if (!this.m_9236_().f_46443_) {
                        sourceentity.m_5661_((Component)Component.m_237113_((String)"Pas assez de place dans le r\u00e9servoir !"), true);
                    }
                    return InteractionResult.FAIL;
                }
                this.addFuel(fuelToAdd);
                if (!this.m_9236_().f_46443_) {
                    itemInHand.m_41774_(1);
                }
                this.m_5496_((SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.blaze.shoot")), 0.15f, 1.0f);
                for (int i = 0; i < 10; ++i) {
                    Random random = new Random();
                    double offsetX = (random.nextDouble() - 0.5) * 2.0;
                    double offsetZ = (random.nextDouble() - 0.5) * 2.0;
                    double particleX = this.m_20185_() + offsetX;
                    double particleY = this.m_20186_() + 0.5;
                    double particleZ = this.m_20189_() + offsetZ;
                    this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123762_, particleX, particleY, particleZ, 0.0, 0.05, 0.0);
                    this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_175834_, particleX, particleY, particleZ, 0.0, 0.03, 0.0);
                }
                return InteractionResult.SUCCESS;
            }
        }
        super.m_6071_(sourceentity, hand);
        sourceentity.m_20329_((Entity)this);
        return retval;
    }

    private void addFuel(int amount) {
        this.f_19804_.m_135381_(DATA_FUEL, (Object)(this.getFuel() + amount));
    }

    private void setFuel(int amount) {
        this.f_19804_.m_135381_(DATA_FUEL, (Object)amount);
    }

    public boolean isFuelOver() {
        return (Boolean)this.f_19804_.m_135370_(DATA_FUEL_OVER);
    }

    public void setFuelOver(boolean value) {
        this.f_19804_.m_135381_(DATA_FUEL_OVER, (Object)value);
    }

    public int getFuel() {
        return (Integer)this.f_19804_.m_135370_(DATA_FUEL);
    }

    public int getMaxFuel() {
        return this.MaxFuelfuelAmount;
    }

    public boolean getfuelOverCheck() {
        return this.fuelOverCheck;
    }

    private void spawnColorParticles(String colorName) {
        if (this.m_9236_().f_46443_) {
            Vec3 pos = this.m_20182_().m_82520_(0.0, 0.5, 0.0);
            RandomSource random = this.m_9236_().f_46441_;
            Vec3 rgb = this.getRGBFromColorName(colorName);
            for (int i = 0; i < 20; ++i) {
                double offsetX = (random.m_188500_() - 0.5) * 2.5;
                double offsetY = random.m_188500_() * 0.3;
                double offsetZ = (random.m_188500_() - 0.5) * 2.5;
                this.m_9236_().m_7106_((ParticleOptions)new DustParticleOptions(new Vector3f((float)rgb.f_82479_, (float)rgb.f_82480_, (float)rgb.f_82481_), 1.0f), pos.f_82479_ + offsetX, pos.f_82480_ + offsetY, pos.f_82481_ + offsetZ, 0.0, 0.02, 0.0);
            }
        }
    }

    private Vec3 getRGBFromColorName(String colorName) {
        return switch (colorName) {
            case "red" -> new Vec3(1.0, 0.6, 0.6);
            case "blue" -> new Vec3(0.6, 0.6, 1.0);
            case "green" -> new Vec3(0.6, 1.0, 0.6);
            case "yellow" -> new Vec3(1.0, 1.0, 0.6);
            case "black" -> new Vec3(0.3, 0.3, 0.3);
            case "white" -> new Vec3(1.0, 1.0, 1.0);
            case "orange" -> new Vec3(1.0, 0.8, 0.6);
            case "magenta" -> new Vec3(1.0, 0.6, 1.0);
            case "light_blue" -> new Vec3(0.7, 0.8, 1.0);
            case "lime" -> new Vec3(0.7, 1.0, 0.7);
            case "pink" -> new Vec3(1.0, 0.7, 0.8);
            case "gray" -> new Vec3(0.6, 0.6, 0.6);
            case "light_gray" -> new Vec3(0.8, 0.8, 0.8);
            case "cyan" -> new Vec3(0.6, 1.0, 1.0);
            case "purple" -> new Vec3(0.8, 0.6, 1.0);
            case "brown" -> new Vec3(0.8, 0.6, 0.5);
            default -> new Vec3(1.0, 1.0, 1.0);
        };
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SHOOT, (Object)false);
        this.f_19804_.m_135372_(ANIMATION, (Object)"undefined");
        this.f_19804_.m_135372_(TEXTURE, (Object)"kart_red");
        this.f_19804_.m_135372_(DATA_FUEL, (Object)0);
        this.f_19804_.m_135372_(DATA_FUEL_OVER, (Object)false);
        this.f_19804_.m_135372_(DATA_COLOR, (Object)"red");
    }

    public void setTexture(String texture) {
        this.f_19804_.m_135381_(TEXTURE, (Object)texture);
    }

    public String getTexture() {
        String kartColor = (String)this.f_19804_.m_135370_(DATA_COLOR);
        if (kartColor == null || kartColor.isEmpty()) {
            return "kart_red";
        }
        return "kart_" + kartColor;
    }

    public void setColor(String color) {
        this.f_19804_.m_135381_(DATA_COLOR, (Object)color);
    }

    public String getColor() {
        return (String)this.f_19804_.m_135370_(DATA_COLOR);
    }

    public ResourceLocation getTextureResource(KartEntity entity) {
        return new ResourceLocation("create_kart", "textures/entities/kart_dyeing/" + entity.getTexture() + ".png");
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected void m_8099_() {
        super.m_8099_();
    }

    public MobType m_6336_() {
        return MobType.f_21640_;
    }

    public double m_6048_() {
        return super.m_6048_() + -0.9;
    }

    protected void m_7472_(DamageSource source, int looting, boolean recentlyHitIn) {
        super.m_7472_(source, looting, recentlyHitIn);
    }

    public void m_7355_(BlockPos pos, BlockState blockIn) {
        this.m_5496_((SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("create_kart:kart_stay_2s")), 0.15f, 1.0f);
    }

    public boolean m_6469_(DamageSource source, float amount) {
        this.hurtAnimation = true;
        if (source.m_276093_(DamageTypes.f_268631_)) {
            return false;
        }
        if (source.m_7640_() instanceof AbstractArrow) {
            return false;
        }
        if (source.m_7640_() instanceof ThrownPotion || source.m_7640_() instanceof AreaEffectCloud) {
            return false;
        }
        if (source.m_276093_(DamageTypes.f_268671_)) {
            return false;
        }
        if (source.m_276093_(DamageTypes.f_268585_)) {
            return false;
        }
        if (source.m_276093_(DamageTypes.f_268722_)) {
            return false;
        }
        if (source.m_276093_(DamageTypes.f_268482_)) {
            return false;
        }
        if (source.m_276093_(DamageTypes.f_268493_)) {
            return false;
        }
        if (source.m_276093_(DamageTypes.f_268641_)) {
            return false;
        }
        return super.m_6469_(source, amount);
    }

    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction side) {
        if (this.m_6084_() && capability == ForgeCapabilities.ITEM_HANDLER && side == null) {
            return LazyOptional.of(() -> this.combined).cast();
        }
        return super.getCapability(capability, side);
    }

    protected void m_5907_() {
        super.m_5907_();
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            ItemStack itemstack = this.inventory.getStackInSlot(i);
            if (itemstack.m_41619_() || EnchantmentHelper.m_44924_((ItemStack)itemstack)) continue;
            this.m_19983_(itemstack);
        }
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128365_("InventoryCustom", (Tag)this.inventory.serializeNBT());
        compound.m_128359_("Texture", this.getTexture());
        compound.m_128359_("KartColor", this.getColor());
        compound.m_128405_("Fuel", this.getFuel());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        Tag inventoryCustom = compound.m_128423_("InventoryCustom");
        if (inventoryCustom instanceof CompoundTag) {
            CompoundTag inventoryTag = (CompoundTag)inventoryCustom;
            this.inventory.deserializeNBT(inventoryTag);
        }
        if (compound.m_128441_("Texture")) {
            this.setTexture(compound.m_128461_("Texture"));
        }
        if (compound.m_128441_("KartColor")) {
            this.setColor(compound.m_128461_("KartColor"));
        }
        if (compound.m_128441_("Fuel")) {
            this.setFuel(compound.m_128451_("Fuel"));
            System.out.println("Fuel r\u00e9tablie : " + this.getFuel());
        } else {
            System.out.println("Aucun fuel trouv\u00e9 dans le NBT !");
        }
    }

    public void m_6075_() {
        super.m_6075_();
        this.m_6210_();
        if (this.hurtAnimation) {
            ++this.hurtTimeAnim;
            if (this.hurtTimeAnim == 20) {
                this.hurtAnimation = false;
                this.hurtTimeAnim = 0;
            }
        }
        if (!this.m_9236_().f_46443_) {
            if (this.ticksSinceLoad < 20) {
                ++this.ticksSinceLoad;
                return;
            }
            Vec3 currentPosition = this.m_20182_();
            if (this.lastPosition.equals((Object)Vec3.f_82478_)) {
                this.lastPosition = currentPosition;
                return;
            }
            double distanceTravelled = this.lastPosition.m_82554_(currentPosition);
            if (distanceTravelled > 0.0) {
                double fuelConsumed = distanceTravelled * (double)this.Fuel_Consumption;
                this.addFuel(-((int)fuelConsumed));
            }
            if (this.getFuel() <= 0) {
                this.setFuel(0);
                this.m_20334_(0.0, this.m_20184_().f_82480_, 0.0);
                this.setFuelOver(true);
            } else {
                this.setFuelOver(false);
            }
            this.lastPosition = currentPosition;
        }
        ++this.fuelOverTimer;
        if (this.fuelOverTimer >= 10) {
            this.fuelOverTimer = 0;
            this.fuelOverCheck = !this.fuelOverCheck;
        }
    }

    public EntityDimensions m_6972_(Pose p_33597_) {
        return super.m_6972_(p_33597_).m_20388_(1.0f);
    }

    public void m_7023_(Vec3 dir) {
        if (!this.OldMovementCheck) {
            Entity entity = this.m_20197_().isEmpty() ? null : (Entity)this.m_20197_().get(0);
            float RotationStrength = (float)ConfigCreateKart.CONFIG_ROTATION_STRENGTH;
            if (this.m_20160_()) {
                double d0;
                double d1;
                float f1;
                this.m_146926_(entity.m_146909_() * 0.1f);
                this.m_19915_(this.m_146908_(), this.m_146909_());
                if (entity instanceof LivingEntity) {
                    LivingEntity passenger = (LivingEntity)entity;
                    this.m_7910_((float)this.m_21133_(Attributes.f_22279_));
                    float forward = passenger.f_20902_;
                    float strafe = passenger.f_20900_;
                    if (forward < 0.0f) {
                        this.m_146922_(this.m_146908_() + strafe * RotationStrength);
                    } else if (strafe != 0.0f) {
                        this.m_146922_(this.m_146908_() - strafe * RotationStrength);
                        this.f_19859_ = this.m_146908_();
                        this.f_20883_ = this.m_146908_();
                    }
                    super.m_7023_(new Vec3(0.0, 0.0, (double)forward));
                }
                if ((f1 = (float)Math.sqrt((d1 = this.m_20185_() - this.f_19854_) * d1 + (d0 = this.m_20189_() - this.f_19856_) * d0) * 4.0f) > 1.0f) {
                    f1 = 1.0f;
                }
                this.f_267362_.m_267771_(this.f_267362_.m_267731_() + (f1 - this.f_267362_.m_267731_()) * 0.4f);
                this.f_267362_.m_267590_(this.f_267362_.m_267756_() + this.f_267362_.m_267731_());
                this.m_267651_(true);
                return;
            }
            super.m_7023_(dir);
        } else if (this.OldMovementCheck) {
            Entity entity;
            Entity entity2 = entity = this.m_20197_().isEmpty() ? null : (Entity)this.m_20197_().get(0);
            if (this.m_20160_()) {
                double d0;
                double d1;
                float f1;
                this.m_146922_(entity.m_146908_());
                this.f_19859_ = this.m_146908_();
                this.m_146926_(entity.m_146909_() * 0.5f);
                this.m_19915_(this.m_146908_(), this.m_146909_());
                this.f_20883_ = entity.m_146908_();
                this.f_20885_ = entity.m_146908_();
                if (entity instanceof LivingEntity) {
                    LivingEntity passenger = (LivingEntity)entity;
                    this.m_7910_((float)this.m_21133_(Attributes.f_22279_));
                    float forward = passenger.f_20902_;
                    float strafe = 0.0f;
                    super.m_7023_(new Vec3((double)strafe, 0.0, (double)forward));
                }
                if ((f1 = (float)Math.sqrt((d1 = this.m_20185_() - this.f_19854_) * d1 + (d0 = this.m_20189_() - this.f_19856_) * d0) * 4.0f) > 1.0f) {
                    f1 = 1.0f;
                }
                this.f_267362_.m_267771_(this.f_267362_.m_267731_() + (f1 - this.f_267362_.m_267731_()) * 0.4f);
                this.f_267362_.m_267590_(this.f_267362_.m_267756_() + this.f_267362_.m_267731_());
                this.m_267651_(true);
                return;
            }
            super.m_7023_(dir);
        }
    }

    public void m_8107_() {
        super.m_8107_();
        this.m_21203_();
    }

    public static void init() {
    }

    public static AttributeSupplier.Builder createAttributes() {
        double Config_Mouvement_Speed = ConfigCreateKart.CONFIG_MOVEMENT_SPEED;
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22279_, Config_Mouvement_Speed);
        builder = builder.m_22268_(Attributes.f_22276_, 2.0);
        builder = builder.m_22268_(Attributes.f_22284_, 0.0);
        builder = builder.m_22268_(Attributes.f_22281_, 0.0);
        builder = builder.m_22268_(Attributes.f_22277_, 0.0);
        builder = builder.m_22268_(Attributes.f_22278_, 1000.0);
        return builder;
    }

    private PlayState movementPredicate(AnimationState event) {
        if (this.animationprocedure.equals("empty")) {
            Entity entity;
            Entity entity2 = entity = this.m_20197_().isEmpty() ? null : (Entity)this.m_20197_().get(0);
            if (entity instanceof LivingEntity) {
                LivingEntity passenger = (LivingEntity)entity;
                if (!this.isFuelOver()) {
                    if (passenger.f_20902_ > 0.0f) {
                        if (this.OldMovementCheck) {
                            return event.setAndContinue(RawAnimation.begin().thenLoop("animation.model.forward"));
                        }
                        if (!this.OldMovementCheck) {
                            if (passenger.f_20900_ == 0.0f) {
                                return event.setAndContinue(RawAnimation.begin().thenLoop("animation.model.forward"));
                            }
                            if (passenger.f_20900_ < 0.0f) {
                                return event.setAndContinue(RawAnimation.begin().thenLoop("animation.model.right_fwd"));
                            }
                            if (passenger.f_20900_ > 0.0f) {
                                return event.setAndContinue(RawAnimation.begin().thenLoop("animation.model.left_fwd"));
                            }
                        }
                    }
                    if (passenger.f_20902_ < 0.0f) {
                        if (this.OldMovementCheck) {
                            return event.setAndContinue(RawAnimation.begin().thenLoop("animation.model.backward"));
                        }
                        if (!this.OldMovementCheck) {
                            if (passenger.f_20900_ == 0.0f) {
                                return event.setAndContinue(RawAnimation.begin().thenLoop("animation.model.backward"));
                            }
                            if (passenger.f_20900_ < 0.0f) {
                                return event.setAndContinue(RawAnimation.begin().thenLoop("animation.model.right_bckwd"));
                            }
                            if (passenger.f_20900_ > 0.0f) {
                                return event.setAndContinue(RawAnimation.begin().thenLoop("animation.model.left_bckwd"));
                            }
                        }
                    }
                }
                if (this.isFuelOver()) {
                    if (passenger.f_20902_ > 0.0f) {
                        if (this.OldMovementCheck) {
                            return event.setAndContinue(RawAnimation.begin().thenLoop("animation.model.forward_FuelOver"));
                        }
                        if (!this.OldMovementCheck) {
                            if (passenger.f_20900_ == 0.0f) {
                                return event.setAndContinue(RawAnimation.begin().thenLoop("animation.model.forward_FuelOver"));
                            }
                            if (passenger.f_20900_ < 0.0f) {
                                return event.setAndContinue(RawAnimation.begin().thenLoop("animation.model.right_fwd_FuelOver"));
                            }
                            if (passenger.f_20900_ > 0.0f) {
                                return event.setAndContinue(RawAnimation.begin().thenLoop("animation.model.left_fwd_FuelOver"));
                            }
                        }
                    }
                    if (passenger.f_20902_ < 0.0f) {
                        if (this.OldMovementCheck) {
                            return event.setAndContinue(RawAnimation.begin().thenLoop("animation.model.backward_FuelOver"));
                        }
                        if (!this.OldMovementCheck) {
                            if (passenger.f_20900_ == 0.0f) {
                                return event.setAndContinue(RawAnimation.begin().thenLoop("animation.model.backward_FuelOver"));
                            }
                            if (passenger.f_20900_ < 0.0f) {
                                return event.setAndContinue(RawAnimation.begin().thenLoop("animation.model.right_bckwd_FuelOver"));
                            }
                            if (passenger.f_20900_ > 0.0f) {
                                return event.setAndContinue(RawAnimation.begin().thenLoop("animation.model.left_bckwd_FuelOver"));
                            }
                        }
                    }
                }
            }
            if (this.m_21224_()) {
                return event.setAndContinue(RawAnimation.begin().thenPlay("animation.model.break"));
            }
            if (this.hurtAnimation) {
                return event.setAndContinue(RawAnimation.begin().thenPlay("animation.model.hurt"));
            }
            return event.setAndContinue(RawAnimation.begin().thenLoop("animation.model.stay"));
        }
        return PlayState.STOP;
    }

    private PlayState procedurePredicate(AnimationState event) {
        if (!this.animationprocedure.equals("empty") && event.getController().getAnimationState() == AnimationController.State.STOPPED || !this.animationprocedure.equals(this.prevAnim) && !this.animationprocedure.equals("empty")) {
            if (!this.animationprocedure.equals(this.prevAnim)) {
                event.getController().forceAnimationReset();
            }
            event.getController().setAnimation(RawAnimation.begin().thenPlay(this.animationprocedure));
            if (event.getController().getAnimationState() == AnimationController.State.STOPPED) {
                this.animationprocedure = "empty";
                event.getController().forceAnimationReset();
            }
        } else if (this.animationprocedure.equals("empty")) {
            this.prevAnim = "empty";
            return PlayState.STOP;
        }
        this.prevAnim = this.animationprocedure;
        return PlayState.CONTINUE;
    }

    protected void m_6153_() {
        ++this.f_20919_;
        if (this.f_20919_ == 20) {
            int remainingFuel;
            int coalDrop;
            String kartColor;
            this.m_142687_(Entity.RemovalReason.KILLED);
            this.m_21226_();
            Item kartItem = switch (kartColor = (String)this.f_19804_.m_135370_(DATA_COLOR)) {
                case "blue" -> (Item)CreateKartModItems.KART_BLUE.get();
                case "green" -> (Item)CreateKartModItems.KART_GREEN.get();
                case "yellow" -> (Item)CreateKartModItems.KART_YELLOW.get();
                case "black" -> (Item)CreateKartModItems.KART_BLACK.get();
                case "white" -> (Item)CreateKartModItems.KART_WHITE.get();
                case "orange" -> (Item)CreateKartModItems.KART_ORANGE.get();
                case "magenta" -> (Item)CreateKartModItems.KART_MAGENTA.get();
                case "light_blue" -> (Item)CreateKartModItems.KART_LIGHT_BLUE.get();
                case "lime" -> (Item)CreateKartModItems.KART_LIME.get();
                case "pink" -> (Item)CreateKartModItems.KART_PINK.get();
                case "gray" -> (Item)CreateKartModItems.KART_GRAY.get();
                case "light_gray" -> (Item)CreateKartModItems.KART_LIGHT_GRAY.get();
                case "cyan" -> (Item)CreateKartModItems.KART_CYAN.get();
                case "purple" -> (Item)CreateKartModItems.KART_PURPLE.get();
                case "brown" -> (Item)CreateKartModItems.KART_BROWN.get();
                default -> (Item)CreateKartModItems.KART_RED.get();
            };
            this.m_19983_(new ItemStack((ItemLike)kartItem));
            if (this.getFuel() > 0 && (coalDrop = (remainingFuel = this.getFuel()) / 250) > 0) {
                this.m_19983_(new ItemStack((ItemLike)Items.f_42413_, coalDrop));
            }
        }
    }

    public String getSyncedAnimation() {
        return (String)this.f_19804_.m_135370_(ANIMATION);
    }

    public void setAnimation(String animation) {
        this.f_19804_.m_135381_(ANIMATION, (Object)animation);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        data.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "movement", 4, this::movementPredicate)});
        data.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "procedure", 4, this::procedurePredicate)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

