/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.data.loadable.array;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import java.util.Arrays;
import java.util.function.Function;
import net.minecraft.network.FriendlyByteBuf;
import slimeknights.mantle.data.loadable.Loadable;
import slimeknights.mantle.data.loadable.array.ArrayLoadable;
import slimeknights.mantle.data.loadable.field.DefaultingField;
import slimeknights.mantle.data.loadable.field.LoadableField;
import slimeknights.mantle.util.typed.TypedMap;

public record BooleanArrayLoadable(Loadable<Boolean> base, int minSize, int maxSize) implements ArrayLoadable.SizeRange<boolean[]>
{
    @Override
    public int getLength(boolean[] array) {
        return array.length;
    }

    @Override
    public boolean[] convertCompact(JsonElement element, String key, TypedMap context) {
        return new boolean[]{this.base.convert(element, key, context)};
    }

    @Override
    public boolean[] convertArray(JsonArray array, String key, TypedMap context) {
        boolean[] result = new boolean[array.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.base.convert(array.get(i), key + "[" + i + "]", context);
        }
        return result;
    }

    @Override
    public JsonElement serializeFirst(boolean[] object) {
        return this.base.serialize(object[0]);
    }

    @Override
    public void serializeAll(JsonArray array, boolean[] object) {
        for (boolean element : object) {
            array.add(this.base.serialize(element));
        }
    }

    @Override
    public boolean[] decode(FriendlyByteBuf buffer, TypedMap context) {
        int max = buffer.m_130242_();
        boolean[] array = new boolean[max];
        for (int i = 0; i < max; ++i) {
            array[i] = (Boolean)this.base.decode(buffer, context);
        }
        return array;
    }

    @Override
    public void encode(FriendlyByteBuf buffer, boolean[] array) {
        buffer.m_130130_(array.length);
        for (boolean element : array) {
            this.base.encode(buffer, element);
        }
    }

    @Override
    public <P> LoadableField<boolean[], P> defaultField(String key, boolean[] defaultValue, boolean serializeDefault, Function<P, boolean[]> getter) {
        return new DefaultingField<boolean[], P>(this, key, defaultValue, serializeDefault ? null : Arrays::equals, getter);
    }

    @Override
    public <P> LoadableField<boolean[], P> emptyField(String key, boolean serializeEmpty, Function<P, boolean[]> getter) {
        return this.defaultField(key, new boolean[0], serializeEmpty, getter);
    }
}

