/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.box;

import com.simibubi.create.AllEntityTypes;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.logistics.box.PackageEntity;
import com.simibubi.create.content.logistics.box.PackageStyles;
import com.simibubi.create.content.logistics.stockTicker.PackageOrderWithCrafts;
import java.lang.ref.WeakReference;
import java.util.List;
import javax.annotation.Nullable;
import net.createmod.catnip.data.Glob;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;

public class PackageItem
extends Item {
    public static final int SLOTS = 9;
    public PackageStyles.PackageStyle style;

    public PackageItem(Item.Properties properties, PackageStyles.PackageStyle style) {
        super(properties);
        this.style = style;
        PackageStyles.ALL_BOXES.add(this);
        (style.rare() ? PackageStyles.RARE_BOXES : PackageStyles.STANDARD_BOXES).add(this);
    }

    public String m_5524_() {
        return "item.create" + (this.style.rare() ? ".rare_package" : ".package");
    }

    public static boolean isPackage(ItemStack stack) {
        return stack.m_41720_() instanceof PackageItem;
    }

    public boolean m_142095_() {
        return false;
    }

    public boolean hasCustomEntity(ItemStack stack) {
        return true;
    }

    public Entity createEntity(Level world, Entity location, ItemStack itemstack) {
        return PackageEntity.fromDroppedItem(world, location, itemstack);
    }

    public static ItemStack containing(List<ItemStack> stacks) {
        ItemStackHandler newInv = new ItemStackHandler(9);
        stacks.forEach(s -> ItemHandlerHelper.insertItemStacked((IItemHandler)newInv, (ItemStack)s, (boolean)false));
        return PackageItem.containing(newInv);
    }

    public static ItemStack containing(ItemStackHandler stacks) {
        ItemStack box = PackageStyles.getRandomBox();
        CompoundTag compound = new CompoundTag();
        compound.m_128365_("Items", (Tag)stacks.serializeNBT());
        box.m_41751_(compound);
        return box;
    }

    public static void clearAddress(ItemStack box) {
        if (box.m_41782_()) {
            box.m_41783_().m_128473_("Address");
        }
    }

    public static void addAddress(ItemStack box, String address) {
        box.m_41784_().m_128359_("Address", address);
    }

    public static void setOrder(ItemStack box, int orderId, int linkIndex, boolean isFinalLink, int fragmentIndex, boolean isFinal, @Nullable PackageOrderWithCrafts orderContext) {
        CompoundTag tag = new CompoundTag();
        tag.m_128405_("OrderId", orderId);
        tag.m_128405_("LinkIndex", linkIndex);
        tag.m_128379_("IsFinalLink", isFinalLink);
        tag.m_128405_("Index", fragmentIndex);
        tag.m_128379_("IsFinal", isFinal);
        if (orderContext != null) {
            tag.m_128365_("OrderContext", (Tag)orderContext.write());
        }
        box.m_41784_().m_128365_("Fragment", (Tag)tag);
    }

    public static int getOrderId(ItemStack box) {
        CompoundTag tag = box.m_41783_();
        if (tag == null || !tag.m_128441_("Fragment")) {
            return -1;
        }
        return tag.m_128469_("Fragment").m_128451_("OrderId");
    }

    @Nullable
    public static PackageOrderWithCrafts getOrderContext(ItemStack box) {
        CompoundTag tag = box.m_41783_();
        if (tag == null || !tag.m_128441_("Fragment")) {
            return null;
        }
        CompoundTag frag = tag.m_128469_("Fragment");
        if (!frag.m_128441_("OrderContext")) {
            return null;
        }
        return PackageOrderWithCrafts.read(frag.m_128469_("OrderContext"));
    }

    public static void addOrderContext(ItemStack box, PackageOrderWithCrafts orderContext) {
        CompoundTag tag = box.m_41698_("Fragment");
        if (orderContext != null) {
            tag.m_128365_("OrderContext", (Tag)orderContext.write());
        }
        box.m_41784_().m_128365_("Fragment", (Tag)tag);
    }

    public static boolean matchAddress(ItemStack box, String address) {
        return PackageItem.matchAddress(PackageItem.getAddress(box), address);
    }

    public static boolean matchAddress(String boxAddress, String address) {
        if (address.isBlank()) {
            return boxAddress.isBlank();
        }
        if (address.equals("*") || boxAddress.equals("*")) {
            return true;
        }
        String matcher = Glob.toRegexPattern((String)address, (String)"");
        String boxMatcher = Glob.toRegexPattern((String)boxAddress, (String)"");
        return address.matches(boxMatcher) || boxAddress.matches(matcher);
    }

    public static String getAddress(ItemStack box) {
        String boxAddress = !box.m_41782_() ? "" : box.m_41783_().m_128461_("Address");
        return boxAddress;
    }

    public static float getWidth(ItemStack box) {
        Item item = box.m_41720_();
        if (item instanceof PackageItem) {
            PackageItem pi = (PackageItem)item;
            return (float)pi.style.width() / 16.0f;
        }
        return 1.0f;
    }

    public static float getHeight(ItemStack box) {
        Item item = box.m_41720_();
        if (item instanceof PackageItem) {
            PackageItem pi = (PackageItem)item;
            return (float)pi.style.height() / 16.0f;
        }
        return 1.0f;
    }

    public static float getHookDistance(ItemStack box) {
        Item item = box.m_41720_();
        if (item instanceof PackageItem) {
            PackageItem pi = (PackageItem)item;
            return pi.style.riggingOffset() / 16.0f;
        }
        return 1.0f;
    }

    public static ItemStackHandler getContents(ItemStack box) {
        ItemStackHandler newInv = new ItemStackHandler(9);
        CompoundTag invNBT = box.m_41698_("Items");
        if (!invNBT.m_128456_()) {
            newInv.deserializeNBT(invNBT);
        }
        return newInv;
    }

    public void m_7373_(ItemStack pStack, Level pLevel, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        super.m_7373_(pStack, pLevel, pTooltipComponents, pIsAdvanced);
        CompoundTag compoundnbt = pStack.m_41784_();
        if (compoundnbt.m_128425_("Address", 8) && !compoundnbt.m_128461_("Address").isBlank()) {
            pTooltipComponents.add((Component)Component.m_237113_((String)("\u2192 " + compoundnbt.m_128461_("Address"))).m_130940_(ChatFormatting.GOLD));
        }
        if (!compoundnbt.m_128425_("Items", 10)) {
            return;
        }
        int visibleNames = 0;
        int skippedNames = 0;
        ItemStackHandler contents = PackageItem.getContents(pStack);
        for (int i = 0; i < contents.getSlots(); ++i) {
            ItemStack itemstack = contents.getStackInSlot(i);
            if (itemstack.m_41619_() || itemstack.m_41720_() instanceof SpawnEggItem) continue;
            if (visibleNames > 2) {
                ++skippedNames;
                continue;
            }
            ++visibleNames;
            pTooltipComponents.add((Component)itemstack.m_41786_().m_6881_().m_130946_(" x").m_130946_(String.valueOf(itemstack.m_41613_())).m_130940_(ChatFormatting.GRAY));
        }
        if (skippedNames > 0) {
            pTooltipComponents.add((Component)Component.m_237110_((String)"container.shulkerBox.more", (Object[])new Object[]{skippedNames}).m_130940_(ChatFormatting.ITALIC));
        }
    }

    public int m_8105_(ItemStack p_77626_1_) {
        return 72000;
    }

    public UseAnim m_6164_(ItemStack pStack) {
        return UseAnim.BOW;
    }

    public InteractionResultHolder<ItemStack> open(Level worldIn, Player playerIn, InteractionHand handIn) {
        ItemStack box = playerIn.m_21120_(handIn);
        ItemStackHandler contents = PackageItem.getContents(box);
        ItemStack particle = box.m_41777_();
        playerIn.m_21008_(handIn, box.m_41613_() <= 1 ? ItemStack.f_41583_ : box.m_255036_(box.m_41613_() - 1));
        if (!worldIn.m_5776_()) {
            for (int i = 0; i < contents.getSlots(); ++i) {
                ItemStack itemstack = contents.getStackInSlot(i);
                if (itemstack.m_41619_()) continue;
                Item item = itemstack.m_41720_();
                if (item instanceof SpawnEggItem) {
                    SpawnEggItem sei = (SpawnEggItem)item;
                    if (worldIn instanceof ServerLevel) {
                        ServerLevel sl = (ServerLevel)worldIn;
                        EntityType entitytype = sei.m_43228_(itemstack.m_41783_());
                        Entity entity = entitytype.m_20592_(sl, itemstack, null, BlockPos.m_274446_((Position)playerIn.m_20182_().m_82549_(playerIn.m_20154_().m_82542_(1.0, 0.0, 1.0).m_82541_())), MobSpawnType.SPAWN_EGG, false, false);
                        if (entity != null) {
                            itemstack.m_41774_(1);
                        }
                    }
                }
                playerIn.m_150109_().m_150079_(itemstack.m_41777_());
            }
        }
        Vec3 position = playerIn.m_20182_();
        AllSoundEvents.PACKAGE_POP.playOnServer(worldIn, (Vec3i)playerIn.m_20183_());
        if (worldIn.m_5776_()) {
            for (int i = 0; i < 10; ++i) {
                Vec3 motion = VecHelper.offsetRandomly((Vec3)Vec3.f_82478_, (RandomSource)worldIn.m_213780_(), (float)0.125f);
                Vec3 pos = position.m_82520_(0.0, 0.5, 0.0).m_82549_(playerIn.m_20154_().m_82490_(0.5)).m_82549_(motion.m_82490_(4.0));
                worldIn.m_7106_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, particle), pos.f_82479_, pos.f_82480_, pos.f_82481_, motion.f_82479_, motion.f_82480_, motion.f_82481_);
            }
        }
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)box);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        if (context.m_43723_().m_6144_()) {
            return this.open(context.m_43725_(), context.m_43723_(), context.m_43724_()).m_19089_();
        }
        Vec3 point = context.m_43720_();
        float h = (float)this.style.height() / 16.0f;
        float r = (float)this.style.width() / 2.0f / 16.0f;
        if (context.m_43719_() == Direction.DOWN) {
            point = point.m_82492_(0.0, (double)(h + 0.25f), 0.0);
        } else if (context.m_43719_().m_122434_().m_122479_()) {
            point = point.m_82549_(Vec3.m_82528_((Vec3i)context.m_43719_().m_122436_()).m_82490_((double)r));
        }
        AABB scanBB = new AABB(point, point).m_82377_((double)r, 0.0, (double)r).m_82363_(0.0, (double)h, 0.0);
        Level world = context.m_43725_();
        if (!world.m_142425_((EntityTypeTest)AllEntityTypes.PACKAGE.get(), scanBB, e -> true).isEmpty()) {
            return super.m_6225_(context);
        }
        PackageEntity packageEntity = new PackageEntity(world, point.f_82479_, point.f_82480_, point.f_82481_);
        ItemStack itemInHand = context.m_43722_();
        packageEntity.setBox(itemInHand.m_41777_());
        world.m_7967_((Entity)packageEntity);
        itemInHand.m_41774_(1);
        return InteractionResult.SUCCESS;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        if (player.m_6144_()) {
            return this.open(world, player, hand);
        }
        ItemStack itemstack = player.m_21120_(hand);
        player.m_6672_(hand);
        return InteractionResultHolder.m_19090_((Object)itemstack);
    }

    public void m_5551_(ItemStack stack, Level world, LivingEntity entity, int ticks) {
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        int i = this.m_8105_(stack) - ticks;
        if (i < 0) {
            return;
        }
        float f = PackageItem.getPackageVelocity(i);
        if ((double)f < 0.1) {
            return;
        }
        if (world.f_46443_) {
            return;
        }
        world.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12473_, SoundSource.NEUTRAL, 0.5f, 0.5f);
        ItemStack copy = stack.m_41777_();
        if (!player.m_150110_().f_35937_) {
            stack.m_41774_(1);
        }
        Vec3 vec = new Vec3(entity.m_20185_(), entity.m_20186_() + entity.m_20191_().m_82376_() / 2.0, entity.m_20189_());
        Vec3 motion = entity.m_20154_().m_82490_((double)(f * 2.0f));
        vec = vec.m_82549_(motion);
        PackageEntity packageEntity = new PackageEntity(world, vec.f_82479_, vec.f_82480_, vec.f_82481_);
        packageEntity.setBox(copy);
        packageEntity.m_20256_(motion);
        packageEntity.tossedBy = new WeakReference<Player>(player);
        world.m_7967_((Entity)packageEntity);
    }

    public static float getPackageVelocity(int p_185059_0_) {
        float f = (float)p_185059_0_ / 20.0f;
        if ((f = (f * f + f * 2.0f) / 3.0f) > 1.0f) {
            f = 1.0f;
        }
        return f;
    }
}

