/*
 * Decompiled with CFR 0.152.
 */
package immersive_melodies.item;

import immersive_melodies.Common;
import immersive_melodies.Config;
import immersive_melodies.Sounds;
import immersive_melodies.client.MelodyProgress;
import immersive_melodies.client.MelodyProgressManager;
import immersive_melodies.client.sound.CancelableSoundInstance;
import immersive_melodies.network.Network;
import immersive_melodies.network.s2c.MelodyListMessage;
import immersive_melodies.network.s2c.OpenGuiRequest;
import immersive_melodies.resources.Melody;
import immersive_melodies.resources.Note;
import immersive_melodies.resources.ServerMelodyManager;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class InstrumentItem
extends Item {
    public static final String TAG_PLAYING = "playing";
    public static final String TAG_MELODY = "melody";
    public static final String TAG_START_TIME = "start_time";
    public static final String TAG_TRACKS = "enabled_tracks";
    private final Sounds.Instrument sound;
    private final long sustain;
    private final Vector3f offset;

    public InstrumentItem(Item.Properties settings, Sounds.Instrument sound, long sustain, Vector3f offset) {
        super(settings);
        this.sound = sound;
        this.sustain = sustain;
        this.offset = offset;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player user, InteractionHand hand) {
        if (!world.f_46443_) {
            Network.sendToPlayer(new MelodyListMessage(user), (ServerPlayer)user);
            Network.sendToPlayer(new OpenGuiRequest(OpenGuiRequest.Type.SELECTOR), (ServerPlayer)user);
        }
        return super.m_7203_(world, user, hand);
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag context) {
        if (this.isPlaying(stack)) {
            tooltip.add((Component)Component.m_237115_((String)"immersive_melodies.playing").m_130940_(ChatFormatting.GREEN));
        }
        super.m_7373_(stack, world, tooltip, context);
    }

    public boolean isPlaying(ItemStack stack) {
        return stack.m_41784_().m_128471_(TAG_PLAYING);
    }

    public void inventoryClientTick(ItemStack stack, Level world, Entity entity) {
        boolean isPrimary = false;
        for (ItemStack handItem : entity.m_6167_()) {
            if (handItem == stack) {
                isPrimary = true;
                break;
            }
            if (!(handItem.m_41720_() instanceof InstrumentItem)) continue;
            break;
        }
        if (this.isPlaying(stack) && isPrimary && world.f_46443_ && Common.soundManager.audible(entity)) {
            MelodyProgress progress = MelodyProgressManager.INSTANCE.getProgress(entity);
            progress.tick(stack);
            MelodyProgressManager.INSTANCE.sync(world.m_46467_());
            Melody melody = progress.getMelody();
            Set<Integer> enabledTracks = this.getEnabledTracks(stack);
            block1: for (int track = 0; track < melody.getTracks().size(); ++track) {
                int lastIndex = MelodyProgressManager.INSTANCE.getProgress(entity).getLastIndex(track);
                List<Note> notes = melody.getTracks().get(track).getNotes();
                for (int i = lastIndex; i < notes.size(); ++i) {
                    Note note = notes.get(i);
                    if (progress.getTime() >= (long)note.getTime()) {
                        if (enabledTracks.isEmpty() || enabledTracks.contains(track)) {
                            this.playNote(entity, note, progress.getTime());
                        }
                        if (i != notes.size() - 1) continue;
                        MelodyProgressManager.INSTANCE.setLastIndex(entity, track, i + 1);
                        continue;
                    }
                    MelodyProgressManager.INSTANCE.setLastIndex(entity, track, i);
                    continue block1;
                }
            }
            if (progress.getTime() > (long)melody.getLength()) {
                this.rewind(stack, world);
            }
        }
    }

    public CancelableSoundInstance playNote(Entity entity, Note note, long time) {
        int octave;
        float volume = (float)note.getVelocity() / 255.0f * 2.0f * Config.getInstance().instrumentVolumeFactor;
        float pitch = (float)Math.pow(2.0, (double)(note.getNote() - 24) / 12.0);
        for (octave = 1; octave < 8 && (double)pitch > 1.3333333333333333; ++octave) {
            pitch /= 2.0f;
        }
        long length = note.getLength();
        long sustain = Math.min(this.sustain, (long)note.getSustain());
        float factor = Config.getInstance().perceivedLoudnessAdjustmentFactor;
        float adjustedVolume = (float)((double)volume / Math.sqrt((double)pitch * Math.pow(2.0, octave - 4)));
        volume = volume * (1.0f - factor) + adjustedVolume * factor;
        CancelableSoundInstance soundInstance = Common.soundManager.playSound(entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), this.sound.get(octave), SoundSource.NEUTRAL, volume, pitch, length, sustain, (long)note.getTime() - time, entity);
        if (entity instanceof Player && Config.getInstance().stopGameMusicForPlayers) {
            Common.soundManager.pauseGameMusic();
        } else if (Config.getInstance().stopGameMusicForMobs) {
            Common.soundManager.pauseGameMusic();
        }
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            if (!Common.soundManager.isFirstPerson(entity)) {
                double x = Math.sin((double)(-livingEntity.f_20883_) / 180.0 * Math.PI);
                double z = Math.cos((double)(-livingEntity.f_20883_) / 180.0 * Math.PI);
                entity.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123758_, entity.m_20185_() + x * (double)this.offset.z + z * (double)this.offset.x, entity.m_20186_() + (double)entity.m_20206_() / 2.0 + (double)this.offset.y, entity.m_20189_() + z * (double)this.offset.z - x * (double)this.offset.x, x * 5.0, 0.0, z * 5.0);
            }
        }
        MelodyProgressManager.INSTANCE.setLastNote(entity, volume, pitch, length);
        return soundInstance;
    }

    public void inventoryServerTick(ItemStack stack, ServerLevel world, Entity entity) {
        if (!(entity instanceof Player) && !this.isPlaying(stack)) {
            ResourceLocation randomMelody = ServerMelodyManager.getRandomMelody();
            this.play(stack, randomMelody, (Level)world, entity);
        }
    }

    public void play(ItemStack stack, ResourceLocation melody, Level world, Entity entity) {
        stack.m_41784_().m_128359_(TAG_MELODY, melody.toString());
        stack.m_41784_().m_128379_(TAG_PLAYING, true);
        stack.m_41784_().m_128356_(TAG_START_TIME, world.m_46467_());
        this.refreshTracks(stack, entity);
    }

    public ResourceLocation getMelody(ItemStack stack) {
        return new ResourceLocation(stack.m_41784_().m_128461_(TAG_MELODY));
    }

    public void refreshTracks(ItemStack stack, Entity entity) {
        String identifier = ServerMelodyManager.getIdentifier(entity, BuiltInRegistries.f_257033_.m_7981_((Object)this));
        Set<Integer> enabledTracks = ServerMelodyManager.getSettings().getEnabledTracks(this.getMelody(stack), identifier);
        stack.m_41784_().m_128385_(TAG_TRACKS, enabledTracks.stream().mapToInt(i -> i).toArray());
    }

    public void rewind(ItemStack stack, Level world) {
        stack.m_41784_().m_128356_(TAG_START_TIME, world.m_46467_());
    }

    public void play(ItemStack stack) {
        stack.m_41784_().m_128379_(TAG_PLAYING, true);
    }

    public void pause(ItemStack stack) {
        stack.m_41784_().m_128379_(TAG_PLAYING, false);
    }

    public Set<Integer> getEnabledTracks(ItemStack stack) {
        if (!stack.m_41784_().m_128441_(TAG_TRACKS)) {
            return Set.of();
        }
        int[] array = stack.m_41784_().m_128465_(TAG_TRACKS);
        return Arrays.stream(array).boxed().collect(Collectors.toSet());
    }
}

