/*
 * Decompiled with CFR 0.152.
 */
package com.cerbon.beautiful_potions.mixin;

import com.cerbon.beautiful_potions.platform.Services;
import com.cerbon.beautiful_potions.potion.PotionType;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import net.minecraft.client.renderer.ItemModelShaper;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(value={ItemRenderer.class})
public class ItemRendererMixin {
    @Shadow
    @Final
    private ItemModelShaper f_115095_;

    @WrapOperation(method={"getModel"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/ItemModelShaper;getItemModel(Lnet/minecraft/world/item/ItemStack;)Lnet/minecraft/client/resources/model/BakedModel;")})
    private BakedModel getModel(ItemModelShaper instance, ItemStack stack, Operation<BakedModel> original) {
        String variant;
        String potionId;
        String basePotionId;
        if (!(stack.m_41720_() instanceof PotionItem)) {
            return (BakedModel)original.call(new Object[]{instance, stack});
        }
        Potion potion = PotionUtils.m_43579_((ItemStack)stack);
        ResourceLocation potionRL = BuiltInRegistries.f_256980_.m_7981_((Object)potion);
        PotionType potionType = PotionType.get(stack);
        String potionNamespace = potionRL.m_135827_();
        String modelPath = potionNamespace + ":" + (basePotionId = this.getBasePotionId(potionId = potionRL.m_135815_())) + "/" + (variant = this.getPotionVariant(potionId, potionType));
        ResourceLocation modelLocation = ResourceLocation.m_135820_((String)modelPath);
        if (modelLocation != null) {
            ModelManager modelManager = this.f_115095_.m_109393_();
            BakedModel model = Services.PLATFORM.getItemModel(modelLocation, modelManager);
            return model != null && model != modelManager.m_119409_() ? model : (BakedModel)original.call(new Object[]{instance, stack});
        }
        return (BakedModel)original.call(new Object[]{instance, stack});
    }

    @Unique
    private String getBasePotionId(String potionId) {
        if (potionId.startsWith("long_")) {
            return potionId.substring(5);
        }
        if (potionId.startsWith("strong_")) {
            return potionId.substring(7);
        }
        return potionId;
    }

    @Unique
    private String getPotionVariant(String potionId, PotionType potionType) {
        String typeString = potionType.toString().toLowerCase();
        if (potionId.startsWith("long_")) {
            return typeString + "_long";
        }
        if (potionId.startsWith("strong_")) {
            return typeString + "_strong";
        }
        return typeString.equals("normal") ? "normal" : typeString;
    }
}

