/*
 * Decompiled with CFR 0.152.
 */
package com.cak.pattern_schematics.foundation.mirror;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.simibubi.create.AllSpecialTextures;
import net.createmod.catnip.render.PonderRenderTypes;
import net.createmod.catnip.render.SuperRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;

public class StaticRenderers {
    protected static final Vector4f colorTemp1 = new Vector4f();
    protected static final Vector3f pos0Temp = new Vector3f();
    protected static final Vector3f pos1Temp = new Vector3f();
    protected static final Vector3f pos2Temp = new Vector3f();
    protected static final Vector3f pos3Temp = new Vector3f();
    protected static final Vector3f normalTemp = new Vector3f();
    protected static final Vector4f posTransformTemp = new Vector4f();
    protected static final Vector3f normalTransformTemp = new Vector3f();

    protected static void renderBoxFace(PoseStack.Pose pose, SuperRenderTypeBuffer buffer, boolean cull, boolean highlighted, Vector3f minPos, Vector3f maxPos, Direction face, Vector4f color, int lightmap) {
        RenderType renderType = PonderRenderTypes.outlineTranslucent((ResourceLocation)AllSpecialTextures.CHECKERED.getLocation(), (boolean)cull);
        VertexConsumer consumer = buffer.getLateBuffer(renderType);
        float alphaMult = highlighted ? 1.0f : 0.5f;
        colorTemp1.set(color.x(), color.y(), color.z(), color.w() * alphaMult);
        color = colorTemp1;
        StaticRenderers.renderBoxFace(pose, consumer, minPos, maxPos, face, color, lightmap);
    }

    protected static void renderBoxFace(PoseStack.Pose pose, VertexConsumer consumer, Vector3f minPos, Vector3f maxPos, Direction face, Vector4f color, int lightmap) {
        float maxV;
        float maxU;
        Vector3f pos0 = pos0Temp;
        Vector3f pos1 = pos1Temp;
        Vector3f pos2 = pos2Temp;
        Vector3f pos3 = pos3Temp;
        Vector3f normal = normalTemp;
        float minX = minPos.x();
        float minY = minPos.y();
        float minZ = minPos.z();
        float maxX = maxPos.x();
        float maxY = maxPos.y();
        float maxZ = maxPos.z();
        switch (face) {
            case DOWN: {
                pos0.set(minX, minY, maxZ);
                pos1.set(minX, minY, minZ);
                pos2.set(maxX, minY, minZ);
                pos3.set(maxX, minY, maxZ);
                maxU = maxX - minX;
                maxV = maxZ - minZ;
                normal.set(0.0f, -1.0f, 0.0f);
                break;
            }
            case UP: {
                pos0.set(minX, maxY, minZ);
                pos1.set(minX, maxY, maxZ);
                pos2.set(maxX, maxY, maxZ);
                pos3.set(maxX, maxY, minZ);
                maxU = maxX - minX;
                maxV = maxZ - minZ;
                normal.set(0.0f, 1.0f, 0.0f);
                break;
            }
            case NORTH: {
                pos0.set(maxX, maxY, minZ);
                pos1.set(maxX, minY, minZ);
                pos2.set(minX, minY, minZ);
                pos3.set(minX, maxY, minZ);
                maxU = maxX - minX;
                maxV = maxY - minY;
                normal.set(0.0f, 0.0f, -1.0f);
                break;
            }
            case SOUTH: {
                pos0.set(minX, maxY, maxZ);
                pos1.set(minX, minY, maxZ);
                pos2.set(maxX, minY, maxZ);
                pos3.set(maxX, maxY, maxZ);
                maxU = maxX - minX;
                maxV = maxY - minY;
                normal.set(0.0f, 0.0f, 1.0f);
                break;
            }
            case WEST: {
                pos0.set(minX, maxY, minZ);
                pos1.set(minX, minY, minZ);
                pos2.set(minX, minY, maxZ);
                pos3.set(minX, maxY, maxZ);
                maxU = maxZ - minZ;
                maxV = maxY - minY;
                normal.set(-1.0f, 0.0f, 0.0f);
                break;
            }
            case EAST: {
                pos0.set(maxX, maxY, maxZ);
                pos1.set(maxX, minY, maxZ);
                pos2.set(maxX, minY, minZ);
                pos3.set(maxX, maxY, minZ);
                maxU = maxZ - minZ;
                maxV = maxY - minY;
                normal.set(1.0f, 0.0f, 0.0f);
                break;
            }
            default: {
                maxU = 1.0f;
                maxV = 1.0f;
            }
        }
        StaticRenderers.bufferQuad(pose, consumer, pos0, pos1, pos2, pos3, color, 0.0f, 0.0f, maxU, maxV, lightmap, normal);
    }

    public static void bufferQuad(PoseStack.Pose pose, VertexConsumer consumer, Vector3f pos0, Vector3f pos1, Vector3f pos2, Vector3f pos3, Vector4f color, float minU, float minV, float maxU, float maxV, int lightmap, Vector3f normal) {
        Matrix4f posMatrix = pose.m_252922_();
        posTransformTemp.set(pos0.x(), pos0.y(), pos0.z(), 1.0f);
        posTransformTemp.mul((Matrix4fc)posMatrix);
        double x0 = posTransformTemp.x();
        double y0 = posTransformTemp.y();
        double z0 = posTransformTemp.z();
        posTransformTemp.set(pos1.x(), pos1.y(), pos1.z(), 1.0f);
        posTransformTemp.mul((Matrix4fc)posMatrix);
        double x1 = posTransformTemp.x();
        double y1 = posTransformTemp.y();
        double z1 = posTransformTemp.z();
        posTransformTemp.set(pos2.x(), pos2.y(), pos2.z(), 1.0f);
        posTransformTemp.mul((Matrix4fc)posMatrix);
        double x2 = posTransformTemp.x();
        double y2 = posTransformTemp.y();
        double z2 = posTransformTemp.z();
        posTransformTemp.set(pos3.x(), pos3.y(), pos3.z(), 1.0f);
        posTransformTemp.mul((Matrix4fc)posMatrix);
        double x3 = posTransformTemp.x();
        double y3 = posTransformTemp.y();
        double z3 = posTransformTemp.z();
        float r = color.x();
        float g = color.y();
        float b = color.z();
        float a = color.w();
        normalTransformTemp.set((Vector3fc)normal);
        normalTransformTemp.mul((Matrix3fc)pose.m_252943_());
        float nx = normalTransformTemp.x();
        float ny = normalTransformTemp.y();
        float nz = normalTransformTemp.z();
        consumer.m_5483_(x0, y0, z0).m_85950_(r, g, b, a).m_7421_(minU, minV).m_86008_(OverlayTexture.f_118083_).m_85969_(lightmap).m_5601_(nx, ny, nz).m_5752_();
        consumer.m_5483_(x1, y1, z1).m_85950_(r, g, b, a).m_7421_(minU, maxV).m_86008_(OverlayTexture.f_118083_).m_85969_(lightmap).m_5601_(nx, ny, nz).m_5752_();
        consumer.m_5483_(x2, y2, z2).m_85950_(r, g, b, a).m_7421_(maxU, maxV).m_86008_(OverlayTexture.f_118083_).m_85969_(lightmap).m_5601_(nx, ny, nz).m_5752_();
        consumer.m_5483_(x3, y3, z3).m_85950_(r, g, b, a).m_7421_(maxU, minV).m_86008_(OverlayTexture.f_118083_).m_85969_(lightmap).m_5601_(nx, ny, nz).m_5752_();
    }
}

