/*
 * Decompiled with CFR 0.152.
 */
package tallestegg.guardvillagers.entities.ai.tasks;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ItemStack;
import tallestegg.guardvillagers.configuration.GuardConfig;
import tallestegg.guardvillagers.entities.Guard;
import tallestegg.guardvillagers.entities.GuardVillagersVillagerData;
import tallestegg.guardvillagers.entities.ai.tasks.VillagerHelp;

public class RepairGuardEquipment
extends VillagerHelp {
    private Guard guard;

    public RepairGuardEquipment() {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of((Object)MemoryModuleType.f_148204_, (Object)MemoryStatus.VALUE_PRESENT), (List)GuardConfig.COMMON.professionsThatRepairGuards.get());
    }

    @Override
    protected boolean checkExtraStartConditions(ServerLevel worldIn, Villager owner) {
        List list = (List)owner.m_6274_().m_21952_(MemoryModuleType.f_148204_).get();
        if (!list.isEmpty()) {
            for (LivingEntity livingEntity : list) {
                ItemStack itemstack;
                int i;
                if (livingEntity.m_20145_() || !livingEntity.m_6084_() || !(livingEntity instanceof Guard)) continue;
                Guard guard = (Guard)livingEntity;
                if (owner.m_7141_().m_35571_() == VillagerProfession.f_35586_) {
                    for (i = 0; i < guard.guardInventory.m_6643_() - 2; ++i) {
                        itemstack = guard.guardInventory.m_8020_(i);
                        if (!itemstack.m_41768_() || !(itemstack.m_41720_() instanceof ArmorItem) || itemstack.m_41773_() < itemstack.m_41776_() / 2) continue;
                        this.guard = guard;
                        return super.checkExtraStartConditions(worldIn, owner);
                    }
                    continue;
                }
                for (i = 4; i < 6; ++i) {
                    itemstack = guard.guardInventory.m_8020_(i);
                    if (!itemstack.m_41768_() || itemstack.m_41773_() < itemstack.m_41776_() / 2) continue;
                    this.guard = guard;
                    return super.checkExtraStartConditions(worldIn, owner);
                }
            }
        }
        return false;
    }

    @Override
    protected long timeToCheck(LivingEntity owner) {
        return ((GuardVillagersVillagerData)owner).getLastRepairedGuard();
    }

    protected boolean canStillUse(ServerLevel level, Villager entity, long gameTime) {
        return ((GuardVillagersVillagerData)entity).getTimesRepairedGuard() < (Integer)GuardConfig.COMMON.maxVillageRepair.get();
    }

    protected void stop(ServerLevel worldIn, Villager entityIn, long gameTimeIn) {
        if (((GuardVillagersVillagerData)entityIn).getTimesRepairedGuard() >= (Integer)GuardConfig.COMMON.maxVillageRepair.get()) {
            ((GuardVillagersVillagerData)entityIn).setLastRepairedGuard(worldIn.m_46468_());
            ((GuardVillagersVillagerData)entityIn).setTimesRepairedGuard(0);
            entityIn.m_6274_().m_21936_(MemoryModuleType.f_26370_);
            entityIn.m_6274_().m_21936_(MemoryModuleType.f_26371_);
            float pitch = 1.0f + (this.guard.m_217043_().m_188501_() - this.guard.m_217043_().m_188501_()) * 0.2f;
            this.guard.m_5496_(SoundEvents.f_11671_, 1.0f, pitch);
        }
    }

    protected void start(ServerLevel worldIn, Villager entityIn, long gameTimeIn) {
        if (this.guard == null) {
            return;
        }
    }

    protected void tick(ServerLevel worldIn, Villager entityIn, long gameTimeIn) {
        this.repairGuardEquipment(entityIn);
    }

    public void repairGuardEquipment(Villager healer) {
        block4: {
            BehaviorUtils.m_22590_((LivingEntity)healer, (Entity)this.guard, (float)0.5f, (int)0);
            if (!((double)healer.m_20270_((Entity)this.guard) <= 2.0)) break block4;
            ((GuardVillagersVillagerData)healer).setTimesRepairedGuard(((GuardVillagersVillagerData)healer).getTimesRepairedGuard() + 1);
            VillagerProfession profession = healer.m_7141_().m_35571_();
            if (profession == VillagerProfession.f_35586_) {
                for (int i = 0; i < this.guard.guardInventory.m_6643_() - 2; ++i) {
                    ItemStack itemstack = this.guard.guardInventory.m_8020_(i);
                    if (!itemstack.m_41768_() || !(itemstack.m_41720_() instanceof ArmorItem) || itemstack.m_41773_() < itemstack.m_41776_() / 2 + this.guard.m_217043_().m_188503_(5)) continue;
                    itemstack.m_41721_(itemstack.m_41773_() - this.guard.m_217043_().m_188503_(5));
                }
            } else {
                for (int i = 4; i < 6; ++i) {
                    ItemStack itemstack = this.guard.guardInventory.m_8020_(i);
                    if (!itemstack.m_41768_() || itemstack.m_41773_() < itemstack.m_41776_() / 2 + this.guard.m_217043_().m_188503_(5)) continue;
                    itemstack.m_41721_(itemstack.m_41773_() - this.guard.m_217043_().m_188503_(5));
                }
            }
        }
    }
}

