/*
 * Decompiled with CFR 0.152.
 */
package com.tom.storagemod.util;

import com.tom.storagemod.gui.StorageTerminalMenu;
import com.tom.storagemod.network.NetworkHandler;
import com.tom.storagemod.platform.Platform;
import com.tom.storagemod.util.StoredItemStack;
import com.tom.storagemod.util.TerminalCraftingFiller;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.core.IdMap;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class TerminalSyncManager {
    private static final int MAX_PACKET_SIZE = 64000;
    private Object2IntMap<StoredItemStack> idMap = new Object2IntOpenHashMap();
    private Int2ObjectMap<StoredItemStack> idMap2 = new Int2ObjectArrayMap();
    private Object2LongMap<StoredItemStack> items = new Object2LongOpenHashMap();
    private Map<StoredItemStack, StoredItemStack> itemList = new HashMap<StoredItemStack, StoredItemStack>();
    private int lastId = 1;
    private FriendlyByteBuf workBuf = new FriendlyByteBuf(Unpooled.buffer((int)64000, (int)128000));

    private void write(FriendlyByteBuf buf, StoredItemStack stack) {
        ItemStack st = stack.getStack();
        Item item = st.m_41720_();
        CompoundTag compoundtag = Platform.getSyncTag(st);
        byte flags = (byte)((stack.getQuantity() == 0L ? 1 : 0) | (compoundtag != null ? 2 : 0));
        boolean wr = true;
        int id = this.idMap.getInt((Object)stack);
        if (id != 0) {
            flags = (byte)(flags | 4);
            wr = false;
        }
        buf.writeByte((int)flags);
        buf.m_130130_(this.idMap.computeIfAbsent((Object)stack, s -> {
            int i = this.lastId++;
            this.idMap2.put(i, (Object)((StoredItemStack)s));
            return i;
        }));
        if (wr) {
            buf.m_236818_((IdMap)BuiltInRegistries.f_257033_, (Object)item);
        }
        if (stack.getQuantity() != 0L) {
            buf.m_130103_(stack.getQuantity());
        }
        if (wr && compoundtag != null) {
            buf.m_130079_(compoundtag);
        }
    }

    private void writeMiniStack(FriendlyByteBuf buf, StoredItemStack stack) {
        int id = this.idMap.getInt((Object)stack);
        byte flags = (byte)((stack.getQuantity() == 0L ? 1 : 0) | 2);
        buf.writeByte((int)flags);
        buf.m_130130_(id);
        buf.m_236818_((IdMap)BuiltInRegistries.f_257033_, (Object)stack.getStack().m_41720_());
        if (stack.getQuantity() != 0L) {
            buf.m_130103_(stack.getQuantity());
        }
        CompoundTag tag = new CompoundTag();
        CompoundTag d = new CompoundTag();
        tag.m_128365_("display", (Tag)d);
        ListTag lore = new ListTag();
        d.m_128365_("Lore", (Tag)lore);
        lore.add((Object)StringTag.m_129297_((String)"{\"translate\":\"tooltip.toms_storage.nbt_overflow\",\"color\":\"red\"}"));
        tag.m_128405_("uid", id);
        buf.m_130079_(tag);
    }

    private StoredItemStack read(FriendlyByteBuf buf) {
        byte flags = buf.readByte();
        int id = buf.m_130242_();
        boolean rd = (flags & 4) == 0;
        StoredItemStack stack = rd ? new StoredItemStack(new ItemStack((ItemLike)buf.m_236816_((IdMap)BuiltInRegistries.f_257033_))) : new StoredItemStack(((StoredItemStack)this.idMap2.get(id)).getStack());
        long count = (flags & 1) != 0 ? 0L : buf.m_130258_();
        stack.setCount(count);
        if (rd && (flags & 2) != 0) {
            stack.getStack().m_41751_(buf.m_130260_());
        }
        this.idMap.put((Object)stack, id);
        this.idMap2.put(id, (Object)stack);
        return stack;
    }

    public void update(Map<StoredItemStack, Long> items, ServerPlayer player, Consumer<CompoundTag> extraSync) {
        ArrayList toWrite = new ArrayList();
        HashSet found = new HashSet();
        items.forEach((s, c) -> {
            long pc = this.items.getLong(s);
            if (pc != 0L) {
                found.add(s);
            }
            if (pc != c) {
                toWrite.add(new StoredItemStack(s.getStack(), (long)c));
            }
        });
        this.items.forEach((s, c) -> {
            if (!found.contains(s)) {
                toWrite.add(new StoredItemStack(s.getStack(), 0L));
            }
        });
        this.items.clear();
        this.items.putAll(items);
        if (!toWrite.isEmpty()) {
            this.workBuf.writerIndex(0);
            int j = 0;
            int i = 0;
            while (i < toWrite.size()) {
                StoredItemStack stack = (StoredItemStack)toWrite.get(i);
                int li = this.workBuf.writerIndex();
                try {
                    this.write(this.workBuf, stack);
                }
                catch (IndexOutOfBoundsException e) {
                    this.workBuf.writerIndex(li);
                    this.writeMiniStack(this.workBuf, stack);
                }
                int s2 = this.workBuf.writerIndex();
                if ((s2 > 64000 || j > 32000) && j > 1) {
                    CompoundTag t = this.writeBuf("d", this.workBuf, li);
                    t.m_128376_("l", (short)j);
                    NetworkHandler.sendTo(player, t);
                    j = 0;
                    this.workBuf.writerIndex(0);
                    if (s2 - li > 64000) {
                        this.writeMiniStack(this.workBuf, stack);
                    } else {
                        this.workBuf.writeBytes((ByteBuf)this.workBuf, li, s2 - li);
                    }
                }
                ++i;
                ++j;
            }
            if (j > 0 || extraSync != null) {
                CompoundTag t;
                if (j > 0) {
                    t = this.writeBuf("d", this.workBuf, this.workBuf.writerIndex());
                    t.m_128376_("l", (short)j);
                } else {
                    t = new CompoundTag();
                }
                if (extraSync != null) {
                    extraSync.accept(t);
                }
                NetworkHandler.sendTo(player, t);
            }
        } else if (extraSync != null) {
            CompoundTag t = new CompoundTag();
            extraSync.accept(t);
            NetworkHandler.sendTo(player, t);
        }
    }

    public boolean receiveUpdate(CompoundTag tag) {
        if (tag.m_128441_("d")) {
            FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.wrappedBuffer((byte[])tag.m_128463_("d")));
            ArrayList<StoredItemStack> in = new ArrayList<StoredItemStack>();
            int len = tag.m_128448_("l");
            for (int i = 0; i < len; ++i) {
                in.add(this.read(buf));
            }
            in.forEach(s -> {
                if (s.getQuantity() == 0L) {
                    this.itemList.remove(s);
                } else {
                    this.itemList.put((StoredItemStack)s, (StoredItemStack)s);
                }
            });
            return true;
        }
        return false;
    }

    public void sendInteract(StoredItemStack intStack, StorageTerminalMenu.SlotAction action, boolean mod) {
        int flags;
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        int n = flags = mod ? 1 : 0;
        if (intStack == null) {
            buf.writeByte(flags | 2);
        } else {
            buf.writeByte(flags);
            buf.m_130130_(this.idMap.getInt((Object)intStack));
            buf.m_130103_(intStack.getQuantity());
        }
        buf.m_130068_((Enum)action);
        NetworkHandler.sendDataToServer(this.writeBuf("a", buf, buf.writerIndex()));
    }

    private CompoundTag writeBuf(String id, FriendlyByteBuf buf, int len) {
        byte[] data = new byte[len];
        buf.getBytes(0, data);
        CompoundTag tag = new CompoundTag();
        tag.m_128382_(id, data);
        return tag;
    }

    public void receiveInteract(CompoundTag tag, InteractHandler handler) {
        if (tag.m_128441_("a")) {
            StoredItemStack stack;
            FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.wrappedBuffer((byte[])tag.m_128463_("a")));
            byte flags = buf.readByte();
            if ((flags & 2) != 0) {
                stack = null;
            } else {
                stack = new StoredItemStack(((StoredItemStack)this.idMap2.get(buf.m_130242_())).getStack());
                long count = buf.m_130258_();
                stack.setCount(count);
            }
            handler.onInteract(stack, (StorageTerminalMenu.SlotAction)buf.m_130066_(StorageTerminalMenu.SlotAction.class), (flags & 1) != 0);
        }
    }

    public List<StoredItemStack> getAsList() {
        return new ArrayList<StoredItemStack>(this.itemList.values());
    }

    public void fillStackedContents(StackedContents stc) {
        this.items.forEach((s, c) -> {
            ItemStack st = s.getActualStack();
            st.m_41764_(c.intValue());
            stc.m_36466_(st);
        });
    }

    public long getAmount(StoredItemStack stack) {
        StoredItemStack s = this.itemList.get(stack);
        return s != null ? s.getQuantity() : 0L;
    }

    public void fillCraftingFiller(TerminalCraftingFiller terminalCraftingFiller) {
        this.items.forEach((s, c) -> {
            ItemStack st = s.getActualStack();
            st.m_41764_(c.intValue());
            terminalCraftingFiller.accountStack(st);
        });
    }

    public static interface InteractHandler {
        public void onInteract(StoredItemStack var1, StorageTerminalMenu.SlotAction var2, boolean var3);
    }
}

