/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.potion_blending.client.renderer;

import com.leclowndu93150.potion_blending.block.entity.PotionBlendingStandBlockEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionUtils;
import org.joml.Matrix4f;

public class PotionBlendingStandRenderer
implements BlockEntityRenderer<PotionBlendingStandBlockEntity> {
    private static final ResourceLocation GEM_0 = new ResourceLocation("potion_blending", "block/crucible_potion_0");
    private static final ResourceLocation GEM_1 = new ResourceLocation("potion_blending", "block/crucible_potion_1");
    private static final ResourceLocation GEM_2 = new ResourceLocation("potion_blending", "block/crucible_potion_2");
    private static final ResourceLocation GEM_OUTPUT = new ResourceLocation("potion_blending", "block/crucible_potion_output");

    public PotionBlendingStandRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(PotionBlendingStandBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        poseStack.m_85836_();
        this.renderGems(blockEntity, poseStack, bufferSource, packedLight, packedOverlay);
        poseStack.m_85849_();
        if (blockEntity.isBrewing() && blockEntity.m_58904_() != null && blockEntity.m_58904_().m_213780_().m_188501_() < 0.3f) {
            RandomSource random = blockEntity.m_58904_().m_213780_();
            int potionCount = blockEntity.getPotionCount();
            double baseY = (double)blockEntity.m_58899_().m_123342_() + 0.25;
            double fluidHeight = 0.0625 * (double)potionCount * 2.0;
            double x = (double)blockEntity.m_58899_().m_123341_() + 0.5 + (random.m_188500_() - 0.5) * 0.3;
            double y = baseY + fluidHeight + 0.1;
            double z = (double)blockEntity.m_58899_().m_123343_() + 0.5 + (random.m_188500_() - 0.5) * 0.3;
            blockEntity.m_58904_().m_7106_((ParticleOptions)ParticleTypes.f_123777_, x, y, z, 0.0, 0.07, 0.0);
        }
    }

    private void renderGems(PotionBlendingStandBlockEntity blockEntity, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        this.renderGemOverlay(blockEntity, 0, GEM_0, poseStack, bufferSource, packedLight, packedOverlay);
        this.renderGemOverlay(blockEntity, 1, GEM_1, poseStack, bufferSource, packedLight, packedOverlay);
        this.renderGemOverlay(blockEntity, 2, GEM_2, poseStack, bufferSource, packedLight, packedOverlay);
        this.renderGemOverlay(blockEntity, 4, GEM_OUTPUT, poseStack, bufferSource, packedLight, packedOverlay);
    }

    private void renderGemOverlay(PotionBlendingStandBlockEntity blockEntity, int slot, ResourceLocation gemTexture, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        ItemStack stack = blockEntity.m_8020_(slot);
        if (!this.isPotion(stack)) {
            return;
        }
        int color = PotionUtils.m_43575_((ItemStack)stack);
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(gemTexture);
        VertexConsumer consumer = bufferSource.m_6299_(RenderType.m_110452_((ResourceLocation)InventoryMenu.f_39692_));
        Matrix4f matrix = poseStack.m_85850_().m_252922_();
        float offset = 0.001f;
        this.renderFaceNorth(consumer, matrix, sprite, offset, r, g, b, packedLight, packedOverlay);
        this.renderFaceSouth(consumer, matrix, sprite, offset, r, g, b, packedLight, packedOverlay);
        this.renderFaceEast(consumer, matrix, sprite, offset, r, g, b, packedLight, packedOverlay);
        this.renderFaceWest(consumer, matrix, sprite, offset, r, g, b, packedLight, packedOverlay);
    }

    private void renderFaceNorth(VertexConsumer consumer, Matrix4f matrix, TextureAtlasSprite sprite, float offset, float r, float g, float b, int packedLight, int packedOverlay) {
        float minU = sprite.m_118409_();
        float maxU = sprite.m_118410_();
        float minV = sprite.m_118411_();
        float maxV = sprite.m_118412_();
        consumer.m_252986_(matrix, 0.0f, 0.0f, 0.0f - offset).m_85950_(r, g, b, 1.0f).m_7421_(minU, maxV).m_86008_(packedOverlay).m_85969_(packedLight).m_5601_(0.0f, 0.0f, -1.0f).m_5752_();
        consumer.m_252986_(matrix, 0.0f, 1.0f, 0.0f - offset).m_85950_(r, g, b, 1.0f).m_7421_(minU, minV).m_86008_(packedOverlay).m_85969_(packedLight).m_5601_(0.0f, 0.0f, -1.0f).m_5752_();
        consumer.m_252986_(matrix, 1.0f, 1.0f, 0.0f - offset).m_85950_(r, g, b, 1.0f).m_7421_(maxU, minV).m_86008_(packedOverlay).m_85969_(packedLight).m_5601_(0.0f, 0.0f, -1.0f).m_5752_();
        consumer.m_252986_(matrix, 1.0f, 0.0f, 0.0f - offset).m_85950_(r, g, b, 1.0f).m_7421_(maxU, maxV).m_86008_(packedOverlay).m_85969_(packedLight).m_5601_(0.0f, 0.0f, -1.0f).m_5752_();
    }

    private void renderFaceSouth(VertexConsumer consumer, Matrix4f matrix, TextureAtlasSprite sprite, float offset, float r, float g, float b, int packedLight, int packedOverlay) {
        float minU = sprite.m_118409_();
        float maxU = sprite.m_118410_();
        float minV = sprite.m_118411_();
        float maxV = sprite.m_118412_();
        consumer.m_252986_(matrix, 1.0f, 0.0f, 1.0f + offset).m_85950_(r, g, b, 1.0f).m_7421_(minU, maxV).m_86008_(packedOverlay).m_85969_(packedLight).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
        consumer.m_252986_(matrix, 1.0f, 1.0f, 1.0f + offset).m_85950_(r, g, b, 1.0f).m_7421_(minU, minV).m_86008_(packedOverlay).m_85969_(packedLight).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
        consumer.m_252986_(matrix, 0.0f, 1.0f, 1.0f + offset).m_85950_(r, g, b, 1.0f).m_7421_(maxU, minV).m_86008_(packedOverlay).m_85969_(packedLight).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
        consumer.m_252986_(matrix, 0.0f, 0.0f, 1.0f + offset).m_85950_(r, g, b, 1.0f).m_7421_(maxU, maxV).m_86008_(packedOverlay).m_85969_(packedLight).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
    }

    private void renderFaceEast(VertexConsumer consumer, Matrix4f matrix, TextureAtlasSprite sprite, float offset, float r, float g, float b, int packedLight, int packedOverlay) {
        float minU = sprite.m_118409_();
        float maxU = sprite.m_118410_();
        float minV = sprite.m_118411_();
        float maxV = sprite.m_118412_();
        consumer.m_252986_(matrix, 1.0f + offset, 0.0f, 0.0f).m_85950_(r, g, b, 1.0f).m_7421_(maxU, maxV).m_86008_(packedOverlay).m_85969_(packedLight).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
        consumer.m_252986_(matrix, 1.0f + offset, 1.0f, 0.0f).m_85950_(r, g, b, 1.0f).m_7421_(maxU, minV).m_86008_(packedOverlay).m_85969_(packedLight).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
        consumer.m_252986_(matrix, 1.0f + offset, 1.0f, 1.0f).m_85950_(r, g, b, 1.0f).m_7421_(minU, minV).m_86008_(packedOverlay).m_85969_(packedLight).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
        consumer.m_252986_(matrix, 1.0f + offset, 0.0f, 1.0f).m_85950_(r, g, b, 1.0f).m_7421_(minU, maxV).m_86008_(packedOverlay).m_85969_(packedLight).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
    }

    private void renderFaceWest(VertexConsumer consumer, Matrix4f matrix, TextureAtlasSprite sprite, float offset, float r, float g, float b, int packedLight, int packedOverlay) {
        float minU = sprite.m_118409_();
        float maxU = sprite.m_118410_();
        float minV = sprite.m_118411_();
        float maxV = sprite.m_118412_();
        consumer.m_252986_(matrix, 0.0f - offset, 0.0f, 0.0f).m_85950_(r, g, b, 1.0f).m_7421_(minU, maxV).m_86008_(packedOverlay).m_85969_(packedLight).m_5601_(-1.0f, 0.0f, 0.0f).m_5752_();
        consumer.m_252986_(matrix, 0.0f - offset, 0.0f, 1.0f).m_85950_(r, g, b, 1.0f).m_7421_(maxU, maxV).m_86008_(packedOverlay).m_85969_(packedLight).m_5601_(-1.0f, 0.0f, 0.0f).m_5752_();
        consumer.m_252986_(matrix, 0.0f - offset, 1.0f, 1.0f).m_85950_(r, g, b, 1.0f).m_7421_(maxU, minV).m_86008_(packedOverlay).m_85969_(packedLight).m_5601_(-1.0f, 0.0f, 0.0f).m_5752_();
        consumer.m_252986_(matrix, 0.0f - offset, 1.0f, 0.0f).m_85950_(r, g, b, 1.0f).m_7421_(minU, minV).m_86008_(packedOverlay).m_85969_(packedLight).m_5601_(-1.0f, 0.0f, 0.0f).m_5752_();
    }

    private boolean isPotion(ItemStack stack) {
        return stack.m_150930_(Items.f_42589_) || stack.m_150930_(Items.f_42736_) || stack.m_150930_(Items.f_42739_);
    }

    public int m_142163_() {
        return 256;
    }
}

