/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.potion_blending.block.entity;

import com.leclowndu93150.potion_blending.block.ModBlockEntities;
import com.leclowndu93150.potion_blending.menu.PotionBlendingStandMenu;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class PotionBlendingStandBlockEntity
extends BlockEntity
implements Container,
MenuProvider {
    private static final int SLOT_INPUT_1 = 0;
    private static final int SLOT_INPUT_2 = 1;
    private static final int SLOT_INPUT_3 = 2;
    private static final int SLOT_FUEL = 3;
    private static final int SLOT_OUTPUT = 4;
    private static final int NUM_SLOTS = 5;
    private static final int BREW_TIME = 400;
    private NonNullList<ItemStack> items = NonNullList.m_122780_((int)5, (Object)ItemStack.f_41583_);
    private int brewTime;
    private int fuel;
    protected final ContainerData dataAccess = new ContainerData(){

        public int m_6413_(int index) {
            return switch (index) {
                case 0 -> PotionBlendingStandBlockEntity.this.brewTime;
                case 1 -> PotionBlendingStandBlockEntity.this.fuel;
                default -> 0;
            };
        }

        public void m_8050_(int index, int value) {
            switch (index) {
                case 0: {
                    PotionBlendingStandBlockEntity.this.brewTime = value;
                    break;
                }
                case 1: {
                    PotionBlendingStandBlockEntity.this.fuel = value;
                }
            }
        }

        public int m_6499_() {
            return 2;
        }
    };

    public PotionBlendingStandBlockEntity(BlockPos pos, BlockState blockState) {
        super(ModBlockEntities.POTION_BLENDING_STAND.get(), pos, blockState);
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        ContainerHelper.m_18973_((CompoundTag)tag, this.items);
        tag.m_128405_("BrewTime", this.brewTime);
        tag.m_128405_("Fuel", this.fuel);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.items = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        ContainerHelper.m_18980_((CompoundTag)tag, this.items);
        this.brewTime = tag.m_128451_("BrewTime");
        this.fuel = tag.m_128451_("Fuel");
        if (this.f_58857_ != null && this.f_58857_.f_46443_) {
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        }
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, PotionBlendingStandBlockEntity blockEntity) {
        boolean isBrewing;
        ItemStack fuelStack = (ItemStack)blockEntity.items.get(3);
        if (blockEntity.fuel <= 0 && !fuelStack.m_41619_() && fuelStack.m_150930_(Items.f_42593_)) {
            blockEntity.fuel = 20;
            fuelStack.m_41774_(1);
            PotionBlendingStandBlockEntity.m_155232_((Level)level, (BlockPos)pos, (BlockState)state);
            blockEntity.syncToClient(level, pos);
        }
        boolean canBrew = blockEntity.canBrew();
        boolean bl = isBrewing = blockEntity.brewTime > 0;
        if (isBrewing) {
            boolean justFinished;
            --blockEntity.brewTime;
            boolean bl2 = justFinished = blockEntity.brewTime == 0;
            if (justFinished && canBrew) {
                blockEntity.brew();
                PotionBlendingStandBlockEntity.m_155232_((Level)level, (BlockPos)pos, (BlockState)state);
                blockEntity.syncToClient(level, pos);
            } else if (!canBrew) {
                blockEntity.brewTime = 0;
                PotionBlendingStandBlockEntity.m_155232_((Level)level, (BlockPos)pos, (BlockState)state);
                blockEntity.syncToClient(level, pos);
            } else if (blockEntity.brewTime % 20 == 0) {
                blockEntity.syncToClient(level, pos);
            }
        } else if (canBrew && blockEntity.fuel > 0) {
            --blockEntity.fuel;
            blockEntity.brewTime = 400;
            PotionBlendingStandBlockEntity.m_155232_((Level)level, (BlockPos)pos, (BlockState)state);
            blockEntity.syncToClient(level, pos);
        }
    }

    private boolean canBrew() {
        ItemStack input1 = (ItemStack)this.items.get(0);
        ItemStack input2 = (ItemStack)this.items.get(1);
        ItemStack input3 = (ItemStack)this.items.get(2);
        ItemStack output = (ItemStack)this.items.get(4);
        if (input1.m_41619_() && input2.m_41619_() && input3.m_41619_()) {
            return false;
        }
        int potionCount = 0;
        if (this.isPotion(input1)) {
            ++potionCount;
        }
        if (this.isPotion(input2)) {
            ++potionCount;
        }
        if (this.isPotion(input3)) {
            ++potionCount;
        }
        if (potionCount < 2) {
            return false;
        }
        if (!this.areSamePotionType(input1, input2, input3)) {
            return false;
        }
        if (!output.m_41619_() && output.m_41613_() >= output.m_41741_()) {
            return false;
        }
        ItemStack result = this.createBlendedPotion();
        if (result.m_41619_()) {
            return false;
        }
        if (output.m_41619_()) {
            return true;
        }
        return ItemStack.m_150942_((ItemStack)output, (ItemStack)result);
    }

    private void brew() {
        ItemStack result = this.createBlendedPotion();
        ItemStack output = (ItemStack)this.items.get(4);
        if (output.m_41619_()) {
            this.items.set(4, (Object)result);
        } else if (ItemStack.m_150942_((ItemStack)output, (ItemStack)result)) {
            output.m_41769_(1);
        }
        if (this.isPotion((ItemStack)this.items.get(0))) {
            ((ItemStack)this.items.get(0)).m_41774_(1);
        }
        if (this.isPotion((ItemStack)this.items.get(1))) {
            ((ItemStack)this.items.get(1)).m_41774_(1);
        }
        if (this.isPotion((ItemStack)this.items.get(2))) {
            ((ItemStack)this.items.get(2)).m_41774_(1);
        }
    }

    private ItemStack createBlendedPotion() {
        int color;
        List effects;
        ItemStack input1 = (ItemStack)this.items.get(0);
        ItemStack input2 = (ItemStack)this.items.get(1);
        ItemStack input3 = (ItemStack)this.items.get(2);
        ItemStack potionType = null;
        if (this.isPotion(input1)) {
            potionType = input1;
        } else if (this.isPotion(input2)) {
            potionType = input2;
        } else if (this.isPotion(input3)) {
            potionType = input3;
        }
        if (potionType == null) {
            return ItemStack.f_41583_;
        }
        HashMap effectMap = new HashMap();
        int totalRed = 0;
        int totalGreen = 0;
        int totalBlue = 0;
        int colorCount = 0;
        if (this.isPotion(input1)) {
            effects = PotionUtils.m_43547_((ItemStack)input1);
            effects.forEach(effect -> this.mergeEffect(effectMap, (MobEffectInstance)effect));
            color = PotionUtils.m_43575_((ItemStack)input1);
            totalRed += color >> 16 & 0xFF;
            totalGreen += color >> 8 & 0xFF;
            totalBlue += color & 0xFF;
            ++colorCount;
        }
        if (this.isPotion(input2)) {
            effects = PotionUtils.m_43547_((ItemStack)input2);
            effects.forEach(effect -> this.mergeEffect(effectMap, (MobEffectInstance)effect));
            color = PotionUtils.m_43575_((ItemStack)input2);
            totalRed += color >> 16 & 0xFF;
            totalGreen += color >> 8 & 0xFF;
            totalBlue += color & 0xFF;
            ++colorCount;
        }
        if (this.isPotion(input3)) {
            effects = PotionUtils.m_43547_((ItemStack)input3);
            effects.forEach(effect -> this.mergeEffect(effectMap, (MobEffectInstance)effect));
            color = PotionUtils.m_43575_((ItemStack)input3);
            totalRed += color >> 16 & 0xFF;
            totalGreen += color >> 8 & 0xFF;
            totalBlue += color & 0xFF;
            ++colorCount;
        }
        int blendedColor = -1;
        if (colorCount > 0) {
            int avgRed = totalRed / colorCount;
            int avgGreen = totalGreen / colorCount;
            int avgBlue = totalBlue / colorCount;
            blendedColor = avgRed << 16 | avgGreen << 8 | avgBlue;
        }
        ArrayList allEffects = new ArrayList(effectMap.values());
        ItemStack result = new ItemStack((ItemLike)potionType.m_41720_());
        PotionUtils.m_43552_((ItemStack)result, allEffects);
        if (blendedColor != -1) {
            result.m_41784_().m_128405_("CustomPotionColor", blendedColor);
        }
        result.m_41714_((Component)Component.m_237115_((String)"item.potion_blending.blended_potion"));
        return result;
    }

    private void mergeEffect(Map<MobEffect, MobEffectInstance> effectMap, MobEffectInstance newEffect) {
        MobEffect effectType = newEffect.m_19544_();
        if (effectMap.containsKey(effectType)) {
            MobEffectInstance existing = effectMap.get(effectType);
            int newDuration = existing.m_19557_() + newEffect.m_19557_();
            int maxAmplifier = Math.max(existing.m_19564_(), newEffect.m_19564_());
            effectMap.put(effectType, new MobEffectInstance(effectType, newDuration, maxAmplifier, existing.m_19571_(), existing.m_19572_(), existing.m_19575_()));
        } else {
            effectMap.put(effectType, new MobEffectInstance(newEffect));
        }
    }

    private boolean isPotion(ItemStack stack) {
        return !PotionUtils.m_43547_((ItemStack)stack).isEmpty();
    }

    private boolean areSamePotionType(ItemStack stack1, ItemStack stack2, ItemStack stack3) {
        ItemStack firstPotion = null;
        if (this.isPotion(stack1)) {
            firstPotion = stack1;
        } else if (this.isPotion(stack2)) {
            firstPotion = stack2;
        } else if (this.isPotion(stack3)) {
            firstPotion = stack3;
        }
        if (firstPotion == null) {
            return false;
        }
        if (this.isPotion(stack1) && !stack1.m_150930_(firstPotion.m_41720_())) {
            return false;
        }
        if (this.isPotion(stack2) && !stack2.m_150930_(firstPotion.m_41720_())) {
            return false;
        }
        return !this.isPotion(stack3) || stack3.m_150930_(firstPotion.m_41720_());
    }

    public void dropContents(Level level, BlockPos pos) {
        for (ItemStack stack : this.items) {
            if (stack.m_41619_()) continue;
            Containers.m_18992_((Level)level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)stack);
        }
    }

    public int m_6643_() {
        return 5;
    }

    public boolean m_7983_() {
        for (ItemStack stack : this.items) {
            if (stack.m_41619_()) continue;
            return false;
        }
        return true;
    }

    public ItemStack m_8020_(int slot) {
        return slot >= 0 && slot < this.items.size() ? (ItemStack)this.items.get(slot) : ItemStack.f_41583_;
    }

    public ItemStack m_7407_(int slot, int amount) {
        return ContainerHelper.m_18969_(this.items, (int)slot, (int)amount);
    }

    public ItemStack m_8016_(int slot) {
        return ContainerHelper.m_18966_(this.items, (int)slot);
    }

    public void m_6836_(int slot, ItemStack stack) {
        if (slot >= 0 && slot < this.items.size()) {
            this.items.set(slot, (Object)stack);
            this.m_6596_();
            if (this.f_58857_ != null) {
                if (!this.f_58857_.f_46443_) {
                    this.syncToClient(this.f_58857_, this.f_58858_);
                } else {
                    this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 11);
                }
            }
        }
    }

    public boolean m_6542_(Player player) {
        return Container.m_272074_((BlockEntity)this, (Player)player);
    }

    public void m_6211_() {
        this.items.clear();
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"container.potion_blending.potion_blending_stand");
    }

    public AbstractContainerMenu m_7208_(int containerId, Inventory playerInventory, Player player) {
        return new PotionBlendingStandMenu(containerId, playerInventory, this, this.dataAccess);
    }

    public boolean isBrewing() {
        return this.brewTime > 0;
    }

    public int getPotionCount() {
        int count = 0;
        for (int i = 0; i < 3; ++i) {
            if (!this.isPotion((ItemStack)this.items.get(i))) continue;
            ++count;
        }
        return count;
    }

    public int getMixedColor() {
        int totalRed = 0;
        int totalGreen = 0;
        int totalBlue = 0;
        int colorCount = 0;
        for (int i = 0; i < 3; ++i) {
            ItemStack stack = (ItemStack)this.items.get(i);
            if (!this.isPotion(stack)) continue;
            int color = PotionUtils.m_43575_((ItemStack)stack);
            totalRed += color >> 16 & 0xFF;
            totalGreen += color >> 8 & 0xFF;
            totalBlue += color & 0xFF;
            ++colorCount;
        }
        if (colorCount == 0) {
            return -1;
        }
        int avgRed = totalRed / colorCount;
        int avgGreen = totalGreen / colorCount;
        int avgBlue = totalBlue / colorCount;
        return avgRed << 16 | avgGreen << 8 | avgBlue;
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = new CompoundTag();
        this.m_183515_(tag);
        return tag;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    private void syncToClient(Level level, BlockPos pos) {
        if (!level.f_46443_) {
            level.m_7260_(pos, this.m_58900_(), this.m_58900_(), 11);
        }
    }
}

