/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.network;

import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;
import slimeknights.mantle.client.SafeClientAccess;
import slimeknights.mantle.data.loadable.Streamable;
import slimeknights.mantle.network.packet.IThreadsafePacket;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.tools.capability.EntityModifierCapability;
import slimeknights.tconstruct.library.tools.capability.PersistentDataCapability;
import slimeknights.tconstruct.library.tools.nbt.ModifierNBT;

public record SyncProjectileModifiersPacket(int entityId, ModifierNBT modifiers, CompoundTag persistentData) implements IThreadsafePacket
{
    private static final Streamable<ModifierNBT> MODIFIER_LIST = ModifierEntry.LOADABLE.list(0).flatXmap(ModifierNBT::new, ModifierNBT::getModifiers);

    public SyncProjectileModifiersPacket(Entity entity) {
        this(entity.m_19879_(), EntityModifierCapability.getOrEmpty(entity), PersistentDataCapability.getOrWarn(entity).getCopy());
    }

    public SyncProjectileModifiersPacket(FriendlyByteBuf buffer) {
        this(buffer.m_130242_(), (ModifierNBT)MODIFIER_LIST.decode(buffer), Objects.requireNonNullElse(buffer.m_130260_(), new CompoundTag()));
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130130_(this.entityId);
        MODIFIER_LIST.encode(buffer, (Object)this.modifiers);
        buffer.m_130079_(this.persistentData);
    }

    public void handleThreadsafe(NetworkEvent.Context context) {
        Entity entity;
        Level level = SafeClientAccess.getLevel();
        if (level != null && (entity = level.m_6815_(this.entityId)) != null) {
            EntityModifierCapability.getCapability(entity).setModifiers(this.modifiers);
            PersistentDataCapability.getOrWarn(entity).copyFrom(this.persistentData);
        }
    }
}

