/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modules.combat;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.primitive.BooleanLoadable;
import slimeknights.mantle.data.loadable.primitive.FloatLoadable;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.combat.MeleeHitModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.combat.MonsterMeleeHitModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.ranged.LauncherHitModifierHook;
import slimeknights.tconstruct.library.modifiers.modules.ModifierModule;
import slimeknights.tconstruct.library.module.HookProvider;
import slimeknights.tconstruct.library.module.ModuleHook;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;

public record ChannelingModule(float clearChance, float rainChance, float thunderChance, boolean allowMelee) implements ModifierModule,
MeleeHitModifierHook,
MonsterMeleeHitModifierHook.RedirectAfter,
LauncherHitModifierHook
{
    private static final List<ModuleHook<?>> MELEE_HOOKS = HookProvider.defaultHooks(ModifierHooks.MELEE_HIT, ModifierHooks.MONSTER_MELEE_HIT, ModifierHooks.LAUNCHER_HIT);
    private static final List<ModuleHook<?>> PROJECTILE_HOOKS = HookProvider.defaultHooks(ModifierHooks.MELEE_HIT, ModifierHooks.LAUNCHER_HIT);
    public static final RecordLoadable<ChannelingModule> LOADER = RecordLoadable.create((RecordField)FloatLoadable.PERCENT.requiredField("chance_clear", ChannelingModule::clearChance), (RecordField)FloatLoadable.PERCENT.requiredField("chance_rain", ChannelingModule::rainChance), (RecordField)FloatLoadable.PERCENT.requiredField("chance_thunder", ChannelingModule::thunderChance), (RecordField)BooleanLoadable.INSTANCE.requiredField("allow_melee", ChannelingModule::allowMelee), ChannelingModule::new);

    public RecordLoadable<ChannelingModule> getLoader() {
        return LOADER;
    }

    @Override
    public List<ModuleHook<?>> getDefaultHooks() {
        return this.allowMelee ? MELEE_HOOKS : PROJECTILE_HOOKS;
    }

    private void tryStrike(Level level, @Nullable LivingEntity attacker, BlockPos target) {
        LightningBolt lightning;
        float chance;
        if (level instanceof ServerLevel && level.m_45527_(target) && ((chance = level.m_46470_() ? this.thunderChance : (level.m_46471_() ? this.rainChance : this.clearChance)) >= 1.0f || level.f_46441_.m_188501_() < chance) && (lightning = (LightningBolt)EntityType.f_20465_.m_20615_(level)) != null) {
            lightning.m_20219_(Vec3.m_82539_((Vec3i)target));
            if (attacker instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)attacker;
                lightning.m_20879_(player);
            }
            level.m_7967_((Entity)lightning);
            level.m_5594_(null, target, SoundEvents.f_12521_, SoundSource.NEUTRAL, 5.0f, 1.0f);
        }
    }

    @Override
    public void afterMeleeHit(IToolStackView tool, ModifierEntry modifier, ToolAttackContext context, float damageDealt) {
        if (context.isFullyCharged() && (this.allowMelee || context.isProjectile())) {
            this.tryStrike(context.getLevel(), (LivingEntity)context.getPlayerAttacker(), context.getTarget().m_20183_());
        }
    }

    @Override
    public void onLauncherHitEntity(IToolStackView tool, ModifierEntry modifier, Projectile projectile, LivingEntity attacker, Entity target, @Nullable LivingEntity livingTarget, float damageDealt) {
        this.tryStrike(projectile.m_9236_(), attacker, target.m_20183_());
    }

    @Override
    public void onLauncherHitBlock(IToolStackView tool, ModifierEntry modifier, Projectile projectile, LivingEntity owner, BlockPos target) {
        this.tryStrike(projectile.m_9236_(), owner, target);
    }
}

