/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.traits.melee;

import javax.annotation.Nullable;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.phys.EntityHitResult;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.armor.OnAttackedModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.combat.MeleeHitModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.combat.MonsterMeleeHitModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.ranged.ProjectileHitModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.ranged.ProjectileLaunchModifierHook;
import slimeknights.tconstruct.library.module.ModuleHookMap;
import slimeknights.tconstruct.library.tools.context.EquipmentContext;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.library.tools.nbt.ModifierNBT;
import slimeknights.tconstruct.tools.modules.armor.CounterModule;

public class DecayModifier
extends Modifier
implements ProjectileLaunchModifierHook,
ProjectileHitModifierHook,
MeleeHitModifierHook,
MonsterMeleeHitModifierHook.RedirectAfter,
OnAttackedModifierHook {
    private static MobEffectInstance makeDecayEffect(int level) {
        return new MobEffectInstance(MobEffects.f_19615_, 20 * (5 + RANDOM.nextInt(level * 3)), level - 1);
    }

    @Override
    protected void registerHooks(ModuleHookMap.Builder hookBuilder) {
        super.registerHooks(hookBuilder);
        hookBuilder.addHook(this, ModifierHooks.PROJECTILE_LAUNCH, ModifierHooks.PROJECTILE_SHOT, ModifierHooks.PROJECTILE_HIT, ModifierHooks.MELEE_HIT, ModifierHooks.MONSTER_MELEE_HIT, ModifierHooks.ON_ATTACKED);
    }

    @Override
    public void afterMeleeHit(IToolStackView tool, ModifierEntry modifier, ToolAttackContext context, float damageDealt) {
        if (context.isFullyCharged()) {
            LivingEntity target;
            if (RANDOM.nextInt(3) == 0) {
                context.getAttacker().m_7292_(DecayModifier.makeDecayEffect(modifier.getLevel()));
            }
            if ((target = context.getLivingTarget()) != null && target.m_6084_()) {
                target.m_7292_(DecayModifier.makeDecayEffect(modifier.getLevel()));
            }
        }
    }

    @Override
    public boolean onProjectileHitEntity(ModifierNBT modifiers, ModDataNBT persistentData, ModifierEntry modifier, Projectile projectile, EntityHitResult hit, @Nullable LivingEntity attacker, @Nullable LivingEntity target) {
        AbstractArrow arrow;
        if (target != null && (!(projectile instanceof AbstractArrow) || (arrow = (AbstractArrow)projectile).m_36792_())) {
            target.m_7292_(DecayModifier.makeDecayEffect(modifier.getLevel()));
        }
        return false;
    }

    @Override
    public void onProjectileLaunch(IToolStackView tool, ModifierEntry modifier, LivingEntity shooter, Projectile projectile, @Nullable AbstractArrow arrow, ModDataNBT persistentData, boolean primary) {
        if (primary && (arrow == null || arrow.m_36792_()) && RANDOM.nextInt(3) == 0) {
            shooter.m_7292_(DecayModifier.makeDecayEffect(modifier.getLevel()));
        }
    }

    @Override
    public void onAttacked(IToolStackView tool, ModifierEntry modifier, EquipmentContext context, EquipmentSlot slotType, DamageSource source, float amount, boolean isDirectDamage) {
        Entity entity;
        if (isDirectDamage && tool.hasTag(TinkerTags.Items.ARMOR) && (entity = source.m_7639_()) instanceof LivingEntity) {
            LivingEntity attacker = (LivingEntity)entity;
            LivingEntity defender = context.getEntity();
            float chance = 0.5f;
            if (CounterModule.isBlocking(tool, slotType, context.getEntity())) {
                chance *= 2.0f;
            }
            if (chance >= 1.0f || RANDOM.nextFloat() < chance) {
                attacker.m_7292_(DecayModifier.makeDecayEffect(modifier.getLevel()));
            }
            if (RANDOM.nextInt(10) == 0) {
                defender.m_7292_(DecayModifier.makeDecayEffect(modifier.getLevel()));
            }
        }
    }
}

