/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import slimeknights.mantle.util.TranslationHelper;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.Sounds;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.common.config.Config;
import slimeknights.tconstruct.library.materials.MaterialRegistry;
import slimeknights.tconstruct.library.materials.definition.IMaterial;
import slimeknights.tconstruct.library.materials.definition.MaterialId;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.tools.definition.module.material.MaterialRepairToolHook;
import slimeknights.tconstruct.library.tools.helper.ToolDamageUtil;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.library.tools.part.IRepairKitItem;
import slimeknights.tconstruct.library.tools.part.MaterialItem;
import slimeknights.tconstruct.tools.stats.StatlessMaterialStats;

public class RepairKitItem
extends MaterialItem
implements IRepairKitItem {
    private static final String TOOLTIP_KEY = TConstruct.makeTranslationKey("item", "repair_kit.tooltip");
    private final float repairAmount;

    public RepairKitItem(Item.Properties properties, float repairAmount) {
        super(properties);
        this.repairAmount = repairAmount;
    }

    public RepairKitItem(Item.Properties properties) {
        this(properties, 0.0f);
    }

    @Override
    public boolean canUseMaterial(MaterialId material) {
        return MaterialRegistry.getInstance().getAllStats(material).stream().anyMatch(stats -> stats == StatlessMaterialStats.REPAIR_KIT || stats.getType().canRepair());
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flag) {
        super.m_7373_(stack, world, tooltip, flag);
        if (this.canRepairInCraftingTable()) {
            tooltip.add((Component)Component.m_237110_((String)TOOLTIP_KEY, (Object[])new Object[]{TranslationHelper.COMMA_FORMAT.format(this.getRepairAmount())}).m_130940_(ChatFormatting.GRAY));
        }
    }

    @Override
    public float getRepairAmount() {
        if (this.repairAmount == 0.0f) {
            return ((Double)Config.COMMON.repairKitAmount.get()).floatValue();
        }
        return this.repairAmount;
    }

    public boolean m_142207_(ItemStack stack, Slot slot, ClickAction action, Player player) {
        ItemStack toolItem;
        if (this.canRepairInCraftingTable() && action == ClickAction.SECONDARY && slot.m_150651_(player) && !(toolItem = slot.m_7993_()).m_41619_() && toolItem.m_204117_(TinkerTags.Items.MODIFIABLE)) {
            float amount;
            ToolStack tool = ToolStack.from(toolItem);
            MaterialId material = this.getMaterial(stack).getId();
            if (tool.getDamage() > 0 && material != IMaterial.UNKNOWN_ID && (amount = MaterialRepairToolHook.repairAmount(tool, material)) > 0.0f) {
                amount *= this.getRepairAmount() / 3.0f;
                for (ModifierEntry entry : tool.getModifierList()) {
                    amount = entry.getHook(ModifierHooks.REPAIR_FACTOR).getRepairFactor(tool, entry, amount);
                    if (!(amount <= 0.0f)) continue;
                    return true;
                }
                ToolDamageUtil.repair(tool, (int)amount);
                tool.updateStack(toolItem);
                stack.m_41774_(1);
                player.m_5496_(Sounds.SAW.getSound(), 1.0f, 0.8f + 0.4f * player.m_9236_().f_46441_.m_188501_());
            }
            return true;
        }
        return false;
    }
}

