/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.entity;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.TheEndGatewayBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.entity.ProjectileWithKnockback;
import slimeknights.tconstruct.library.modifiers.entity.ProjectileWithPower;
import slimeknights.tconstruct.library.modifiers.hook.build.ConditionalStatModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.ranged.ScheduledProjectileTaskModifierHook;
import slimeknights.tconstruct.library.tools.IndestructibleItemEntity;
import slimeknights.tconstruct.library.tools.capability.EntityModifierCapability;
import slimeknights.tconstruct.library.tools.capability.PersistentDataCapability;
import slimeknights.tconstruct.library.tools.helper.ModifierUtil;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.library.tools.stat.ToolStats;
import slimeknights.tconstruct.library.utils.Schedule;
import slimeknights.tconstruct.tools.TinkerToolActions;
import slimeknights.tconstruct.tools.TinkerTools;
import slimeknights.tconstruct.tools.entity.ToolProjectile;

public class ThrownShuriken
extends Projectile
implements ToolProjectile,
ProjectileWithPower,
ProjectileWithKnockback {
    protected static final EntityDataAccessor<ItemStack> STACK = SynchedEntityData.m_135353_(ThrownShuriken.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    protected static final EntityDataAccessor<Float> WATER_INERTIA = SynchedEntityData.m_135353_(ThrownShuriken.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private ItemStack stack = ItemStack.f_41583_;
    private IToolStackView tool = null;
    private boolean reclaim = false;
    private float power = 4.0f;
    private float knockback = 0.0f;
    private Schedule tasks = Schedule.EMPTY;
    private static final String KEY_STACK = "stack";
    private static final String KEY_WATER_INERTIA = "water_inertia";
    private static final String KEY_TASKS = "tasks";

    public ThrownShuriken(EntityType<? extends ThrownShuriken> type, Level level) {
        super(type, level);
    }

    public ThrownShuriken(Level level, double pX, double pY, double pZ) {
        this((EntityType<? extends ThrownShuriken>)((EntityType)TinkerTools.thrownShuriken.get()), level);
        this.m_6034_(pX, pY, pZ);
    }

    public ThrownShuriken(Level level, LivingEntity shooter) {
        this(level, shooter.m_20185_(), shooter.m_20188_() - 0.1, shooter.m_20189_());
        this.m_5602_((Entity)shooter);
    }

    private void setStack(ItemStack stack) {
        this.stack = stack;
        this.f_19804_.m_135381_(STACK, (Object)stack);
        this.reclaim = ModifierUtil.checkVolatileFlag(stack, IndestructibleItemEntity.INDESTRUCTIBLE_ENTITY);
    }

    private IToolStackView getTool() {
        if (this.tool == null) {
            this.tool = ToolStack.from(this.stack);
        }
        return this.tool;
    }

    public IToolStackView onCreate(ItemStack stack, @Nullable LivingEntity shooter) {
        stack = stack.m_255036_(1);
        this.setStack(stack);
        IToolStackView tool = this.getTool();
        EntityModifierCapability.getCapability((Entity)this).addModifiers(tool.getModifiers());
        this.power = ConditionalStatModifierHook.getModifiedStat(tool, shooter, ToolStats.PROJECTILE_DAMAGE);
        this.f_19804_.m_135381_(WATER_INERTIA, (Object)Float.valueOf(ConditionalStatModifierHook.getModifiedStat(tool, shooter, ToolStats.WATER_INERTIA)));
        return tool;
    }

    public void m_6686_(double pX, double pY, double pZ, float velocity, float inaccuracy) {
        if (!this.stack.m_41619_()) {
            IToolStackView tool = this.getTool();
            LivingEntity shooter = ModifierUtil.asLiving(this.m_19749_());
            super.m_6686_(pX, pY, pZ, velocity, inaccuracy *= ModifierUtil.getInaccuracy(tool, shooter));
            ModDataNBT arrowData = PersistentDataCapability.getOrWarn((Entity)this);
            for (ModifierEntry entry : tool.getModifiers()) {
                entry.getHook(ModifierHooks.PROJECTILE_SHOT).onProjectileShoot(tool, entry, shooter, this.stack, this, null, arrowData, true);
            }
            this.tasks = ScheduledProjectileTaskModifierHook.createSchedule(tool, this.stack, this, null, arrowData);
        } else {
            super.m_6686_(pX, pY, pZ, velocity, inaccuracy);
        }
    }

    public void m_8119_() {
        float speedReduction;
        HitResult.Type type;
        super.m_8119_();
        HitResult hit = ProjectileUtil.m_278158_((Entity)this, x$0 -> this.m_5603_((Entity)x$0));
        boolean teleported = false;
        if (hit.m_6662_() == HitResult.Type.BLOCK) {
            BlockPos pos = ((BlockHitResult)hit).m_82425_();
            BlockState state = this.m_9236_().m_8055_(pos);
            if (state.m_60713_(Blocks.f_50142_)) {
                this.m_20221_(pos);
                teleported = true;
            } else if (state.m_60713_(Blocks.f_50446_)) {
                BlockEntity blockEntity = this.m_9236_().m_7702_(pos);
                if (blockEntity instanceof TheEndGatewayBlockEntity) {
                    TheEndGatewayBlockEntity gateway = (TheEndGatewayBlockEntity)blockEntity;
                    if (TheEndGatewayBlockEntity.m_59940_((Entity)this)) {
                        TheEndGatewayBlockEntity.m_155828_((Level)this.m_9236_(), (BlockPos)pos, (BlockState)state, (Entity)this, (TheEndGatewayBlockEntity)gateway);
                    }
                }
                teleported = true;
            }
        }
        if ((type = hit.m_6662_()) != HitResult.Type.MISS && !teleported) {
            if (!this.stack.m_41619_() && type == HitResult.Type.ENTITY && ModifierUtil.canPerformAction(this.getTool(), TinkerToolActions.SHIELD_DISABLE)) {
                ModifierUtil.disableShield(((EntityHitResult)hit).m_82443_());
            }
            if (!ForgeEventFactory.onProjectileImpact((Projectile)this, (HitResult)hit)) {
                this.m_6532_(hit);
            }
        }
        this.m_20101_();
        Vec3 movement = this.m_20184_();
        double x = this.m_20185_() + movement.f_82479_;
        double y = this.m_20186_() + movement.f_82480_;
        double z = this.m_20189_() + movement.f_82481_;
        this.m_37283_();
        if (this.m_20069_()) {
            for (int i = 0; i < 4; ++i) {
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123795_, x - movement.f_82479_ * 0.25, y - movement.f_82480_ * 0.25, z - movement.f_82481_ * 0.25, movement.f_82479_, movement.f_82480_, movement.f_82481_);
            }
            speedReduction = ((Float)this.f_19804_.m_135370_(WATER_INERTIA)).floatValue();
        } else {
            speedReduction = 0.99f;
        }
        this.m_20256_(movement.m_82490_((double)speedReduction));
        if (!this.m_20068_()) {
            Vec3 vec31 = this.m_20184_();
            this.m_20334_(vec31.f_82479_, vec31.f_82480_ - (double)0.03f, vec31.f_82481_);
        }
        this.m_6034_(x, y, z);
        if (!this.tasks.isEmpty() && !this.stack.m_41619_()) {
            ScheduledProjectileTaskModifierHook.checkSchedule(this.getTool(), this.stack, this, null, this.tasks);
        }
    }

    protected void m_5790_(EntityHitResult result) {
        Entity target = result.m_82443_();
        boolean hit = target.m_6469_(this.m_269291_().m_269390_((Entity)this, this.m_19749_()), this.power);
        if (hit && this.knockback > 0.0f && target instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)target;
            double resistance = Math.max(0.0, 1.0 - living.m_21133_(Attributes.f_22278_));
            Vec3 motion = this.m_20184_().m_82542_(1.0, 0.0, 1.0).m_82541_().m_82490_((double)this.knockback * 0.6 * resistance);
            if (motion.m_82556_() > 0.0) {
                target.m_5997_(motion.f_82479_, (double)0.1f, motion.f_82481_);
            }
        }
        Level level = this.m_9236_();
        if (!level.f_46443_) {
            if (!(hit && !this.reclaim || this.m_213877_())) {
                this.m_19983_(this.stack.m_41777_());
            } else {
                level.m_7605_((Entity)this, (byte)3);
            }
            this.m_146870_();
        }
    }

    protected void m_8060_(BlockHitResult result) {
        super.m_8060_(result);
        if (!this.m_213877_()) {
            this.m_19983_(this.stack.m_41777_());
            this.m_146870_();
        }
    }

    @Override
    public void setPower(float power) {
        this.power = power;
    }

    @Override
    public void addKnockback(float amount) {
        this.knockback += amount;
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(STACK, (Object)ItemStack.f_41583_);
        this.f_19804_.m_135372_(WATER_INERTIA, (Object)Float.valueOf(0.8f));
    }

    @Override
    public ItemStack getDisplayTool() {
        return (ItemStack)this.f_19804_.m_135370_(STACK);
    }

    public Component m_5446_() {
        return this.getDisplayTool().m_41611_();
    }

    public boolean m_6783_(double pDistance) {
        double d0 = this.m_20191_().m_82309_() * 4.0;
        if (Double.isNaN(d0)) {
            d0 = 4.0;
        }
        return pDistance < (d0 *= 64.0) * d0;
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128365_(KEY_STACK, (Tag)this.stack.m_41739_(new CompoundTag()));
        tag.m_128350_(KEY_WATER_INERTIA, ((Float)this.f_19804_.m_135370_(WATER_INERTIA)).floatValue());
        if (!this.tasks.isEmpty()) {
            tag.m_128365_(KEY_TASKS, (Tag)this.tasks.serialize());
        }
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128425_(KEY_STACK, 10)) {
            this.setStack(ItemStack.m_41712_((CompoundTag)tag.m_128469_(KEY_STACK)));
        }
        this.f_19804_.m_135381_(WATER_INERTIA, (Object)Float.valueOf(tag.m_128457_(KEY_WATER_INERTIA)));
        if (tag.m_128425_(KEY_TASKS, 9)) {
            this.tasks = Schedule.deserialize(tag.m_128437_(KEY_TASKS, 10));
        }
    }

    @Override
    public float getPower() {
        return this.power;
    }
}

