/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tables.block;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.HitResult;
import slimeknights.mantle.util.RetexturedHelper;
import slimeknights.tconstruct.library.materials.definition.IMaterial;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;
import slimeknights.tconstruct.library.tools.part.IMaterialItem;
import slimeknights.tconstruct.tables.block.RetexturedTableBlock;
import slimeknights.tconstruct.tables.block.entity.table.TinkerStationBlockEntity;

public class TinkerStationBlock
extends RetexturedTableBlock {
    private final int slotCount;

    public TinkerStationBlock(BlockBehaviour.Properties builder, int slotCount) {
        super(builder);
        this.slotCount = slotCount;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return new TinkerStationBlockEntity(pPos, pState, this.getSlotCount());
    }

    @Override
    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        BlockEntity blockEntity;
        super.m_6402_(level, pos, state, placer, stack);
        if (stack.m_41782_() && (blockEntity = level.m_7702_(pos)) instanceof TinkerStationBlockEntity) {
            TinkerStationBlockEntity be = (TinkerStationBlockEntity)blockEntity;
            String block = RetexturedHelper.getTextureName((ItemStack)stack);
            if (!block.isEmpty()) {
                be.updateTexture(block);
            } else {
                MaterialVariantId material = IMaterialItem.getMaterialFromStack(stack);
                if (material != IMaterial.UNKNOWN_ID) {
                    be.setMaterial(material);
                }
            }
        }
    }

    @Override
    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter level, BlockPos pos, Player player) {
        ItemStack stack = new ItemStack((ItemLike)state.m_60734_());
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof TinkerStationBlockEntity) {
            TinkerStationBlockEntity be = (TinkerStationBlockEntity)blockEntity;
            Block block = be.getTexture();
            if (block != Blocks.f_50016_) {
                RetexturedHelper.setTexture((ItemStack)stack, (Block)block);
            } else {
                stack = IMaterialItem.withMaterial(stack, be.getMaterial());
            }
        }
        return stack;
    }

    public int getSlotCount() {
        return this.slotCount;
    }
}

