/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.shared.client;

import com.google.common.collect.Streams;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.mojang.blaze3d.platform.NativeImage;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.GsonHelper;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import slimeknights.mantle.command.GeneratePackHelper;
import slimeknights.mantle.data.datamap.RegistryDataMapLoader;
import slimeknights.mantle.data.loadable.ErrorFactory;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.mantle.util.typed.TypedMap;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.client.data.material.AbstractMaterialSpriteProvider;
import slimeknights.tconstruct.library.client.data.material.AbstractPartSpriteProvider;
import slimeknights.tconstruct.library.client.data.material.GeneratorPartTextureJsonGenerator;
import slimeknights.tconstruct.library.client.data.material.MaterialPartTextureGenerator;
import slimeknights.tconstruct.library.client.data.util.ResourceManagerSpriteReader;
import slimeknights.tconstruct.library.client.materials.MaterialGeneratorInfo;
import slimeknights.tconstruct.library.client.materials.MaterialRenderInfo;
import slimeknights.tconstruct.library.client.materials.MaterialRenderInfoLoader;
import slimeknights.tconstruct.library.materials.definition.IMaterial;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;
import slimeknights.tconstruct.library.materials.stats.MaterialStatsId;
import slimeknights.tconstruct.shared.network.GeneratePartTexturesPacket;

public class ClientGeneratePartTexturesCommand {
    private static final Logger log = LogManager.getLogger(ClientGeneratePartTexturesCommand.class);
    private static final String SUCCESS_KEY = TConstruct.makeTranslationKey("command", "generate_part_textures.finish");
    private static final String FAILURE_KEY = TConstruct.makeTranslationKey("command", "generate_part_textures.failure");
    private static final Component NO_PARTS = TConstruct.makeTranslation("command", "generate_part_textures.no_parts");
    private static final Component NO_MATERIALS = TConstruct.makeTranslation("command", "generate_part_textures.no_materials");
    private static final String PACK_NAME = "TinkersConstructGeneratedPartTextures";
    private static final String GENERATOR_PART_TEXTURES = "tinkering/generator_part_textures.json";
    private static final MaterialRenderInfo EMPTY = new MaterialRenderInfo(IMaterial.UNKNOWN_ID, null, new String[0], -1, 0);
    private static final RecordLoadable<AbstractMaterialSpriteProvider.MaterialSpriteInfo> SPRITE_LOADER = RecordLoadable.create((RecordField)MaterialRenderInfo.LOADABLE.directField(info -> EMPTY), (RecordField)MaterialGeneratorInfo.LOADABLE.requiredField("generator", Function.identity()), (RecordField)ErrorFactory.FIELD, (render, generator, error) -> {
        ResourceLocation texture = render.texture();
        if (texture == null) {
            throw error.create("Unable to create generator for material " + render.id() + " as it has no texture despite having a generator");
        }
        return new AbstractMaterialSpriteProvider.MaterialSpriteInfo(texture, render.fallbacks(), (MaterialGeneratorInfo)generator);
    });

    @Deprecated(forRemoval=true)
    protected static Component getOutputComponent(File file) {
        return GeneratePackHelper.getOutputComponent((File)file);
    }

    public static void generateTextures(GeneratePartTexturesPacket.Operation operation, String modId, String materialPath) {
        block10: {
            long time = System.nanoTime();
            try {
                ResourceManager manager = Minecraft.m_91087_().m_91098_();
                MaterialPartTextureGenerator.runCallbacks(null, manager);
                LocalPlayer player = Minecraft.m_91087_().f_91074_;
                GeneratorConfiguration generatorConfig = ClientGeneratePartTexturesCommand.loadGeneratorConfig(manager);
                if (generatorConfig.sprites.isEmpty()) {
                    if (player != null) {
                        player.m_5661_(NO_PARTS, false);
                    }
                    return;
                }
                Predicate<MaterialVariantId> validMaterialId = loc -> !(!modId.isEmpty() && !modId.equals(loc.getId().m_135827_()) || !materialPath.isEmpty() && !materialPath.equals(loc.getId().m_135815_()));
                List<AbstractMaterialSpriteProvider.MaterialSpriteInfo> materialSprites = ClientGeneratePartTexturesCommand.loadMaterialRenderInfoGenerators(manager, validMaterialId);
                if (materialSprites.isEmpty()) {
                    if (player != null) {
                        player.m_5661_(NO_MATERIALS, false);
                    }
                    return;
                }
                Path path = Minecraft.m_91087_().m_245161_().resolve(PACK_NAME);
                BiConsumer<ResourceLocation, NativeImage> saver = (outputPath, image) -> ClientGeneratePartTexturesCommand.saveImage(path, outputPath, image);
                BiConsumer<ResourceLocation, JsonObject> metaSaver = (outputPath, image) -> ClientGeneratePartTexturesCommand.saveMetadata(path, outputPath, image);
                GeneratePackHelper.saveMcmeta((Path)path, (PackType)PackType.CLIENT_RESOURCES, (String)"Generated Resources from the Tinkers' Construct Part Texture Generator");
                ResourceManagerSpriteReader spriteReader = new ResourceManagerSpriteReader(manager, "textures");
                MutableInt generated = new MutableInt(0);
                Predicate<ResourceLocation> shouldGenerate = operation == GeneratePartTexturesPacket.Operation.ALL ? exists -> {
                    generated.add(1);
                    return true;
                } : loc -> {
                    if (!spriteReader.exists((ResourceLocation)loc)) {
                        generated.add(1);
                        return true;
                    }
                    return false;
                };
                for (AbstractMaterialSpriteProvider.MaterialSpriteInfo material : materialSprites) {
                    block3: for (AbstractPartSpriteProvider.PartSpriteInfo part : generatorConfig.sprites) {
                        if (material.isVariant() && part.isSkipVariants()) continue;
                        for (MaterialStatsId statType : part.getStatTypes()) {
                            if (!material.supportStatType(statType) && !generatorConfig.statOverrides.hasOverride(statType, material.getTexture())) continue;
                            ResourceLocation spritePath = MaterialPartTextureGenerator.outputPath(part, material);
                            if (!shouldGenerate.test(spritePath)) continue block3;
                            MaterialPartTextureGenerator.generateSprite(spriteReader, material, part, spritePath, saver, metaSaver);
                            continue block3;
                        }
                    }
                }
                spriteReader.closeAll();
                long deltaTime = System.nanoTime() - time;
                int count = generated.getValue();
                MaterialPartTextureGenerator.runCallbacks(null, null);
                log.info("Finished generating {} textures in {} ms", (Object)count, (Object)Float.valueOf((float)deltaTime / 1000000.0f));
                if (Minecraft.m_91087_().f_91074_ != null) {
                    Minecraft.m_91087_().f_91074_.m_5661_((Component)Component.m_237110_((String)SUCCESS_KEY, (Object[])new Object[]{count, Float.valueOf((float)(deltaTime / 1000000L) / 1000.0f), GeneratePackHelper.getOutputComponent((File)path.toFile())}), false);
                }
            }
            catch (Exception e) {
                long deltaTime = System.nanoTime() - time;
                log.error("Failed to generate part textures after {} ms", (Object)Float.valueOf((float)deltaTime / 1000000.0f), (Object)e);
                if (Minecraft.m_91087_().f_91074_ == null) break block10;
                Minecraft.m_91087_().f_91074_.m_5661_((Component)Component.m_237110_((String)FAILURE_KEY, (Object[])new Object[]{Float.valueOf((float)(deltaTime / 1000000L) / 1000.0f), e.getMessage()}).m_130940_(ChatFormatting.RED), false);
            }
        }
    }

    private static void saveImage(Path folder, ResourceLocation location, NativeImage image) {
        Path path = folder.resolve(Paths.get(PackType.CLIENT_RESOURCES.m_10305_(), location.m_135827_(), "textures", location.m_135815_() + ".png"));
        try {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            image.m_85066_(path);
        }
        catch (IOException e) {
            log.error("Couldn't create image for {}", (Object)location, (Object)e);
        }
    }

    private static void saveMetadata(Path folder, ResourceLocation location, JsonObject meta) {
        Path path = folder.resolve(Paths.get(PackType.CLIENT_RESOURCES.m_10305_(), location.m_135827_(), "textures", location.m_135815_() + ".png.mcmeta"));
        try {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            String json = JsonHelper.DEFAULT_GSON.toJson((JsonElement)meta);
            try (BufferedWriter bufferedwriter = Files.newBufferedWriter(path, new OpenOption[0]);){
                bufferedwriter.write(json);
            }
        }
        catch (IOException e) {
            log.error("Couldn't create metadata for {}", (Object)location, (Object)e);
        }
    }

    private static GeneratorConfiguration loadGeneratorConfig(ResourceManager manager) {
        HashMap<ResourceLocation, AbstractPartSpriteProvider.PartSpriteInfo> builder = new HashMap<ResourceLocation, AbstractPartSpriteProvider.PartSpriteInfo>();
        GeneratorPartTextureJsonGenerator.StatOverride.Builder stats = new GeneratorPartTextureJsonGenerator.StatOverride.Builder();
        block7: for (String namespace : manager.m_7187_()) {
            ResourceLocation location = new ResourceLocation(namespace, GENERATOR_PART_TEXTURES);
            List resources = manager.m_213829_(location);
            if (resources.isEmpty()) continue;
            for (int r = resources.size() - 1; r >= 0; --r) {
                Resource resource = (Resource)resources.get(r);
                try {
                    BufferedReader reader = resource.m_215508_();
                    try {
                        JsonObject object = GsonHelper.m_13859_((Reader)reader);
                        for (AbstractPartSpriteProvider.PartSpriteInfo part : (List)AbstractPartSpriteProvider.PartSpriteInfo.LIST_LOADABLE.getIfPresent(object, "parts")) {
                            builder.merge(part.getPath(), part, (part1, part2) -> {
                                boolean allowAnimated = part1.isAllowAnimated();
                                if (allowAnimated != part2.isAllowAnimated()) {
                                    TConstruct.LOG.error("Texture {} has mismatching allowAnimated, forcing allow animated to false", (Object)part1.getPath());
                                    allowAnimated = false;
                                }
                                return new AbstractPartSpriteProvider.PartSpriteInfo(part1.getPath(), Streams.concat((Stream[])new Stream[]{part1.getStatTypes().stream(), part2.getStatTypes().stream()}).collect(Collectors.toSet()), allowAnimated, part1.isSkipVariants() && part2.isSkipVariants());
                            });
                        }
                        if (object.has("overrides")) {
                            for (Map.Entry entry : GsonHelper.m_13930_((JsonObject)object, (String)"overrides").entrySet()) {
                                String key = (String)entry.getKey();
                                MaterialStatsId statId = MaterialStatsId.PARSER.tryParse(key);
                                if (statId == null) {
                                    TConstruct.LOG.error("Invalid stat ID " + key);
                                    continue;
                                }
                                JsonArray array = GsonHelper.m_13924_((JsonElement)((JsonElement)entry.getValue()), (String)key);
                                for (int i = 0; i < array.size(); ++i) {
                                    stats.addVariant(statId, MaterialVariantId.parse(GsonHelper.m_13805_((JsonElement)array.get(i), (String)(key + "[" + i + "]"))));
                                }
                            }
                        }
                        if (!GsonHelper.m_13855_((JsonObject)object, (String)"replace", (boolean)false)) continue;
                        continue block7;
                    }
                    finally {
                        if (reader == null) continue block7;
                        reader.close();
                        continue block7;
                    }
                }
                catch (Exception ex) {
                    log.error("Failed to load generator config from {} for pack {}", (Object)location, (Object)resource.m_215506_(), (Object)ex);
                }
            }
        }
        return new GeneratorConfiguration(builder.values(), stats.build());
    }

    private static List<AbstractMaterialSpriteProvider.MaterialSpriteInfo> loadMaterialRenderInfoGenerators(ResourceManager manager, Predicate<MaterialVariantId> validMaterialId) {
        HashMap jsons = new HashMap();
        SimpleJsonResourceReloadListener.m_278771_((ResourceManager)manager, (String)"tinkering/materials", (Gson)JsonHelper.DEFAULT_GSON, jsons);
        HashMap<ResourceLocation, AbstractMaterialSpriteProvider.MaterialSpriteInfo> builder = new HashMap<ResourceLocation, AbstractMaterialSpriteProvider.MaterialSpriteInfo>();
        for (Map.Entry entry : jsons.entrySet()) {
            ResourceLocation location = (ResourceLocation)entry.getKey();
            MaterialVariantId id = MaterialRenderInfoLoader.variant(location);
            if (!validMaterialId.test(id)) continue;
            try {
                TypedMap context;
                AbstractMaterialSpriteProvider.MaterialSpriteInfo info;
                AbstractMaterialSpriteProvider.MaterialSpriteInfo oldInfo;
                JsonObject json = GsonHelper.m_13918_((JsonElement)((JsonElement)entry.getValue()), (String)location.toString());
                if (!json.has("generator") || (oldInfo = builder.putIfAbsent((info = (AbstractMaterialSpriteProvider.MaterialSpriteInfo)RegistryDataMapLoader.parseData((String)"Material Generator Info", jsons, (ResourceLocation)location, (JsonObject)json, null, SPRITE_LOADER, (TypedMap)(context = MaterialRenderInfoLoader.createContext(id)))).getTexture(), info)) == null) continue;
                TConstruct.LOG.error("Received multiple generators for texture {}: {}, {}", (Object)info.getTexture(), (Object)oldInfo.getTransformer(), (Object)info.getTransformer());
            }
            catch (JsonSyntaxException e) {
                log.error("Failed to read tool part texture generator info for {}", (Object)id, (Object)e);
            }
        }
        return List.copyOf(builder.values());
    }

    private record GeneratorConfiguration(Collection<AbstractPartSpriteProvider.PartSpriteInfo> sprites, GeneratorPartTextureJsonGenerator.StatOverride statOverrides) {
    }
}

