/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.nbt;

import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.tags.TagKey;
import slimeknights.tconstruct.library.modifiers.IncrementalModifierEntry;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.modifiers.ModifierManager;
import slimeknights.tconstruct.library.tools.helper.ModifierBuilder;

public class ModifierNBT
implements Iterable<ModifierEntry> {
    public static final ModifierNBT EMPTY = new ModifierNBT(Collections.emptyList());
    private final List<ModifierEntry> modifiers;

    public boolean isEmpty() {
        return this.modifiers.isEmpty();
    }

    public ModifierEntry getEntry(ModifierId modifier) {
        for (ModifierEntry entry : this.modifiers) {
            if (!entry.matches(modifier)) continue;
            return entry;
        }
        return ModifierEntry.EMPTY;
    }

    public int getLevel(ModifierId modifier) {
        return this.getEntry(modifier).getLevel();
    }

    public boolean has(TagKey<Modifier> tag) {
        for (ModifierEntry entry : this.modifiers) {
            if (!ModifierManager.isInTag(entry.getId(), tag)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterator<ModifierEntry> iterator() {
        return this.modifiers.iterator();
    }

    @Override
    public void forEach(Consumer<? super ModifierEntry> action) {
        this.modifiers.forEach(action);
    }

    @Override
    public Spliterator<ModifierEntry> spliterator() {
        return this.modifiers.spliterator();
    }

    public ModifierNBT withModifier(ModifierId modifier, int level) {
        if (level <= 0) {
            throw new IllegalArgumentException("Invalid level, must be above zero");
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        boolean found = false;
        for (ModifierEntry entry : this.modifiers) {
            if (!found && entry.matches(modifier)) {
                builder.add((Object)entry.withLevel(entry.getLevel() + level));
                found = true;
                continue;
            }
            builder.add((Object)entry);
        }
        if (!found) {
            builder.add((Object)new ModifierEntry(modifier, level));
        }
        return new ModifierNBT((List<ModifierEntry>)builder.build());
    }

    public ModifierNBT addAmount(ModifierId modifier, int amount, int needed) {
        if (amount <= 0 || needed <= 0) {
            return this;
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        boolean found = false;
        for (ModifierEntry entry : this.modifiers) {
            if (!found && entry.matches(modifier)) {
                builder.add((Object)entry.addAmount(amount, needed));
                found = true;
                continue;
            }
            builder.add((Object)entry);
        }
        if (!found) {
            builder.add((Object)IncrementalModifierEntry.of(modifier, 1, amount, needed));
        }
        return new ModifierNBT((List<ModifierEntry>)builder.build());
    }

    public ModifierNBT withoutModifier(ModifierId modifier, int level) {
        if (level <= 0) {
            throw new IllegalArgumentException("Invalid level, must be above zero");
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (ModifierEntry entry : this.modifiers) {
            if (entry.matches(modifier) && level > 0) {
                if (entry.getLevel() > level) {
                    builder.add((Object)entry.withLevel(entry.getLevel() - level));
                    level = 0;
                    continue;
                }
                level -= entry.getLevel();
                continue;
            }
            builder.add((Object)entry);
        }
        return new ModifierNBT((List<ModifierEntry>)builder.build());
    }

    public static ModifierNBT readFromNBT(@Nullable Tag inbt) {
        if (inbt == null || inbt.m_7060_() != 9) {
            return EMPTY;
        }
        ListTag listNBT = (ListTag)inbt;
        if (listNBT.m_7264_() != 10) {
            return EMPTY;
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int i = 0; i < listNBT.size(); ++i) {
            ModifierEntry entry = ModifierEntry.readFromNBT(listNBT.m_128728_(i));
            if (entry == ModifierEntry.EMPTY) continue;
            builder.add((Object)entry);
        }
        return new ModifierNBT((List<ModifierEntry>)builder.build());
    }

    public ListTag serializeToNBT() {
        ListTag list = new ListTag();
        for (ModifierEntry entry : this.modifiers) {
            list.add((Object)entry.serializeToNBT());
        }
        return list;
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ModifierNBT)) {
            return false;
        }
        ModifierNBT other = (ModifierNBT)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<ModifierEntry> this$modifiers = this.getModifiers();
        List<ModifierEntry> other$modifiers = other.getModifiers();
        return !(this$modifiers == null ? other$modifiers != null : !((Object)this$modifiers).equals(other$modifiers));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ModifierNBT;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<ModifierEntry> $modifiers = this.getModifiers();
        result = result * 59 + ($modifiers == null ? 43 : ((Object)$modifiers).hashCode());
        return result;
    }

    public ModifierNBT(List<ModifierEntry> modifiers) {
        this.modifiers = modifiers;
    }

    public List<ModifierEntry> getModifiers() {
        return this.modifiers;
    }

    public static class Builder
    implements ModifierBuilder {
        private final Map<ModifierId, ModifierEntry> modifiers = new LinkedHashMap<ModifierId, ModifierEntry>();

        private Builder() {
        }

        @Override
        public Builder add(ModifierEntry entry) {
            if (entry != ModifierEntry.EMPTY && entry.isBound()) {
                ModifierId id = entry.getId();
                ModifierEntry current = this.modifiers.get((Object)id);
                if (current != null) {
                    entry = current.merge(entry);
                }
                this.modifiers.put(id, entry);
            }
            return this;
        }

        @Override
        public ModifierNBT build() {
            List list = this.modifiers.values().stream().sorted(Comparator.comparingInt(entry -> -entry.getModifier().getPriority())).collect(Collectors.toList());
            if (list.isEmpty()) {
                return EMPTY;
            }
            return new ModifierNBT((List<ModifierEntry>)ImmutableList.copyOf(list));
        }
    }
}

