/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.item.ranged;

import java.util.function.Predicate;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.ForgeEventFactory;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.Sounds;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.build.ConditionalStatModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.interaction.GeneralInteractionModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.ranged.BowAmmoModifierHook;
import slimeknights.tconstruct.library.tools.capability.EntityModifierCapability;
import slimeknights.tconstruct.library.tools.capability.PersistentDataCapability;
import slimeknights.tconstruct.library.tools.definition.ToolDefinition;
import slimeknights.tconstruct.library.tools.helper.ModifierUtil;
import slimeknights.tconstruct.library.tools.helper.ToolDamageUtil;
import slimeknights.tconstruct.library.tools.item.ranged.ModifiableLauncherItem;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.library.tools.nbt.ModifierNBT;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.library.tools.stat.ToolStats;
import slimeknights.tconstruct.tools.entity.ThrownTool;
import slimeknights.tconstruct.tools.modifiers.ability.interaction.BlockingModifier;

public class ModifiableBowItem
extends ModifiableLauncherItem {
    private static final Predicate<ItemStack> BALLISTA_ONLY = stack -> stack.m_204117_(TinkerTags.Items.BALLISTA_AMMO);
    private static final Predicate<ItemStack> ARROWS_OR_BALLISTA = stack -> stack.m_204117_(ItemTags.f_13161_) || stack.m_204117_(TinkerTags.Items.BALLISTA_AMMO);
    public static final ResourceLocation KEY_BALLISTA = TConstruct.getResource("ballista");
    public static final int FLAG_BALLISTA_HELD = 1;
    public static final int FLAG_BALLISTA_QUIVER = 2;
    public static final int FLAG_NO_BALLISTA = 3;
    private final boolean storeDrawingItem;

    public ModifiableBowItem(Item.Properties properties, ToolDefinition toolDefinition, boolean storeDrawingItem) {
        super(properties, toolDefinition);
        this.storeDrawingItem = storeDrawingItem;
    }

    public ModifiableBowItem(Item.Properties properties, ToolDefinition toolDefinition) {
        this(properties, toolDefinition, false);
    }

    public Predicate<ItemStack> getSupportedBallistaAmmo() {
        return ARROWS_OR_BALLISTA;
    }

    public Predicate<ItemStack> m_6437_() {
        return ProjectileWeaponItem.f_43005_;
    }

    public int m_6615_() {
        return 15;
    }

    @Override
    public UseAnim m_6164_(ItemStack stack) {
        return BlockingModifier.blockWhileCharging(ToolStack.from(stack), UseAnim.BOW);
    }

    public static boolean isBallista(IToolStackView tool) {
        return tool.hasTag(TinkerTags.Items.BALLISTAS) && tool.getVolatileData().getBoolean(KEY_BALLISTA);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack bow = player.m_21120_(hand);
        ToolStack tool = ToolStack.from(bow);
        if (tool.isBroken()) {
            return InteractionResultHolder.m_19100_((Object)bow);
        }
        boolean isBallista = ModifiableBowItem.isBallista(tool);
        ItemStack ammo = BowAmmoModifierHook.getAmmo(tool, bow, (LivingEntity)player, isBallista ? this.getSupportedBallistaAmmo() : this.m_6442_());
        InteractionResultHolder override = ForgeEventFactory.onArrowNock((ItemStack)bow, (Level)level, (Player)player, (InteractionHand)hand, (!ammo.m_41619_() ? 1 : 0) != 0);
        if (override != null) {
            return override;
        }
        if (!player.m_150110_().f_35937_ && ammo.m_41619_() && !tool.getModifiers().has(TinkerTags.Modifiers.CHARGE_EMPTY_BOW_WITH_DRAWTIME)) {
            if (tool.getModifiers().has(TinkerTags.Modifiers.CHARGE_EMPTY_BOW_WITHOUT_DRAWTIME)) {
                player.m_6672_(hand);
                return InteractionResultHolder.m_19096_((Object)bow);
            }
            return InteractionResultHolder.m_19100_((Object)bow);
        }
        GeneralInteractionModifierHook.startDrawtime(tool, (LivingEntity)player, 1.0f);
        if (!ammo.m_41619_()) {
            if (this.storeDrawingItem) {
                tool.getPersistentData().put(KEY_DRAWBACK_AMMO, (Tag)ammo.m_41739_(new CompoundTag()));
            } else {
                tool.getPersistentData().putBoolean(KEY_DRAWBACK_AMMO, true);
            }
            if (isBallista) {
                int flag = ammo.m_204117_(TinkerTags.Items.BALLISTA_AMMO) ? (ammo == player.m_21205_() || ammo == player.m_21206_() ? 1 : 2) : 3;
                tool.getPersistentData().putInt(KEY_BALLISTA, flag);
            }
        }
        player.m_6672_(hand);
        if (!level.f_46443_) {
            level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), Sounds.LONGBOW_CHARGE.getSound(), SoundSource.PLAYERS, 0.75f, 1.0f);
        }
        return InteractionResultHolder.m_19096_((Object)bow);
    }

    public void m_5551_(ItemStack bow, Level level, LivingEntity living, int timeLeft) {
        float velocity;
        Player p;
        ToolStack tool = ToolStack.from(bow);
        int duration = this.m_8105_(bow);
        for (ModifierEntry entry : tool.getModifiers()) {
            entry.getHook(ModifierHooks.TOOL_USING).beforeReleaseUsing(tool, entry, living, duration, timeLeft, ModifierEntry.EMPTY);
        }
        if (tool.isBroken()) {
            return;
        }
        Player player = living instanceof Player ? (p = (Player)living) : null;
        boolean creative = player != null && player.m_150110_().f_35937_;
        Predicate ammoPredicate = switch (tool.getPersistentData().getInt(KEY_BALLISTA)) {
            case 1 -> null;
            case 2 -> BALLISTA_ONLY;
            case 3 -> this.m_6442_();
            default -> ModifiableBowItem.isBallista(tool) ? this.getSupportedBallistaAmmo() : this.m_6442_();
        };
        ItemStack foundAmmo = BowAmmoModifierHook.getAmmo(tool, bow, living, ammoPredicate);
        boolean hasAmmo = !foundAmmo.m_41619_() || creative && !tool.getVolatileData().getBoolean(BowAmmoModifierHook.SKIP_INVENTORY_AMMO);
        int chargeTime = duration - timeLeft;
        if (player != null) {
            chargeTime = ForgeEventFactory.onArrowLoose((ItemStack)bow, (Level)level, (Player)player, (int)chargeTime, (boolean)hasAmmo);
        }
        if (!hasAmmo || chargeTime < 0) {
            return;
        }
        float charge = GeneralInteractionModifierHook.getToolCharge(tool, chargeTime);
        float power = charge * (velocity = ConditionalStatModifierHook.getModifiedStat(tool, living, ToolStats.VELOCITY));
        if (power < 0.1f) {
            return;
        }
        if (!level.f_46443_) {
            ArrowItem arrow;
            Item item;
            ItemStack ammo;
            int originalSlot = -1;
            int desiredProjectiles = 1;
            if (foundAmmo.m_204117_(TinkerTags.Items.BALLISTA_AMMO)) {
                if (player != null) {
                    if (foundAmmo == living.m_21206_()) {
                        originalSlot = 40;
                    } else {
                        Inventory inventory = player.m_150109_();
                        for (int i = 0; i < 36; ++i) {
                            if (inventory.m_8020_(i) != foundAmmo) continue;
                            originalSlot = i;
                            break;
                        }
                    }
                }
            } else {
                desiredProjectiles = BowAmmoModifierHook.getDesiredProjectiles(tool);
            }
            if ((ammo = BowAmmoModifierHook.consumeAmmo(tool, bow, living, player, ammoPredicate, desiredProjectiles)).m_41619_()) {
                ammo = new ItemStack((ItemLike)Items.f_42412_);
            }
            ArrowItem arrowItem = (item = ammo.m_41720_()) instanceof ArrowItem ? (arrow = (ArrowItem)item) : (ArrowItem)Items.f_42412_;
            boolean thrownTool = ammo.m_204117_(TinkerTags.Items.BALLISTA_AMMO);
            float waterInertia = 0.6f;
            SoundEvent sound = SoundEvents.f_11687_;
            if (thrownTool) {
                sound = SoundEvents.f_12520_;
                ToolStack thrown = ToolStack.from(ammo);
                float thrownVelocity = ConditionalStatModifierHook.getModifiedStat(thrown, living, ToolStats.VELOCITY);
                power *= thrownVelocity * ConditionalStatModifierHook.getModifiedStat(thrown, living, ToolStats.DRAW_SPEED) / 1.5f;
                if (ammo.m_204117_(TinkerTags.Items.MELEE_WEAPON)) {
                    power *= thrown.getStats().get(ToolStats.ATTACK_SPEED).floatValue();
                }
                velocity *= thrownVelocity;
                waterInertia = ConditionalStatModifierHook.getModifiedStat(thrown, living, ToolStats.WATER_INERTIA);
            }
            float inaccuracy = ModifierUtil.getInaccuracy(tool, living);
            float startAngle = ModifiableBowItem.getAngleStart(ammo.m_41613_());
            int primaryIndex = ammo.m_41613_() / 2;
            for (int arrowIndex = 0; arrowIndex < ammo.m_41613_(); ++arrowIndex) {
                Object arrow2;
                if (thrownTool) {
                    ThrownTool thrown = new ThrownTool(level, living, ammo, charge, velocity, waterInertia);
                    thrown.setOriginalSlot(originalSlot);
                    arrow2 = thrown;
                } else {
                    arrow2 = arrowItem.m_6394_(level, ammo, living);
                }
                float angle = startAngle + (float)(10 * arrowIndex);
                arrow2.m_37251_((Entity)living, living.m_146909_() + angle, living.m_146908_(), 0.0f, power * 3.0f, inaccuracy);
                if (charge == 1.0f) {
                    arrow2.m_36762_(true);
                }
                float baseArrowDamage = (float)(arrow2.m_36789_() - 2.0 + (double)tool.getStats().get(ToolStats.PROJECTILE_DAMAGE).floatValue());
                arrow2.m_36781_((double)ConditionalStatModifierHook.getModifiedStat(tool, living, ToolStats.PROJECTILE_DAMAGE, baseArrowDamage));
                ModifierNBT modifiers = tool.getModifiers();
                EntityModifierCapability.getCapability((Entity)arrow2).addModifiers(modifiers);
                ModDataNBT arrowData = PersistentDataCapability.getOrWarn((Entity)arrow2);
                if (creative) {
                    arrow2.f_36705_ = AbstractArrow.Pickup.CREATIVE_ONLY;
                }
                for (ModifierEntry entry : modifiers.getModifiers()) {
                    entry.getHook(ModifierHooks.PROJECTILE_LAUNCH).onProjectileLaunch(tool, entry, living, ammo, (Projectile)arrow2, (AbstractArrow)arrow2, arrowData, arrowIndex == primaryIndex);
                }
                if (thrownTool) {
                    ((ThrownTool)arrow2).onRelease(living, arrowData);
                }
                level.m_7967_((Entity)arrow2);
                level.m_6263_(null, living.m_20185_(), living.m_20186_(), living.m_20189_(), sound, SoundSource.PLAYERS, 1.0f, 1.0f / (level.m_213780_().m_188501_() * 0.4f + 1.2f) + charge * 0.5f + angle / 10.0f);
            }
            int damage = ammo.m_41613_();
            if (thrownTool) {
                damage *= 3;
            }
            ToolDamageUtil.damageAnimated((IToolStackView)tool, damage, living, living.m_7655_());
        }
        if (player != null) {
            player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
        }
    }

    @Override
    protected void onStopUsing(IToolStackView tool, LivingEntity entity, int timeLeft) {
        super.onStopUsing(tool, entity, timeLeft);
        tool.getPersistentData().remove(KEY_BALLISTA);
    }
}

