/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.definition.module.material;

import java.util.Collection;
import slimeknights.tconstruct.library.materials.definition.MaterialId;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.tools.definition.module.ToolHooks;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;

public interface MaterialRepairToolHook {
    public boolean isRepairMaterial(IToolStackView var1, MaterialId var2);

    public float getRepairAmount(IToolStackView var1, MaterialId var2);

    public static boolean canRepairWith(IToolStackView tool, MaterialId material) {
        if (tool.getHook(ToolHooks.MATERIAL_REPAIR).isRepairMaterial(tool, material)) {
            return true;
        }
        for (ModifierEntry entry : tool.getModifiers()) {
            if (!entry.getHook(ModifierHooks.MATERIAL_REPAIR).isRepairMaterial(tool, entry, material)) continue;
            return true;
        }
        return false;
    }

    public static float repairAmount(IToolStackView tool, MaterialId material) {
        float maxRepair = tool.getHook(ToolHooks.MATERIAL_REPAIR).getRepairAmount(tool, material);
        for (ModifierEntry entry : tool.getModifiers()) {
            float repair = entry.getHook(ModifierHooks.MATERIAL_REPAIR).getRepairAmount(tool, entry, material);
            if (!(repair > maxRepair)) continue;
            maxRepair = repair;
        }
        return maxRepair;
    }

    public record MaxMerger(Collection<MaterialRepairToolHook> hooks) implements MaterialRepairToolHook
    {
        @Override
        public boolean isRepairMaterial(IToolStackView tool, MaterialId material) {
            for (MaterialRepairToolHook hook : this.hooks) {
                if (!hook.isRepairMaterial(tool, material)) continue;
                return true;
            }
            return false;
        }

        @Override
        public float getRepairAmount(IToolStackView tool, MaterialId material) {
            float maxRepair = 0.0f;
            for (MaterialRepairToolHook hook : this.hooks) {
                float repair = hook.getRepairAmount(tool, material);
                if (!(repair > maxRepair)) continue;
                maxRepair = repair;
            }
            return maxRepair;
        }
    }
}

