/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers.modules.util;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.TooltipFlag;
import slimeknights.mantle.client.TooltipKey;
import slimeknights.mantle.data.predicate.IJsonPredicate;
import slimeknights.tconstruct.library.json.predicate.TinkerPredicate;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.hook.display.TooltipModifierHook;
import slimeknights.tconstruct.library.modifiers.modules.util.ModifierCondition;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.stat.INumericToolStat;

public interface ConditionalStatTooltip
extends TooltipModifierHook,
ModifierCondition.ConditionalModule<IToolStackView> {
    public IJsonPredicate<LivingEntity> holder();

    public INumericToolStat<?> stat();

    public boolean percent();

    public float computeTooltipValue(IToolStackView var1, ModifierEntry var2, @Nullable Player var3);

    default public boolean matchesTool(IToolStackView tool, ModifierEntry entry) {
        return this.condition().matches(tool, entry);
    }

    @Override
    default public void addTooltip(IToolStackView tool, ModifierEntry entry, @Nullable Player player, List<Component> tooltip, TooltipKey tooltipKey, TooltipFlag tooltipFlag) {
        INumericToolStat<?> stat = this.stat();
        IJsonPredicate<LivingEntity> holder = this.holder();
        if (stat.supports(tool.getItem()) && this.matchesTool(tool, entry) && TinkerPredicate.matchesInTooltip(holder, (LivingEntity)player, tooltipKey)) {
            Modifier modifier = entry.getModifier();
            Component statName = TooltipModifierHook.statName(modifier, stat);
            float value = this.computeTooltipValue(tool, entry, (Player)(tooltipKey == TooltipKey.SHIFT ? player : null)) - 1.0f;
            if (value != 0.0f) {
                if (this.percent()) {
                    TooltipModifierHook.addPercentBoost(modifier, statName, value, tooltip);
                } else {
                    TooltipModifierHook.addFlatBoost(modifier, statName, value, tooltip);
                }
            }
        }
    }
}

