/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers.modules.combat;

import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.phys.EntityHitResult;
import slimeknights.mantle.data.loadable.Loadables;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.primitive.BooleanLoadable;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.mantle.data.predicate.IJsonPredicate;
import slimeknights.mantle.data.predicate.entity.LivingEntityPredicate;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.json.LevelingValue;
import slimeknights.tconstruct.library.json.RandomLevelingValue;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.armor.OnAttackedModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.combat.MeleeHitModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.combat.MonsterMeleeHitModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.ranged.ProjectileHitModifierHook;
import slimeknights.tconstruct.library.modifiers.modules.ModifierModule;
import slimeknights.tconstruct.library.modifiers.modules.util.ModifierCondition;
import slimeknights.tconstruct.library.modifiers.modules.util.ModuleBuilder;
import slimeknights.tconstruct.library.module.HookProvider;
import slimeknights.tconstruct.library.module.ModuleHook;
import slimeknights.tconstruct.library.tools.context.EquipmentContext;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.helper.ToolDamageUtil;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.library.tools.nbt.ModifierNBT;
import slimeknights.tconstruct.tools.modules.armor.CounterModule;

public record MobEffectModule(IJsonPredicate<LivingEntity> target, MobEffect effect, RandomLevelingValue level, RandomLevelingValue time, LevelingValue chance, boolean applyBeforeMelee, ModifierCondition<IToolStackView> condition) implements OnAttackedModifierHook,
MeleeHitModifierHook,
MonsterMeleeHitModifierHook,
ProjectileHitModifierHook,
ModifierModule,
ModifierCondition.ConditionalModule<IToolStackView>
{
    private static final List<ModuleHook<?>> DEFAULT_HOOKS = HookProvider.defaultHooks(ModifierHooks.ON_ATTACKED, ModifierHooks.MELEE_HIT, ModifierHooks.MONSTER_MELEE_HIT, ModifierHooks.PROJECTILE_HIT);
    public static final RecordLoadable<MobEffectModule> LOADER = RecordLoadable.create((RecordField)LivingEntityPredicate.LOADER.defaultField("target", MobEffectModule::target), (RecordField)Loadables.MOB_EFFECT.requiredField("effect", MobEffectModule::effect), (RecordField)RandomLevelingValue.LOADABLE.requiredField("level", MobEffectModule::level), (RecordField)RandomLevelingValue.LOADABLE.requiredField("time", MobEffectModule::time), (RecordField)LevelingValue.LOADABLE.defaultField("chance", (Object)LevelingValue.eachLevel(0.25f), false, MobEffectModule::chance), (RecordField)BooleanLoadable.INSTANCE.defaultField("apply_before_melee", (Object)false, false, MobEffectModule::applyBeforeMelee), ModifierCondition.TOOL_FIELD, MobEffectModule::new);

    public static Builder builder(MobEffect effect) {
        return new Builder(effect);
    }

    public static Builder builder(Supplier<? extends MobEffect> effect) {
        return new Builder(effect.get());
    }

    private void applyEffect(@Nullable LivingEntity target, float scaledLevel) {
        if (target == null || !this.target.matches((Object)target)) {
            return;
        }
        int level = Math.round(this.level.computeValue(scaledLevel)) - 1;
        if (level < 0) {
            return;
        }
        float duration = this.time.computeValue(scaledLevel);
        if (duration > 0.0f) {
            target.m_7292_(new MobEffectInstance(this.effect, (int)duration, level));
        }
    }

    @Override
    public void onAttacked(IToolStackView tool, ModifierEntry modifier, EquipmentContext context, EquipmentSlot slotType, DamageSource source, float amount, boolean isDirectDamage) {
        Entity attacker = source.m_7639_();
        if (isDirectDamage && tool.hasTag(TinkerTags.Items.ARMOR) && this.condition.matches(tool, modifier) && attacker instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)attacker;
            LivingEntity defender = context.getEntity();
            float scaledLevel = CounterModule.getLevel(tool, modifier, slotType, defender);
            float chance = this.chance.compute(scaledLevel);
            if (chance >= 1.0f || TConstruct.RANDOM.nextFloat() < chance) {
                this.applyEffect(living, scaledLevel);
                ToolDamageUtil.damageAnimated(tool, 1, defender, slotType);
            }
        }
    }

    @Override
    public float beforeMeleeHit(IToolStackView tool, ModifierEntry modifier, ToolAttackContext context, float damage, float baseKnockback, float knockback) {
        if (this.applyBeforeMelee && this.condition.matches(tool, modifier)) {
            this.applyEffect(context.getLivingTarget(), modifier.getEffectiveLevel());
        }
        return knockback;
    }

    @Override
    public void afterMeleeHit(IToolStackView tool, ModifierEntry modifier, ToolAttackContext context, float damageDealt) {
        if (!this.applyBeforeMelee && this.condition.matches(tool, modifier)) {
            this.applyEffect(context.getLivingTarget(), modifier.getEffectiveLevel());
        }
    }

    @Override
    public void onMonsterMeleeHit(IToolStackView tool, ModifierEntry modifier, ToolAttackContext context, float damage) {
        if (this.condition.matches(tool, modifier)) {
            this.applyEffect(context.getLivingTarget(), modifier.getEffectiveLevel());
        }
    }

    @Override
    public boolean onProjectileHitEntity(ModifierNBT modifiers, ModDataNBT persistentData, ModifierEntry modifier, Projectile projectile, EntityHitResult hit, @Nullable LivingEntity attacker, @Nullable LivingEntity target) {
        if (this.condition.modifierLevel().test(modifier.getLevel())) {
            this.applyEffect(target, modifier.getEffectiveLevel());
        }
        return false;
    }

    @Override
    public List<ModuleHook<?>> getDefaultHooks() {
        return DEFAULT_HOOKS;
    }

    public RecordLoadable<MobEffectModule> getLoader() {
        return LOADER;
    }

    public static class Builder
    extends ModuleBuilder.Stack<Builder> {
        private final MobEffect effect;
        private IJsonPredicate<LivingEntity> target = LivingEntityPredicate.ANY;
        private RandomLevelingValue level = RandomLevelingValue.flat(1.0f);
        private RandomLevelingValue time = RandomLevelingValue.flat(0.0f);
        private LevelingValue chance = LevelingValue.eachLevel(0.25f);
        private boolean applyBeforeMelee = false;

        public MobEffectModule build() {
            return new MobEffectModule(this.target, this.effect, this.level, this.time, this.chance, this.applyBeforeMelee, this.condition);
        }

        private Builder(MobEffect effect) {
            this.effect = effect;
        }

        public Builder target(IJsonPredicate<LivingEntity> target) {
            this.target = target;
            return this;
        }

        public Builder level(RandomLevelingValue level) {
            this.level = level;
            return this;
        }

        public Builder time(RandomLevelingValue time) {
            this.time = time;
            return this;
        }

        public Builder chance(LevelingValue chance) {
            this.chance = chance;
            return this;
        }

        public Builder applyBeforeMelee(boolean applyBeforeMelee) {
            this.applyBeforeMelee = applyBeforeMelee;
            return this;
        }
    }
}

