/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.json.variable.power;

import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import javax.annotation.Nullable;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraftforge.common.crafting.conditions.ICondition;
import slimeknights.mantle.data.loadable.mapping.ConditionalLoadable;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.tconstruct.library.json.variable.power.PowerVariable;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.library.tools.nbt.ModifierNBT;
import slimeknights.tconstruct.library.utils.Util;

public final class LoadConditionPowerVariable
extends Record
implements PowerVariable,
ConditionalLoadable.ConditionalObject<PowerVariable> {
    private final PowerVariable ifTrue;
    private final PowerVariable ifFalse;
    private final ICondition[] conditions;

    public LoadConditionPowerVariable(PowerVariable ifTrue, PowerVariable ifFalse, ICondition ... conditions) {
        this.ifTrue = ifTrue;
        this.ifFalse = ifFalse;
        this.conditions = conditions;
    }

    @Override
    public float getValue(ModifierNBT modifiers, ModDataNBT persistentData, ModifierEntry modifier, @Nullable Projectile projectile, @Nullable EntityHitResult hit, @Nullable LivingEntity attacker, @Nullable LivingEntity target) {
        return (Util.testConditions(this.conditions) ? this.ifTrue : this.ifFalse).getValue(modifiers, persistentData, modifier, projectile, hit, attacker, target);
    }

    @Override
    public RecordLoadable<? extends PowerVariable> getLoader() {
        return PowerVariable.LOADER.getConditionalLoader();
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{LoadConditionPowerVariable.class, "ifTrue;ifFalse;conditions", "ifTrue", "ifFalse", "conditions"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{LoadConditionPowerVariable.class, "ifTrue;ifFalse;conditions", "ifTrue", "ifFalse", "conditions"}, this);
    }

    @Override
    public final boolean equals(Object o) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{LoadConditionPowerVariable.class, "ifTrue;ifFalse;conditions", "ifTrue", "ifFalse", "conditions"}, this, o);
    }

    public PowerVariable ifTrue() {
        return this.ifTrue;
    }

    public PowerVariable ifFalse() {
        return this.ifFalse;
    }

    public ICondition[] conditions() {
        return this.conditions;
    }
}

