/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.json.variable.entity;

import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.common.crafting.conditions.ICondition;
import slimeknights.mantle.data.loadable.mapping.ConditionalLoadable;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.tconstruct.library.json.variable.entity.EntityVariable;
import slimeknights.tconstruct.library.utils.Util;

public final class LoadConditionEntityVariable
extends Record
implements EntityVariable,
ConditionalLoadable.ConditionalObject<EntityVariable> {
    private final EntityVariable ifTrue;
    private final EntityVariable ifFalse;
    private final ICondition[] conditions;

    public LoadConditionEntityVariable(EntityVariable ifTrue, EntityVariable ifFalse, ICondition ... conditions) {
        this.ifTrue = ifTrue;
        this.ifFalse = ifFalse;
        this.conditions = conditions;
    }

    @Override
    public float getValue(LivingEntity entity) {
        return (Util.testConditions(this.conditions) ? this.ifTrue : this.ifFalse).getValue(entity);
    }

    @Override
    public RecordLoadable<? extends EntityVariable> getLoader() {
        return EntityVariable.LOADER.getConditionalLoader();
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{LoadConditionEntityVariable.class, "ifTrue;ifFalse;conditions", "ifTrue", "ifFalse", "conditions"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{LoadConditionEntityVariable.class, "ifTrue;ifFalse;conditions", "ifTrue", "ifFalse", "conditions"}, this);
    }

    @Override
    public final boolean equals(Object o) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{LoadConditionEntityVariable.class, "ifTrue;ifFalse;conditions", "ifTrue", "ifFalse", "conditions"}, this, o);
    }

    public EntityVariable ifTrue() {
        return this.ifTrue;
    }

    public EntityVariable ifFalse() {
        return this.ifFalse;
    }

    public ICondition[] conditions() {
        return this.conditions;
    }
}

