/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.json.predicate.material;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.function.Function;
import net.minecraft.network.FriendlyByteBuf;
import slimeknights.mantle.data.loadable.field.LoadableField;
import slimeknights.mantle.data.predicate.IJsonPredicate;
import slimeknights.mantle.util.typed.TypedMap;
import slimeknights.tconstruct.library.json.predicate.material.MaterialIdPredicate;
import slimeknights.tconstruct.library.json.predicate.material.MaterialPredicate;
import slimeknights.tconstruct.library.json.predicate.material.MaterialVariantPredicate;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;

public record MaterialPredicateField<P>(String key, Function<P, IJsonPredicate<MaterialVariantId>> getter, boolean compact) implements LoadableField<IJsonPredicate<MaterialVariantId>, P>
{
    public MaterialPredicateField(String key, Function<P, IJsonPredicate<MaterialVariantId>> getter) {
        this(key, getter, true);
    }

    public IJsonPredicate<MaterialVariantId> get(JsonObject json, String key, TypedMap context) {
        if (json.has(key)) {
            JsonElement element = json.get(key);
            if (element.isJsonPrimitive()) {
                return MaterialPredicate.variant((MaterialVariantId)MaterialVariantId.LOADABLE.convert(element, key, context));
            }
            return (IJsonPredicate)MaterialPredicate.LOADER.convert(element, key, context);
        }
        return MaterialPredicate.ANY;
    }

    public void serialize(P parent, JsonObject json) {
        IJsonPredicate<MaterialVariantId> predicate = this.getter.apply(parent);
        if (predicate != MaterialPredicate.ANY) {
            if (this.compact) {
                MaterialVariantPredicate variantPredicate;
                MaterialIdPredicate idPredicate;
                if (predicate instanceof MaterialIdPredicate && (idPredicate = (MaterialIdPredicate)predicate).ids().size() == 1) {
                    json.addProperty(this.key, idPredicate.ids().iterator().next().toString());
                    return;
                }
                if (predicate instanceof MaterialVariantPredicate && (variantPredicate = (MaterialVariantPredicate)predicate).values().size() == 1) {
                    MaterialVariantId id = variantPredicate.values().iterator().next();
                    if (id.getVariant().isEmpty()) {
                        id = MaterialVariantId.create(id.getId(), "default");
                    }
                    json.addProperty(this.key, id.toString());
                    return;
                }
            }
            JsonObject serialized = new JsonObject();
            MaterialPredicate.LOADER.serialize(predicate, serialized);
            json.add(this.key, (JsonElement)serialized);
        }
    }

    public IJsonPredicate<MaterialVariantId> decode(FriendlyByteBuf buffer, TypedMap context) {
        return (IJsonPredicate)MaterialPredicate.LOADER.decode(buffer, context);
    }

    public void encode(FriendlyByteBuf buffer, P parent) {
        MaterialPredicate.LOADER.encode(buffer, this.getter.apply(parent));
    }
}

