/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.data.recipe;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.CheckReturnValue;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.tags.IntrinsicHolderTagsProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import org.jetbrains.annotations.ApiStatus;
import slimeknights.mantle.registration.object.FluidObject;

@CanIgnoreReturnValue
public class CostTagAppender {
    private final String metal;
    private final ResourceLocation prefix;
    private final String suffix;
    private final Function<ResourceLocation, IntrinsicHolderTagsProvider.IntrinsicTagAppender<Item>> tag;
    private final Map<Integer, IntrinsicHolderTagsProvider.IntrinsicTagAppender<Item>> tags = new HashMap<Integer, IntrinsicHolderTagsProvider.IntrinsicTagAppender<Item>>();

    public static CostTagAppender moltenToolMelting(FluidObject<?> fluid, Function<ResourceLocation, IntrinsicHolderTagsProvider.IntrinsicTagAppender<Item>> tag) {
        ResourceLocation id = fluid.getId();
        String metal = id.m_135815_().substring("molten_".length());
        return CostTagAppender.moltenToolMelting(id.m_135827_(), metal, tag);
    }

    public static CostTagAppender moltenToolMelting(String domain, String metal, Function<ResourceLocation, IntrinsicHolderTagsProvider.IntrinsicTagAppender<Item>> tag) {
        return new CostTagAppender(metal, new ResourceLocation(domain, "melting/" + metal + "/tools_costing_"), "", tag);
    }

    @CheckReturnValue
    public IntrinsicHolderTagsProvider.IntrinsicTagAppender<Item> tag(int cost) {
        IntrinsicHolderTagsProvider.IntrinsicTagAppender<Item> appender = this.tags.get(cost);
        if (appender == null) {
            appender = this.tag.apply(this.prefix.m_266382_(cost + this.suffix));
            this.tags.put(cost, appender);
        }
        return appender;
    }

    public CostTagAppender add(int cost, Item ... items) {
        this.tag(cost).m_255179_((Object[])items);
        return this;
    }

    public CostTagAppender add(int cost, boolean optional, ResourceLocation prefix, String ... suffixes) {
        IntrinsicHolderTagsProvider.IntrinsicTagAppender<Item> tag = this.tag(cost);
        if (optional) {
            if (suffixes.length == 0) {
                tag.m_176839_(prefix);
            } else {
                for (String path : suffixes) {
                    tag.m_176839_(prefix.m_266382_("_" + path));
                }
            }
        } else if (suffixes.length == 0) {
            tag.m_255204_(ResourceKey.m_135785_((ResourceKey)Registries.f_256913_, (ResourceLocation)prefix));
        } else {
            for (String path : suffixes) {
                tag.m_255204_(ResourceKey.m_135785_((ResourceKey)Registries.f_256913_, (ResourceLocation)prefix.m_266382_("_" + path)));
            }
        }
        return this;
    }

    public CostTagAppender optionalMetal(int cost, String domain, String ... suffixes) {
        return this.add(cost, true, new ResourceLocation(domain, this.metal), suffixes);
    }

    public CostTagAppender metalTag(int cost, String prefix, String ... names) {
        IntrinsicHolderTagsProvider.IntrinsicTagAppender<Item> tag = this.tag(cost);
        for (String name : names) {
            tag.m_176841_(new ResourceLocation("forge", prefix + name + "/" + this.metal));
        }
        return this;
    }

    public CostTagAppender toolTag(int cost, String ... names) {
        return this.metalTag(cost, "tools/", names);
    }

    public CostTagAppender armorTag(int cost, String ... names) {
        return this.metalTag(cost, "armors/", names);
    }

    @ApiStatus.Internal
    public CostTagAppender minecraft(String metal) {
        ResourceLocation prefix = new ResourceLocation(metal);
        this.add(1, false, prefix, "shovel");
        this.add(2, false, prefix, "sword", "hoe");
        this.add(3, false, prefix, "pickaxe", "axe");
        this.add(7, false, prefix, "leggings");
        this.toolTag(7, "paxels");
        this.optionalMetal(1, "tools_complement", "knife");
        this.optionalMetal(3, "tools_complement", "sickle");
        return this;
    }

    @ApiStatus.Internal
    public CostTagAppender minecraft() {
        return this.minecraft(this.metal);
    }

    public CostTagAppender toolTags() {
        this.toolTag(2, "swords", "hoes");
        this.toolTag(3, "pickaxes", "axes");
        return this;
    }

    @ApiStatus.Internal
    public CostTagAppender toolsComplement() {
        this.toolTag(1, "shovels");
        this.optionalMetal(1, "tools_complement", "knife");
        this.optionalMetal(3, "tools_complement", "sickle");
        return this;
    }

    public CostTagAppender leggingsPaxel() {
        return this.armorTag(7, "leggings").toolTag(7, "paxels");
    }

    public CostTagAppender fdKnife() {
        return this.optionalMetal(1, "farmersdelight", "knife");
    }

    @ApiStatus.Internal
    public CostTagAppender crowbar() {
        return this.optionalMetal(3, "railcraft", "crowbar");
    }

    @ApiStatus.Internal
    public CostTagAppender excavatorSpikeMaul() {
        return this.optionalMetal(11, "tools_complement", "excavator").optionalMetal(11, "railcraft", "spike_maul");
    }

    public CostTagAppender(String metal, ResourceLocation prefix, String suffix, Function<ResourceLocation, IntrinsicHolderTagsProvider.IntrinsicTagAppender<Item>> tag) {
        this.metal = metal;
        this.prefix = prefix;
        this.suffix = suffix;
        this.tag = tag;
    }
}

