/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client.data.util;

import com.google.gson.JsonObject;
import com.mojang.blaze3d.platform.NativeImage;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.GsonHelper;
import slimeknights.tconstruct.library.client.data.util.AbstractSpriteReader;

public class ResourceManagerSpriteReader
extends AbstractSpriteReader {
    private final ResourceManager manager;
    private final String folder;

    private ResourceLocation getLocation(ResourceLocation base, String extension) {
        return new ResourceLocation(base.m_135827_(), this.folder + "/" + base.m_135815_() + extension);
    }

    private ResourceLocation getLocation(ResourceLocation base) {
        return this.getLocation(base, ".png");
    }

    @Override
    public boolean exists(ResourceLocation path) {
        return this.manager.m_213713_(this.getLocation(path)).isPresent();
    }

    @Override
    public boolean metadataExists(ResourceLocation path) {
        return this.manager.m_213713_(this.getLocation(path, ".png.mcmeta")).isPresent();
    }

    @Override
    public NativeImage read(ResourceLocation path) throws IOException {
        Resource resource = (Resource)this.manager.m_213713_(this.getLocation(path)).orElseThrow(FileNotFoundException::new);
        NativeImage image = NativeImage.m_85058_((InputStream)resource.m_215507_());
        this.openedImages.add(image);
        return image;
    }

    @Override
    @Nullable
    public NativeImage readIfExists(ResourceLocation path) {
        Optional resource = this.manager.m_213713_(this.getLocation(path));
        if (resource.isPresent()) {
            try {
                NativeImage image = NativeImage.m_85058_((InputStream)((Resource)resource.get()).m_215507_());
                this.openedImages.add(image);
                return image;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    @Override
    public JsonObject readMetadata(ResourceLocation path) throws IOException {
        try (BufferedReader reader = ((Resource)this.manager.m_213713_(this.getLocation(path, ".png.mcmeta")).orElseThrow(FileNotFoundException::new)).m_215508_();){
            JsonObject jsonObject = GsonHelper.m_13859_((Reader)reader);
            return jsonObject;
        }
    }

    public ResourceManagerSpriteReader(ResourceManager manager, String folder) {
        this.manager = manager;
        this.folder = folder;
    }
}

