/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client.armor.texture;

import java.util.Optional;
import java.util.function.Function;
import net.minecraft.Util;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import slimeknights.mantle.data.loadable.Loadables;
import slimeknights.mantle.data.loadable.field.LoadableField;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.primitive.IntLoadable;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.tconstruct.library.client.armor.texture.ArmorTextureSupplier;
import slimeknights.tconstruct.library.client.armor.texture.TintedArmorTexture;
import slimeknights.tconstruct.library.client.materials.MaterialRenderInfo;
import slimeknights.tconstruct.library.client.materials.MaterialRenderInfoLoader;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;
import slimeknights.tconstruct.library.tools.helper.ModifierUtil;

public abstract class MaterialArmorTextureSupplier
implements ArmorTextureSupplier {
    private static final LoadableField<ResourceLocation, MaterialArmorTextureSupplier> PREFIX_FIELD = Loadables.RESOURCE_LOCATION.requiredField("prefix", m -> m.prefix);
    private final ResourceLocation prefix;
    private final Function<String, ArmorTextureSupplier.ArmorTexture>[] textures;

    private static ArmorTextureSupplier.ArmorTexture tryTexture(ResourceLocation name, int color, int luminosity, String material) {
        ResourceLocation texture = name.m_266382_(material);
        if (TEXTURE_VALIDATOR.test(texture)) {
            return new TintedArmorTexture(ArmorTextureSupplier.getTexturePath(texture), color, luminosity);
        }
        return ArmorTextureSupplier.ArmorTexture.EMPTY;
    }

    public static Function<String, ArmorTextureSupplier.ArmorTexture> materialGetter(ResourceLocation name) {
        if (!TEXTURE_VALIDATOR.test(name)) {
            return material -> ArmorTextureSupplier.ArmorTexture.EMPTY;
        }
        return Util.m_143827_(materialStr -> {
            if (!materialStr.isEmpty()) {
                Optional<MaterialRenderInfo> infoOptional;
                MaterialVariantId material = MaterialVariantId.tryParse(materialStr);
                int color = -1;
                int luminosity = 0;
                if (material != null && (infoOptional = MaterialRenderInfoLoader.INSTANCE.getRenderInfo(material)).isPresent()) {
                    ArmorTextureSupplier.ArmorTexture texture;
                    MaterialRenderInfo info = infoOptional.get();
                    ResourceLocation untinted = info.texture();
                    luminosity = info.luminosity();
                    if (untinted != null && (texture = MaterialArmorTextureSupplier.tryTexture(name, -1, luminosity, "_" + untinted.m_135827_() + "_" + untinted.m_135815_())) != ArmorTextureSupplier.ArmorTexture.EMPTY) {
                        return texture;
                    }
                    color = info.vertexColor();
                    for (String fallback : info.fallbacks()) {
                        ArmorTextureSupplier.ArmorTexture texture2 = MaterialArmorTextureSupplier.tryTexture(name, color, luminosity, "_" + fallback);
                        if (texture2 == ArmorTextureSupplier.ArmorTexture.EMPTY) continue;
                        return texture2;
                    }
                }
                return new TintedArmorTexture(ArmorTextureSupplier.getTexturePath(name), color, luminosity);
            }
            return ArmorTextureSupplier.ArmorTexture.EMPTY;
        });
    }

    public MaterialArmorTextureSupplier(ResourceLocation prefix) {
        this.prefix = prefix;
        this.textures = new Function[]{MaterialArmorTextureSupplier.materialGetter(prefix.m_266382_("armor")), MaterialArmorTextureSupplier.materialGetter(prefix.m_266382_("leggings")), MaterialArmorTextureSupplier.materialGetter(prefix.m_266382_("wings"))};
    }

    protected abstract String getMaterial(ItemStack var1);

    @Override
    public ArmorTextureSupplier.ArmorTexture getArmorTexture(ItemStack stack, ArmorTextureSupplier.TextureType textureType, RegistryAccess access) {
        String material = this.getMaterial(stack);
        if (!material.isEmpty()) {
            return this.textures[textureType.ordinal()].apply(material);
        }
        return ArmorTextureSupplier.ArmorTexture.EMPTY;
    }

    public MaterialArmorTextureSupplier(ResourceLocation prefix, Function<String, ArmorTextureSupplier.ArmorTexture>[] textures) {
        this.prefix = prefix;
        this.textures = textures;
    }

    public static class Material
    extends MaterialArmorTextureSupplier {
        public static final RecordLoadable<Material> LOADER = RecordLoadable.create(PREFIX_FIELD, (RecordField)IntLoadable.FROM_ZERO.requiredField("index", m -> m.index), Material::new);
        private final int index;

        public Material(ResourceLocation prefix, int index) {
            super(prefix);
            this.index = index;
        }

        public Material(ResourceLocation base, String variant, int index) {
            this(base.m_266382_(variant), index);
        }

        @Override
        protected String getMaterial(ItemStack stack) {
            CompoundTag tag = stack.m_41783_();
            if (tag != null && tag.m_128425_("tic_materials", 9)) {
                return tag.m_128437_("tic_materials", 8).m_128778_(this.index);
            }
            return "";
        }

        public RecordLoadable<Material> getLoader() {
            return LOADER;
        }
    }

    public static class PersistentData
    extends MaterialArmorTextureSupplier {
        public static final RecordLoadable<PersistentData> LOADER = RecordLoadable.create(PREFIX_FIELD, (RecordField)Loadables.RESOURCE_LOCATION.requiredField("material_key", d -> d.key), PersistentData::new);
        private final ResourceLocation key;

        public PersistentData(ResourceLocation prefix, ResourceLocation key) {
            super(prefix);
            this.key = key;
        }

        public PersistentData(ResourceLocation base, String suffix, ResourceLocation key) {
            this(base.m_266382_(suffix), key);
        }

        @Override
        protected String getMaterial(ItemStack stack) {
            return ModifierUtil.getPersistentString(stack, this.key);
        }

        public RecordLoadable<PersistentData> getLoader() {
            return LOADER;
        }
    }
}

