/*
 * Decompiled with CFR 0.152.
 */
package com.hidoni.customizableelytra.render;

import com.hidoni.customizableelytra.Constants;
import com.hidoni.customizableelytra.mixin.HttpTextureAccessor;
import com.hidoni.customizableelytra.mixin.HttpTextureInvoker;
import com.hidoni.customizableelytra.render.ImageTextureProvider;
import com.mojang.blaze3d.platform.NativeImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.HttpTexture;
import net.minecraft.client.renderer.texture.SimpleTexture;
import net.minecraft.resources.ResourceLocation;

public class TextureUtils {
    private static final Map<ResourceLocation, ResourceLocation> TEXTURE_CACHE = new HashMap<ResourceLocation, ResourceLocation>();

    private static void convertTextureToGrayscale(NativeImage nativeImage) {
        for (int x = 0; x < nativeImage.m_84982_(); ++x) {
            for (int y = 0; y < nativeImage.m_85084_(); ++y) {
                int pixelRGBA = nativeImage.m_84985_(x, y);
                int originalRGB = pixelRGBA & 0xFFFFFF;
                int grayscale = (((originalRGB & 0xFF0000) >> 16) + ((originalRGB & 0xFF00) >> 8) + (originalRGB & 0xFF)) / 3;
                int newRGB = 65793 * grayscale;
                nativeImage.m_84988_(x, y, pixelRGBA & 0xFF000000 | newRGB);
            }
        }
    }

    private static NativeImage getNativeImageFromTexture(ResourceLocation locationIn) {
        AbstractTexture texture = Minecraft.m_91087_().m_91097_().m_118506_(locationIn);
        if (texture instanceof DynamicTexture) {
            DynamicTexture dynamicTexture = (DynamicTexture)texture;
            NativeImage dynamicTextureData = dynamicTexture.m_117991_();
            if (dynamicTextureData != null) {
                NativeImage returnTexture = new NativeImage(dynamicTextureData.m_84982_(), dynamicTextureData.m_85084_(), false);
                returnTexture.m_85054_(dynamicTextureData);
                return returnTexture;
            }
        } else {
            if (texture instanceof HttpTexture) {
                File cacheFile = ((HttpTextureAccessor)texture).getCacheFile();
                if (cacheFile != null) {
                    try {
                        return ((HttpTextureInvoker)texture).callLoadTexture(new FileInputStream(cacheFile));
                    }
                    catch (FileNotFoundException e) {
                        return null;
                    }
                }
                return null;
            }
            if (texture instanceof SimpleTexture) {
                try {
                    return ((ImageTextureProvider)texture).getImageTexture(Minecraft.m_91087_().m_91098_()).invokeGetImage();
                }
                catch (IOException e) {
                    return null;
                }
            }
        }
        return null;
    }

    private static ResourceLocation createGrayscaleTexture(ResourceLocation locationIn) {
        Constants.LOG.debug("Creating grayscale texture for: " + locationIn);
        NativeImage texture = TextureUtils.getNativeImageFromTexture(locationIn);
        if (texture == null) {
            return locationIn;
        }
        TextureUtils.convertTextureToGrayscale(texture);
        ResourceLocation locationOut = new ResourceLocation("customizableelytra", "grayscale_" + locationIn.m_135815_());
        Minecraft.m_91087_().m_91097_().m_118495_(locationOut, (AbstractTexture)new DynamicTexture(texture));
        return locationOut;
    }

    public static ResourceLocation getGrayscale(ResourceLocation locationIn) {
        return TEXTURE_CACHE.computeIfAbsent(locationIn, TextureUtils::createGrayscaleTexture);
    }
}

