/*
 * Decompiled with CFR 0.152.
 */
package net.myr.createmechanicalcompanion.screen;

import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;
import net.myr.createmechanicalcompanion.entity.CustomWolf;
import net.myr.createmechanicalcompanion.item.ModItems;
import net.myr.createmechanicalcompanion.screen.ModMenuTypes;
import net.myr.createmechanicalcompanion.sounds.ModSounds;
import org.jetbrains.annotations.NotNull;

public class WolfMenu
extends AbstractContainerMenu {
    public final CustomWolf wolf;
    public static final int slotAmount = 5;

    public WolfMenu(int pContainerId, Inventory inv, FriendlyByteBuf extraData) {
        this(pContainerId, inv, WolfMenu.getWolfEntity(extraData, inv.f_35978_.m_9236_()), (ContainerData)new SimpleContainerData(5));
        this.addWolfInventorySlots();
    }

    private static CustomWolf getWolfEntity(FriendlyByteBuf buf, Level level) {
        int entityId = buf.m_130242_();
        Entity entity = level.m_6815_(entityId);
        if (entity instanceof CustomWolf) {
            return (CustomWolf)entity;
        }
        throw new IllegalStateException("Entity with ID " + entityId + " is not a CustomWolfEntity!");
    }

    public WolfMenu(int pContainerId, Inventory playerInventory, CustomWolf wolf, ContainerData data) {
        super((MenuType)ModMenuTypes.WOLF_MENU.get(), pContainerId);
        System.out.println("WolfMenu constructor");
        this.wolf = wolf;
        this.addWolfInventorySlots();
        this.addPlayerInventory(playerInventory);
        this.addPlayerHotbar(playerInventory);
    }

    private void addWolfInventorySlots() {
        this.wolf.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(itemHandler -> System.out.println("ItemHandler capability retrieved successfully."));
        this.wolf.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(itemHandler -> {
            this.m_38897_((Slot)new SlotItemHandler((IItemHandler)itemHandler, 0, 96, 10){

                public boolean m_5857_(@NotNull ItemStack stack) {
                    return stack.m_41720_() == ModItems.REINFORCED_PLATES.get() || stack.m_41720_() == ModItems.NETHERITE_PLATES.get();
                }

                public void m_269060_(ItemStack pStack) {
                    WolfMenu.this.playInsertSound();
                    super.m_269060_(pStack);
                }
            });
            this.m_38897_((Slot)new SlotItemHandler((IItemHandler)itemHandler, 1, 120, 10){

                public boolean m_5857_(@NotNull ItemStack stack) {
                    return stack.m_41720_() == ModItems.MOUNTED_CROSSBOW.get() || stack.m_41720_() == ModItems.SMELTING_FANGS.get() || stack.m_41720_() == ModItems.TESLA_TAIL.get();
                }

                public void m_269060_(ItemStack pStack) {
                    WolfMenu.this.playInsertSound();
                    super.m_269060_(pStack);
                }
            });
            this.m_38897_((Slot)new SlotItemHandler((IItemHandler)itemHandler, 2, 108, 32){

                public boolean m_5857_(@NotNull ItemStack stack) {
                    return stack.m_41720_() == ModItems.BOOSTER_ROCKET.get() || stack.m_41720_() == ModItems.QUANTUM_DRIVE.get();
                }

                public void m_269060_(ItemStack pStack) {
                    WolfMenu.this.playInsertSound();
                    super.m_269060_(pStack);
                }
            });
            this.m_38897_((Slot)new SlotItemHandler((IItemHandler)itemHandler, 3, 96, 54, (IItemHandler)itemHandler){
                final /* synthetic */ IItemHandler val$itemHandler;
                {
                    this.val$itemHandler = iItemHandler;
                    super(itemHandler, index, xPosition, yPosition);
                }

                public boolean m_5857_(ItemStack stack) {
                    if (this.val$itemHandler.getStackInSlot(4).m_41720_() == stack.m_41720_()) {
                        return false;
                    }
                    return stack.m_41720_() == ModItems.REGENERATIVE_CASING.get() || stack.m_41720_() == ModItems.MOB_RADAR.get() || stack.m_41720_() == ModItems.MOUNTED_LIGHT.get();
                }

                public void m_269060_(ItemStack pStack) {
                    WolfMenu.this.playInsertSound();
                    super.m_269060_(pStack);
                }
            });
            this.m_38897_((Slot)new SlotItemHandler((IItemHandler)itemHandler, 4, 120, 54, (IItemHandler)itemHandler){
                final /* synthetic */ IItemHandler val$itemHandler;
                {
                    this.val$itemHandler = iItemHandler;
                    super(itemHandler, index, xPosition, yPosition);
                }

                public boolean m_5857_(@NotNull ItemStack stack) {
                    if (this.val$itemHandler.getStackInSlot(3).m_41720_() == stack.m_41720_()) {
                        return false;
                    }
                    return stack.m_41720_() == ModItems.REGENERATIVE_CASING.get() || stack.m_41720_() == ModItems.MOB_RADAR.get() || stack.m_41720_() == ModItems.MOUNTED_LIGHT.get();
                }

                public void m_269060_(ItemStack pStack) {
                    WolfMenu.this.playInsertSound();
                    super.m_269060_(pStack);
                }
            });
        });
    }

    private void playInsertSound() {
        if (this.wolf.m_9236_().f_46443_) {
            float pitch = 0.95f + this.wolf.m_217043_().m_188501_() * 0.1f;
            Minecraft.m_91087_().f_91073_.m_245747_(this.wolf.m_20183_(), (SoundEvent)ModSounds.EQUIP_MODULE.get(), SoundSource.PLAYERS, 0.8f, pitch, false);
        }
    }

    public ItemStack m_7648_(Player playerIn, int pIndex) {
        ItemStack newStack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(pIndex);
        if (slot != null && slot.m_6657_()) {
            ItemStack originalStack = slot.m_7993_();
            newStack = originalStack.m_41777_();
            if (pIndex < 5 ? !this.m_38903_(originalStack, 5, 41, true) : !this.m_38903_(originalStack, 0, 5, false)) {
                return ItemStack.f_41583_;
            }
            if (originalStack.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
        }
        return newStack;
    }

    private void addPlayerInventory(Inventory playerInventory) {
        for (int i = 0; i < 3; ++i) {
            for (int l = 0; l < 9; ++l) {
                this.m_38897_(new Slot((Container)playerInventory, l + i * 9 + 9, 8 + l * 18, 90 + i * 18));
            }
        }
    }

    private void addPlayerHotbar(Inventory playerInventory) {
        for (int i = 0; i < 9; ++i) {
            this.m_38897_(new Slot((Container)playerInventory, i, 8 + i * 18, 148));
        }
    }

    public boolean m_6875_(Player pPlayer) {
        return this.wolf.m_6084_() && this.wolf.m_20270_((Entity)pPlayer) < 8.0f;
    }
}

