/*
 * Decompiled with CFR 0.152.
 */
package net.myr.createmechanicalcompanion.entity;

import com.simibubi.create.AllItems;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LightBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.registries.ForgeRegistries;
import net.myr.createmechanicalcompanion.CustomLeapAtTargetGoal;
import net.myr.createmechanicalcompanion.ModConfig;
import net.myr.createmechanicalcompanion.StrollUnlessMenuOpenGoal;
import net.myr.createmechanicalcompanion.entity.TargetedArrowEntity;
import net.myr.createmechanicalcompanion.item.ModItems;
import net.myr.createmechanicalcompanion.screen.WolfMenu;
import net.myr.createmechanicalcompanion.sounds.ModSounds;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotResult;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;

public class CustomWolf
extends Wolf
implements MenuProvider {
    private static final int DEFENSIVE_SLOT = 0;
    private static final int ATTACK_SLOT = 1;
    private static final int MOVEMENT_SLOT = 2;
    private static final int UTILITY_SLOT = 3;
    private static final int UTILITY_SLOT2 = 4;
    private static final double movementSpeed = 0.35;
    private static final int reinforcedPlatesArmorValue = 4;
    private static final int netheritePlatesArmorValue = 6;
    private BlockPos previousLightPos = null;
    private float currentTorchTick = 0.0f;
    private float mountedCrossbowTick = 0.0f;
    private float boosterTimer = 0.0f;
    private float boosterAnimationTick = 0.0f;
    private float quantumDriveTimer = 0.0f;
    private float quantumDriveParticleTimer = 0.0f;
    private float mobRadarTimer = 0.0f;
    private final int slotAmount = 5;
    private ItemStackHandler itemHandler = new ItemStackHandler(5);
    private LazyOptional<IItemHandler> lazyItemHandler = LazyOptional.of(() -> this.itemHandler);
    protected final ContainerData data = new ContainerData(){
        private final int[] values = new int[5];

        public int m_6413_(int pIndex) {
            if (pIndex >= 0 && pIndex < this.values.length) {
                return this.values[pIndex];
            }
            throw new IndexOutOfBoundsException("Invalid index for ContainerData: " + pIndex);
        }

        public void m_8050_(int pIndex, int pValue) {
            if (pIndex < 0 || pIndex >= this.values.length) {
                throw new IndexOutOfBoundsException("Invalid index for ContainerData: " + pIndex);
            }
            this.values[pIndex] = pValue;
        }

        public int m_6499_() {
            return this.values.length;
        }
    };
    private static final EntityDataAccessor<CompoundTag> ITEM_HANDLER_DATA = SynchedEntityData.m_135353_(CustomWolf.class, (EntityDataSerializer)EntityDataSerializers.f_135042_);

    public CustomWolf(EntityType<? extends Wolf> entityType, Level level) {
        super(entityType, level);
    }

    public boolean m_7757_(LivingEntity pTarget, LivingEntity pOwner) {
        if (!this.isBlacklisted((Entity)pTarget)) {
            if (pTarget instanceof Wolf) {
                Wolf wolf = (Wolf)pTarget;
                return !wolf.m_21824_() || wolf.m_269323_() != pOwner;
            }
            if (pTarget instanceof Player && pOwner instanceof Player && !((Player)pOwner).m_7099_((Player)pTarget)) {
                return false;
            }
            if (pTarget instanceof AbstractHorse && ((AbstractHorse)pTarget).m_30614_()) {
                return false;
            }
            return !(pTarget instanceof TamableAnimal) || !((TamableAnimal)pTarget).m_21824_();
        }
        return false;
    }

    public static // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull AttributeSupplier.Builder m_30425_() {
        return Wolf.m_30425_().m_22268_(Attributes.f_22276_, 30.0).m_22268_(Attributes.f_22279_, 0.35).m_22268_(Attributes.f_22281_, 6.0).m_22268_(Attributes.f_22277_, 16.0);
    }

    public float m_274421_() {
        return 1.0f;
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.lazyItemHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public void m_20258_(CompoundTag pCompound) {
        super.m_20258_(pCompound);
        if (pCompound.m_128441_("previousLightPosition")) {
            int[] coordinates = pCompound.m_128465_("previousLightPosition");
            this.previousLightPos = new BlockPos(coordinates[0], coordinates[1], coordinates[2]);
        }
        this.itemHandler.deserializeNBT(pCompound.m_128469_("inventory"));
        this.lazyItemHandler = LazyOptional.of(() -> this.itemHandler);
        CustomWolf.removeLightBlocksAround((Entity)this, 3);
    }

    public boolean isBlacklisted(Entity entity) {
        ResourceLocation id = ForgeRegistries.ENTITY_TYPES.getKey((Object)entity.m_6095_());
        if (id == null) {
            return false;
        }
        return ((List)ModConfig.COMMON.wolfBlacklist.get()).contains(id.toString());
    }

    public void m_7380_(CompoundTag pCompound) {
        pCompound.m_128365_("inventory", (Tag)this.itemHandler.serializeNBT());
        if (this.previousLightPos != null) {
            int[] previousLightPositionCoordinates = new int[]{this.previousLightPos.m_123341_(), this.previousLightPos.m_123342_(), this.previousLightPos.m_123343_()};
            if (pCompound.m_128441_("previousLightPosition")) {
                pCompound.m_128385_("previousLightPosition", previousLightPositionCoordinates);
            }
        }
        super.m_7380_(pCompound);
    }

    public ItemStackHandler getItemHandler() {
        return this.itemHandler;
    }

    public void setItemHandler(ItemStackHandler handler) {
        if (handler != null) {
            this.itemHandler = handler;
            this.lazyItemHandler = LazyOptional.of(() -> this.itemHandler);
            this.syncItemHandler();
        }
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.lazyItemHandler.invalidate();
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int pContainerId, Inventory pPlayerInventory, Player pPlayer) {
        return new WolfMenu(pContainerId, pPlayerInventory, this, this.data);
    }

    @NotNull
    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        if (!this.m_9236_().f_46443_ && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (player.m_21120_(hand).m_41720_() == AllItems.WRENCH.get()) {
                this.m_5634_(5.0f);
                this.m_9236_().m_245803_((Entity)this, this.m_20183_(), SoundEvents.f_12009_, SoundSource.NEUTRAL, 1.0f, 1.0f);
                return InteractionResult.SUCCESS;
            }
            if (this.m_269323_() != null && player.m_20148_().equals(this.m_269323_().m_20148_())) {
                NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)this, buf -> buf.m_130130_(this.m_19879_()));
            } else {
                serverPlayer.m_5661_((Component)Component.m_237115_((String)"entity.createmechanicalcompanion.ownership_warning"), true);
            }
        }
        return InteractionResult.SUCCESS;
    }

    public boolean isModuleEquipped(Item item) {
        return this.itemHandler.getStackInSlot(0).m_41720_() == item || this.itemHandler.getStackInSlot(2).m_41720_() == item || this.itemHandler.getStackInSlot(3).m_41720_() == item || this.itemHandler.getStackInSlot(1).m_41720_() == item || this.itemHandler.getStackInSlot(4).m_41720_() == item;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(4, (Goal)new CustomLeapAtTargetGoal((Mob)this, 0.3f));
        this.f_21345_.m_25352_(5, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.f_21345_.m_25352_(6, (Goal)new FollowOwnerGoal((TamableAnimal)this, 1.0, 10.0f, 2.0f, false));
        this.f_21345_.m_25352_(8, (Goal)new StrollUnlessMenuOpenGoal((PathfinderMob)this, 0.6));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(10, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(2, (Goal)new OwnerHurtTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, true, arg_0 -> ((CustomWolf)this).m_21674_(arg_0)));
        this.f_21346_.m_25352_(8, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, true));
    }

    public void m_8119_() {
        super.m_8119_();
        double boosterSpeedIncrease = 0.3;
        if (!this.m_9236_().f_46443_) {
            float quantumDriveCooldown;
            if (this.m_269323_() == null) {
                this.m_146870_();
            }
            this.checkForDuplicate();
            double defaultHealthValue = 30.0;
            if (this.isModuleEquipped((Item)ModItems.NETHERITE_PLATES.get())) {
                double netheritePlatesHealthIncrease = 10.0;
                if (this.m_21051_(Attributes.f_22276_).m_22115_() != defaultHealthValue + netheritePlatesHealthIncrease) {
                    this.m_21051_(Attributes.f_22276_).m_22100_(defaultHealthValue + netheritePlatesHealthIncrease);
                }
            } else if (this.m_21051_(Attributes.f_22276_).m_22115_() != defaultHealthValue) {
                this.m_21051_(Attributes.f_22276_).m_22100_(defaultHealthValue);
                if (this.m_21223_() > this.m_21233_()) {
                    this.m_21153_(this.m_21233_());
                }
            }
            if (this.isModuleEquipped((Item)ModItems.REGENERATIVE_CASING.get()) && this.m_21223_() < this.m_21233_()) {
                this.m_5634_(0.05f);
            }
            if (this.isModuleEquipped((Item)ModItems.MOUNTED_LIGHT.get())) {
                BlockPos torchPosition = new BlockPos(this.m_146903_(), this.m_146904_() + 1, this.m_146907_());
                Block currentBlock = this.m_9236_().m_8055_(torchPosition).m_60734_();
                if (torchPosition != this.previousLightPos) {
                    this.removePreviousLightBlock();
                    if (this.m_9236_().m_8055_(torchPosition).m_60795_() && this.m_6084_()) {
                        this.m_9236_().m_46597_(torchPosition, (BlockState)Blocks.f_152480_.m_49966_().m_61124_((Property)LightBlock.f_153657_, (Comparable)Integer.valueOf(15)));
                        this.previousLightPos = torchPosition;
                    }
                }
            } else {
                this.removePreviousLightBlock();
            }
            float mountedCrossbowCooldown = 60.0f;
            if (this.isModuleEquipped((Item)ModItems.MOUNTED_CROSSBOW.get()) && this.m_5448_() != null && this.mountedCrossbowTick >= mountedCrossbowCooldown) {
                this.mountedCrossbowTick = 0.0f;
                TargetedArrowEntity arrow = new TargetedArrowEntity(this.m_9236_(), (LivingEntity)this, this.m_5448_());
                arrow.m_36781_(4.0);
                arrow.m_36735_(1);
                Vec3 direction = this.m_5448_().m_146892_().m_82546_(this.m_146892_());
                direction = direction.m_82541_();
                arrow.m_6034_(this.m_20185_(), this.m_20188_() + 0.5, this.m_20189_());
                arrow.m_6686_(direction.f_82479_, direction.f_82480_, direction.f_82481_, 1.6f, 0.0f);
                float pitch = 0.8f + this.f_19796_.m_188501_() * 0.4f;
                this.m_9236_().m_245803_((Entity)this, this.m_20183_(), (SoundEvent)ModSounds.MOUNTED_CROSSBOW_SOUND.get(), SoundSource.HOSTILE, 0.15f, pitch);
                this.m_9236_().m_7967_((Entity)arrow);
            } else if (this.mountedCrossbowTick < mountedCrossbowCooldown) {
                this.mountedCrossbowTick += 1.0f;
            }
            AttributeInstance movementAttribute = this.m_21051_(Attributes.f_22279_);
            float boosterCooldown = 180.0f;
            if (this.isModuleEquipped((Item)ModItems.BOOSTER_ROCKET.get()) && this.m_5448_() != null && this.boosterTimer >= boosterCooldown) {
                if (movementAttribute.m_22115_() == 0.35) {
                    movementAttribute.m_22100_(0.35 + boosterSpeedIncrease);
                    this.boosterTimer = 0.0f;
                }
            } else {
                float boosterDuration = 40.0f;
                if (this.boosterTimer >= boosterDuration && movementAttribute.m_22115_() != 0.35) {
                    movementAttribute.m_22100_(0.35);
                }
            }
            if (this.boosterTimer < boosterCooldown) {
                this.boosterTimer += 1.0f;
            }
            if (this.quantumDriveTimer >= (quantumDriveCooldown = 40.0f) && this.m_5448_() != null && this.isModuleEquipped((Item)ModItems.QUANTUM_DRIVE.get())) {
                LivingEntity target = this.m_5448_();
                Vec3 targetPosition = target.m_20182_();
                int teleportX = (int)(targetPosition.f_82479_ + (this.f_19796_.m_188500_() - 0.5) * 2.0);
                int teleportY = (int)targetPosition.f_82480_;
                int teleportZ = (int)(targetPosition.f_82481_ + (this.f_19796_.m_188500_() - 0.5) * 2.0);
                if (this.m_9236_().m_46859_(new BlockPos(teleportX, teleportY, teleportZ))) {
                    this.m_6021_(teleportX, teleportY, teleportZ);
                    this.m_9236_().m_5594_(null, this.m_20183_(), SoundEvents.f_11852_, SoundSource.HOSTILE, 1.0f, 1.0f);
                }
                this.quantumDriveTimer = 0.0f;
            } else if (this.quantumDriveTimer < quantumDriveCooldown) {
                this.quantumDriveTimer += 1.0f;
            }
            float mobRadarCooldown = 200.0f;
            if (this.mobRadarTimer >= mobRadarCooldown && this.isModuleEquipped((Item)ModItems.MOB_RADAR.get())) {
                this.applyGlowingToHostileMobs();
                this.mobRadarTimer = 0.0f;
            } else if (this.mobRadarTimer < mobRadarCooldown) {
                this.mobRadarTimer += 1.0f;
            }
            this.syncItemHandler();
        } else {
            if (this.isModuleEquipped((Item)ModItems.MOUNTED_LIGHT.get())) {
                this.spawnMountedTorchParticles();
            }
            if (this.m_21051_(Attributes.f_22279_).m_22115_() == 0.35 + boosterSpeedIncrease) {
                this.spawnRocketBoostParticles();
            }
            float quantumDriveParticleCooldown = 30.0f;
            if (this.isModuleEquipped((Item)ModItems.QUANTUM_DRIVE.get()) && this.quantumDriveParticleTimer >= quantumDriveParticleCooldown) {
                this.spawnQuantumDriveParticles();
                this.quantumDriveParticleTimer = 0.0f;
            } else {
                this.quantumDriveParticleTimer += 1.0f;
            }
        }
    }

    private void applyGlowingToHostileMobs() {
        float radarRadius = 20.0f;
        List nearbyEntities = this.m_9236_().m_6249_((Entity)this, this.m_20191_().m_82400_((double)radarRadius), entity -> {
            Mob mob;
            return entity instanceof Mob && (mob = (Mob)entity).m_6095_().m_20674_() == MobCategory.MONSTER;
        });
        for (Entity entity2 : nearbyEntities) {
            if (!(entity2 instanceof LivingEntity)) continue;
            LivingEntity livingEntity = (LivingEntity)entity2;
            int mobRadarPingDuration = 60;
            livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19619_, mobRadarPingDuration, 0, false, false));
        }
    }

    public boolean m_6072_() {
        return false;
    }

    private void checkForDuplicate() {
        LivingEntity livingEntity = this.m_269323_();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            ICuriosItemHandler curiosInventory = (ICuriosItemHandler)CuriosApi.getCuriosInventory((LivingEntity)player).orElse(null);
            if (curiosInventory == null) {
                this.m_146870_();
                return;
            }
            Optional item = curiosInventory.findCurio("head", 0);
            if (item.isEmpty()) {
                this.m_146870_();
                return;
            }
            CompoundTag compoundTag = ((SlotResult)item.get()).stack().m_41783_();
            if (compoundTag != null && compoundTag.m_128441_("WolfUUID") && !this.m_20148_().equals(compoundTag.m_128342_("WolfUUID"))) {
                this.m_146870_();
            }
        }
    }

    private void spawnQuantumDriveParticles() {
        double offsetX = (this.f_19796_.m_188500_() - 0.5) * 0.6;
        double offsetY = this.f_19796_.m_188500_() * 0.4 + 0.8;
        double offsetZ = (this.f_19796_.m_188500_() - 0.5) * 0.6;
        double x = this.m_20185_() + offsetX;
        double y = this.m_20186_() + offsetY;
        double z = this.m_20189_() + offsetZ;
        this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123789_, x, y, z, 0.0, 0.01, 0.0);
    }

    private void removePreviousLightBlock() {
        if (this.previousLightPos == null) {
            return;
        }
        this.m_9236_().m_7731_(this.previousLightPos, Blocks.f_50016_.m_49966_(), 3);
        this.previousLightPos = null;
    }

    public static void removeLightBlocksAround(Entity entity, int radius) {
        Level level = entity.m_9236_();
        BlockPos center = entity.m_20183_();
        for (int dx = -radius; dx <= radius; ++dx) {
            for (int dy = -radius; dy <= radius; ++dy) {
                for (int dz = -radius; dz <= radius; ++dz) {
                    BlockPos pos = center.m_7918_(dx, dy, dz);
                    BlockState state = level.m_8055_(pos);
                    if (!state.m_60713_(Blocks.f_152480_)) continue;
                    level.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
                }
            }
        }
    }

    private void spawnRocketBoostParticles() {
        float boosterAnimationCooldown = 3.0f;
        if (this.boosterAnimationTick >= boosterAnimationCooldown) {
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123762_, this.m_20208_(0.5), this.m_20187_(), this.m_20262_(0.5), 0.0, 0.05, 0.0);
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123762_, this.m_20208_(0.5), this.m_20187_(), this.m_20262_(0.5), 0.0, 0.05, 0.0);
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123744_, this.m_20208_(0.5), this.m_20187_(), this.m_20262_(0.5), 0.0, 0.05, 0.0);
        } else {
            this.boosterAnimationTick += 1.0f;
        }
    }

    private void spawnMountedTorchParticles() {
        float mountedTorchParticleDelayInTicks = 30.0f;
        if (this.currentTorchTick >= mountedTorchParticleDelayInTicks && this.m_9236_().f_46443_) {
            double offsetX = (this.f_19796_.m_188500_() - 0.5) * 0.6;
            double offsetY = this.f_19796_.m_188500_() * 0.4 + 1.0;
            double offsetZ = (this.f_19796_.m_188500_() - 0.5) * 0.6;
            double x = this.m_20185_() + offsetX;
            double y = this.m_20186_() + offsetY;
            double z = this.m_20189_() + offsetZ;
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123762_, x, y, z, 0.0, 0.05, 0.0);
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123744_, x, y, z, 0.0, 0.05, 0.0);
            this.currentTorchTick = 0.0f;
        } else if (this.currentTorchTick < mountedTorchParticleDelayInTicks) {
            this.currentTorchTick += 1.0f;
        }
    }

    public boolean m_7327_(Entity pEntity) {
        if (this.isModuleEquipped((Item)ModItems.SMELTING_FANGS.get())) {
            pEntity.m_20254_(5);
        }
        float pitch = 0.8f + this.f_19796_.m_188501_() * 0.4f;
        this.m_9236_().m_245803_((Entity)this, this.m_20183_(), (SoundEvent)ModSounds.BITE_SOUND.get(), SoundSource.NEUTRAL, 0.6f, pitch);
        return pEntity.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), (float)((int)this.m_21133_(Attributes.f_22281_)));
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        if (this.isModuleEquipped((Item)ModItems.TESLA_TAIL.get())) {
            if (pSource.m_7639_() != null) {
                pSource.m_7639_().m_6469_(pSource.m_7639_().m_269291_().m_269333_((LivingEntity)this), 1.0f);
                pSource.m_7639_().f_19802_ = 0;
            }
            this.spawnTeslaTailParticles();
        }
        return super.m_6469_(pSource, pAmount);
    }

    private void spawnTeslaTailParticles() {
        if (!this.m_9236_().f_46443_) {
            return;
        }
        for (int i = 0; i < 10; ++i) {
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_175830_, this.m_20208_(1.5), this.m_20187_(), this.m_20262_(1.5), 0.0, 0.2, 0.0);
        }
    }

    public boolean m_5825_() {
        return this.isModuleEquipped((Item)ModItems.NETHERITE_PLATES.get()) || this.isModuleEquipped((Item)ModItems.SMELTING_FANGS.get());
    }

    public int m_21230_() {
        if (this.isModuleEquipped((Item)ModItems.REINFORCED_PLATES.get())) {
            return 4;
        }
        if (this.isModuleEquipped((Item)ModItems.NETHERITE_PLATES.get())) {
            return 6;
        }
        return super.m_21230_();
    }

    @NotNull
    public Component m_5446_() {
        return super.m_5446_();
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ITEM_HANDLER_DATA, (Object)new CompoundTag());
    }

    private void syncItemHandler() {
        if (!this.m_9236_().f_46443_) {
            CompoundTag tag = this.itemHandler.serializeNBT();
            this.f_19804_.m_135381_(ITEM_HANDLER_DATA, (Object)tag);
        }
    }

    public void m_7350_(EntityDataAccessor<?> key) {
        super.m_7350_(key);
        if (key.equals(ITEM_HANDLER_DATA)) {
            CompoundTag tag = (CompoundTag)this.f_19804_.m_135370_(ITEM_HANDLER_DATA);
            this.itemHandler.deserializeNBT(tag);
        }
    }

    protected SoundEvent m_7515_() {
        return null;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12058_;
    }

    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return SoundEvents.f_12058_;
    }

    public void m_6667_(DamageSource pCause) {
        CustomWolf.removeLightBlocksAround((Entity)this, 5);
    }
}

