/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.shapes.slopepanelcorner;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.shapes.ShapeCache;
import xfacthd.framedblocks.api.shapes.ShapeProvider;
import xfacthd.framedblocks.api.shapes.ShapeUtils;
import xfacthd.framedblocks.common.data.property.HorizontalRotation;
import xfacthd.framedblocks.common.data.shapes.SplitShapeGenerator;
import xfacthd.framedblocks.common.data.shapes.slopepanel.ExtendedSlopePanelShapes;

public final class ExtendedCornerSlopePanelShapes
implements SplitShapeGenerator {
    public static final ExtendedCornerSlopePanelShapes OUTER = new ExtendedCornerSlopePanelShapes(BooleanOp.f_82689_, Direction.NORTH);
    public static final ExtendedCornerSlopePanelShapes INNER = new ExtendedCornerSlopePanelShapes(BooleanOp.f_82695_, Direction.SOUTH);
    private final BooleanOp joinOp;
    private final Direction srcDir;

    private ExtendedCornerSlopePanelShapes(BooleanOp joinOp, Direction srcDir) {
        this.joinOp = joinOp;
        this.srcDir = srcDir;
    }

    @Override
    public ShapeProvider generate(ImmutableList<BlockState> states) {
        return this.generate(states, ExtendedSlopePanelShapes.SHAPES);
    }

    @Override
    public ShapeProvider generateOcclusionShapes(ImmutableList<BlockState> states) {
        return this.generate(states, ExtendedSlopePanelShapes.OCCLUSION_SHAPES);
    }

    private ShapeProvider generate(ImmutableList<BlockState> states, ShapeCache<HorizontalRotation> cache) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        VoxelShape bottomSlopeShape = cache.get(HorizontalRotation.UP);
        VoxelShape bottomShape = Shapes.m_83148_((VoxelShape)bottomSlopeShape, (VoxelShape)ShapeUtils.rotateShapeUnoptimized(Direction.NORTH, Direction.WEST, bottomSlopeShape), (BooleanOp)this.joinOp);
        VoxelShape topSlopeShape = cache.get(HorizontalRotation.DOWN);
        VoxelShape topShape = Shapes.m_83148_((VoxelShape)topSlopeShape, (VoxelShape)ShapeUtils.rotateShapeUnoptimized(Direction.NORTH, Direction.WEST, topSlopeShape), (BooleanOp)this.joinOp);
        VoxelShape[] shapes = ShapeUtils.makeHorizontalRotationsWithFlag(bottomShape, topShape, this.srcDir);
        for (BlockState state : states) {
            Direction dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
            boolean top = (Boolean)state.m_61143_((Property)FramedProperties.TOP);
            builder.put((Object)state, (Object)shapes[dir.m_122416_() + (top ? 4 : 0)]);
        }
        return ShapeProvider.of((Map<BlockState, VoxelShape>)builder.build());
    }
}

