/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block.slab;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.block.PlacementStateBuilder;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.block.AbstractFramedDoubleBlock;
import xfacthd.framedblocks.common.blockentity.doubled.FramedMasonryCornerBlockEntity;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.doubleblock.CamoGetter;
import xfacthd.framedblocks.common.data.doubleblock.SolidityCheck;
import xfacthd.framedblocks.common.util.DoubleBlockTopInteractionMode;

public class FramedMasonryCornerBlock
extends AbstractFramedDoubleBlock {
    public FramedMasonryCornerBlock() {
        super(BlockType.FRAMED_MASONRY_CORNER);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)FramedProperties.TOP, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{FramedProperties.FACING_HOR, FramedProperties.TOP});
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        return ((PlacementStateBuilder)((PlacementStateBuilder)PlacementStateBuilder.of(this, ctx).withHorizontalFacing()).withTop()).build();
    }

    @Override
    public BlockState rotate(BlockState state, Direction face, Rotation rot) {
        if (!Utils.isY(face) && rot != Rotation.NONE) {
            return (BlockState)state.m_61122_((Property)FramedProperties.TOP);
        }
        return super.rotate(state, face, rot);
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        Direction dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
        return (BlockState)state.m_61124_((Property)FramedProperties.FACING_HOR, (Comparable)rot.m_55954_(dir));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return Utils.mirrorCornerBlock(state, mirror);
    }

    @Override
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new FramedMasonryCornerBlockEntity(pos, state);
    }

    @Override
    public DoubleBlockTopInteractionMode calculateTopInteractionMode(BlockState state) {
        return DoubleBlockTopInteractionMode.EITHER;
    }

    @Override
    public Tuple<BlockState, BlockState> calculateBlockPair(BlockState state) {
        Direction dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
        BlockState edgeState = (BlockState)((Block)FBContent.BLOCK_FRAMED_MASONRY_CORNER_SEGMENT.get()).m_49966_().m_61124_((Property)FramedProperties.TOP, (Comparable)((Boolean)state.m_61143_((Property)FramedProperties.TOP)));
        return new Tuple((Object)((BlockState)edgeState.m_61124_((Property)FramedProperties.FACING_HOR, (Comparable)dir)), (Object)((BlockState)edgeState.m_61124_((Property)FramedProperties.FACING_HOR, (Comparable)dir.m_122424_())));
    }

    @Override
    public SolidityCheck calculateSolidityCheck(BlockState state, Direction side) {
        return SolidityCheck.BOTH;
    }

    @Override
    public CamoGetter calculateCamoGetter(BlockState state, Direction side, @Nullable Direction edge) {
        Direction bottom;
        Direction dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean top = (Boolean)state.m_61143_((Property)FramedProperties.TOP);
        Direction direction = bottom = top ? Direction.UP : Direction.DOWN;
        if (side == bottom) {
            if (edge == dir) {
                return CamoGetter.SECOND;
            }
            if (edge == dir.m_122424_()) {
                return CamoGetter.FIRST;
            }
        } else if (side == bottom.m_122424_()) {
            if (edge == dir.m_122427_()) {
                return CamoGetter.FIRST;
            }
            if (edge == dir.m_122428_()) {
                return CamoGetter.SECOND;
            }
        } else if (side.m_122434_() == dir.m_122434_()) {
            if (edge == bottom || edge == side.m_122428_()) {
                return side == dir ? CamoGetter.SECOND : CamoGetter.FIRST;
            }
        } else if (side.m_122434_() == dir.m_122427_().m_122434_() && (edge == bottom.m_122424_() || edge == side.m_122427_())) {
            return side == dir.m_122427_() ? CamoGetter.FIRST : CamoGetter.SECOND;
        }
        return CamoGetter.NONE;
    }

    public static BlockState itemModelSource() {
        return ((Block)FBContent.BLOCK_FRAMED_MASONRY_CORNER.get()).m_49966_();
    }
}

