/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets2.client.particles.itemparticle;

import com.direwolf20.buildinggadgets2.client.particles.ModParticles;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Locale;
import javax.annotation.Nonnull;
import net.minecraft.commands.arguments.item.ItemInput;
import net.minecraft.commands.arguments.item.ItemParser;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ItemFlowParticleData
implements ParticleOptions {
    private final ItemStack itemStack;
    public final boolean doGravity;
    public final boolean shrinking;
    public static final ParticleOptions.Deserializer<ItemFlowParticleData> DESERIALIZER = new ParticleOptions.Deserializer<ItemFlowParticleData>(){

        @Nonnull
        public ItemFlowParticleData fromCommand(ParticleType<ItemFlowParticleData> particleTypeIn, StringReader reader) throws CommandSyntaxException {
            reader.expect(' ');
            ItemParser.ItemResult itemparser$itemresult = ItemParser.m_235305_((HolderLookup)BuiltInRegistries.f_257033_.m_255303_(), (StringReader)reader);
            ItemStack itemstack = new ItemInput(itemparser$itemresult.f_235328_(), itemparser$itemresult.f_235329_()).m_120980_(1, false);
            reader.expect(' ');
            boolean doGravity = reader.readBoolean();
            reader.expect(' ');
            boolean building = reader.readBoolean();
            return new ItemFlowParticleData(itemstack, doGravity, building);
        }

        public ItemFlowParticleData fromNetwork(ParticleType<ItemFlowParticleData> particleTypeIn, FriendlyByteBuf buffer) {
            return new ItemFlowParticleData(buffer.m_130267_(), buffer.readBoolean(), buffer.readBoolean());
        }
    };

    public ItemFlowParticleData(ItemStack itemStack, boolean doGravity, boolean shrinking) {
        this.itemStack = itemStack.m_41777_();
        this.doGravity = doGravity;
        this.shrinking = shrinking;
    }

    @Nonnull
    public ParticleType<ItemFlowParticleData> m_6012_() {
        return (ParticleType)ModParticles.ITEMFLOWPARTICLE.get();
    }

    public void m_7711_(FriendlyByteBuf buffer) {
        buffer.writeItemStack(this.itemStack, false);
    }

    @Nonnull
    public String m_5942_() {
        return String.format(Locale.ROOT, "%s %b %b", this.m_6012_(), this.doGravity, this.shrinking);
    }

    @OnlyIn(value=Dist.CLIENT)
    public ItemStack getItemStack() {
        return this.itemStack;
    }
}

