/*
 * Decompiled with CFR 0.152.
 */
package forge.com.cursee.more_bows_and_arrows.core.registry;

import forge.com.cursee.more_bows_and_arrows.Constants;
import forge.com.cursee.more_bows_and_arrows.MoreBowsAndArrows;
import forge.com.cursee.more_bows_and_arrows.core.ModConfig;
import forge.com.cursee.more_bows_and_arrows.core.world.entity.projectile.util.ArrowType;
import forge.com.cursee.more_bows_and_arrows.core.world.item.ModArrowItem;
import forge.com.cursee.more_bows_and_arrows.core.world.item.ModBowItem;
import forge.com.cursee.more_bows_and_arrows.core.world.item.util.BowType;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.function.BiConsumer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;

public class ModItems {
    public static final LinkedHashMap<ArrowType, Item> ARROW_ITEM_FROM_TYPE_MAP = new LinkedHashMap();
    public static final LinkedHashMap<BowType, Item> BOW_ITEM_FROM_TYPE_MAP = new LinkedHashMap();
    public static final LinkedList<Item> ITEMS_FOR_TAB = new LinkedList();

    public static void register(BiConsumer<Item, ResourceLocation> consumer) {
        if (!ModConfig.BANNED_BOWS.isEmpty()) {
            Constants.LOG.info("Some bows were banned: ");
            ModConfig.BANNED_BOWS.forEach(System.out::println);
        }
        for (BowType bowType : BowType.values()) {
            ModBowItem bow = new ModBowItem(bowType, new Item.Properties());
            if (bowType != BowType.NORMAL) {
                ITEMS_FOR_TAB.add((Item)bow);
            }
            BOW_ITEM_FROM_TYPE_MAP.put(bowType, (Item)bow);
            consumer.accept((Item)bow, MoreBowsAndArrows.identifier(bowType.name().toLowerCase() + "_bow"));
        }
        if (ModConfig.BANNED_ARROWS != null && !ModConfig.BANNED_ARROWS.isEmpty()) {
            Constants.LOG.info("Some arrows were banned: ");
            ModConfig.BANNED_ARROWS.forEach(System.out::println);
        }
        for (Enum enum_ : ArrowType.values()) {
            ModArrowItem arrow = new ModArrowItem((ArrowType)enum_, new Item.Properties());
            if (enum_ != ArrowType.NORMAL) {
                ITEMS_FOR_TAB.add((Item)arrow);
            }
            ARROW_ITEM_FROM_TYPE_MAP.put((ArrowType)enum_, (Item)arrow);
            consumer.accept((Item)arrow, MoreBowsAndArrows.identifier(enum_.name().toLowerCase() + "_arrow"));
        }
    }
}

