/*
 * Decompiled with CFR 0.152.
 */
package fabric.com.cursee.more_bows_and_arrows.core.world.entity.projectile.util;

import fabric.com.cursee.more_bows_and_arrows.core.world.entity.projectile.ModArrow;
import fabric.com.cursee.more_bows_and_arrows.core.world.entity.projectile.util.ArrowType;
import fabric.com.cursee.more_bows_and_arrows.core.world.item.ModBowItem;
import fabric.com.cursee.more_bows_and_arrows.core.world.item.util.BowType;
import java.util.Random;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1428;
import net.minecraft.class_1538;
import net.minecraft.class_1642;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2709;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3031;
import net.minecraft.class_3218;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_4538;
import net.minecraft.class_4770;

@FunctionalInterface
public interface IModArrow {
    public ArrowType getArrowType();

    default public void processBlockInteraction(ModArrow arrow, class_3965 result) {
        class_1297 owner = arrow.method_24921();
        class_1937 level = arrow.method_37908();
        class_2338 pos = result.method_17777();
        class_2680 state = arrow.method_37908().method_8320(pos);
        class_1799 stack = owner instanceof class_1309 ? ((class_1309)owner).method_6047() : class_1799.field_8037;
        ModBowItem bow = stack.method_7909() instanceof ModBowItem ? (ModBowItem)stack.method_7909() : null;
        switch (this.getArrowType()) {
            case BAMBOO: {
                if (bow == null || bow.getBowType() != BowType.BAMBOO) break;
                IModArrow.bambooArrowHitsBlock(level, pos, state);
                break;
            }
            case BLAZE_ROD: {
                IModArrow.igniteBlockOnHit(result, level, pos, state);
                break;
            }
            case COPPER: {
                class_1538 lightningBolt;
                if (level.field_9229.method_43057() < 0.01f && level.method_8520(pos)) {
                    lightningBolt = (class_1538)class_1299.field_6112.method_5883(level);
                    lightningBolt.method_29495(class_243.method_24955((class_2382)pos.method_10084()));
                    lightningBolt.method_6961(null);
                    level.method_8649((class_1297)lightningBolt);
                }
                if (bow == null || bow.getBowType() != BowType.COPPER) break;
                lightningBolt = (class_1538)class_1299.field_6112.method_5883(level);
                lightningBolt.method_29495(class_243.method_24955((class_2382)pos.method_10084()));
                lightningBolt.method_6961(null);
                level.method_8649((class_1297)lightningBolt);
                break;
            }
            case ENDER_PEARL: {
                class_2338 relativePosition = pos.method_10093(result.method_17780());
                if (owner == null || arrow.method_37908().method_8608()) break;
                owner.method_48105((class_3218)arrow.method_37908(), (double)relativePosition.method_10263(), (double)relativePosition.method_10264(), (double)relativePosition.method_10260(), class_2709.field_40711, owner.method_36454(), owner.method_36455());
                break;
            }
            case FLINT_AND_STEEL: {
                IModArrow.igniteBlockOnHit(result, level, pos, state);
                break;
            }
            case FLINT: {
                if (bow == null || bow.getBowType() != BowType.IRON) break;
                IModArrow.igniteBlockOnHit(result, level, pos, state);
                break;
            }
            case MOSS: {
                if (bow == null || bow.getBowType() != BowType.MOSS && bow.getBowType() != BowType.PAPER) break;
                IModArrow.paperArrowHitsBlock(owner, level, pos);
                break;
            }
            case PAPER: {
                if (bow == null || bow.getBowType() != BowType.PAPER && bow.getBowType() != BowType.MOSS) break;
                IModArrow.paperArrowHitsBlock(owner, level, pos);
                break;
            }
            case TNT: {
                arrow.method_31472();
                level.method_8537(owner, (double)result.method_17777().method_10263(), (double)(result.method_17777().method_10264() + 1), (double)result.method_17777().method_10260(), 2.0f, true, class_1937.class_7867.field_40891);
            }
        }
    }

    default public void processEntityInteraction(ModArrow arrow, class_3966 result) {
        class_1657 player;
        ModBowItem bow;
        class_1297 owner = arrow.method_24921();
        class_1937 level = arrow.method_37908();
        class_1297 class_12972 = result.method_17782();
        if (!(class_12972 instanceof class_1309)) {
            return;
        }
        class_1309 hitEntity = (class_1309)class_12972;
        class_1799 stack = owner instanceof class_1309 ? ((class_1309)owner).method_6047() : class_1799.field_8037;
        ModBowItem modBowItem = bow = stack.method_7909() instanceof ModBowItem ? (ModBowItem)stack.method_7909() : null;
        if (owner instanceof class_1657 && (player = (class_1657)owner).method_37908() != null) {
            hitEntity.field_6008 = 0;
            hitEntity.method_5684(false);
            hitEntity.field_6254 = 0;
            hitEntity.field_6235 = 0;
            hitEntity.field_6037 = false;
            player.method_6114(null);
            hitEntity.method_6015(null);
            hitEntity.method_29505(null);
            hitEntity.method_5643(owner.method_37908().method_48963().method_48830(), this.getArrowType().getAttackDamageBonus());
        } else if (hitEntity instanceof class_1657) {
            class_1657 player2 = (class_1657)hitEntity;
            if (owner == null) {
                player2.field_6008 = 0;
                player2.method_5684(false);
                player2.field_6254 = 0;
                player2.field_6235 = 0;
                player2.field_6037 = false;
                player2.method_6114(null);
                player2.method_6015(null);
                player2.method_29505(null);
                player2.method_5643(player2.method_37908().method_48963().method_48830(), this.getArrowType().getAttackDamageBonus());
            }
        }
        switch (this.getArrowType()) {
            case BLAZE_ROD: {
                hitEntity.method_5639(2);
                break;
            }
            case BONE: {
                hitEntity.method_6092(new class_1293(class_1294.field_5920, 20, 1));
                break;
            }
            case COPPER: {
                class_1538 lightningBolt;
                if (level.field_9229.method_43057() < 0.01f && level.method_8520(hitEntity.method_24515().method_10084())) {
                    lightningBolt = (class_1538)class_1299.field_6112.method_5883(level);
                    lightningBolt.method_29495(class_243.method_24955((class_2382)hitEntity.method_24515().method_10084()));
                    lightningBolt.method_6961(null);
                    level.method_8649((class_1297)lightningBolt);
                }
                if (bow == null || bow.getBowType() != BowType.COPPER) break;
                lightningBolt = (class_1538)class_1299.field_6112.method_5883(level);
                lightningBolt.method_29495(class_243.method_24955((class_2382)hitEntity.method_24515().method_10084()));
                lightningBolt.method_6961(null);
                level.method_8649((class_1297)lightningBolt);
                break;
            }
            case ENDER_PEARL: {
                if (owner == null || arrow.method_37908().method_8608()) break;
                hitEntity.method_48105((class_3218)owner.method_37908(), owner.field_6014, owner.field_6036, owner.field_5969, class_2709.field_40711, hitEntity.method_36454(), hitEntity.method_36455());
                break;
            }
            case FLINT_AND_STEEL: {
                hitEntity.method_5639(2);
                break;
            }
            case FLINT: {
                if (bow == null || bow.getBowType() != BowType.IRON) break;
                hitEntity.method_5639(2);
                break;
            }
            case MOSS: {
                if (bow == null || bow.getBowType() != BowType.MOSS && bow.getBowType() != BowType.PAPER) break;
                IModArrow.paperArrowHitsEntity(owner, level, (class_1297)hitEntity);
                break;
            }
            case PAPER: {
                if (bow == null || bow.getBowType() != BowType.PAPER && bow.getBowType() != BowType.MOSS) break;
                IModArrow.paperArrowHitsEntity(owner, level, (class_1297)hitEntity);
                break;
            }
            case TNT: {
                level.method_8537(null, hitEntity.field_6014, hitEntity.field_6036 + 1.0, hitEntity.field_5969, 2.0f, true, class_1937.class_7867.field_40891);
                arrow.method_31472();
            }
        }
    }

    private static void igniteBlockOnHit(class_3965 result, class_1937 level, class_2338 pos, class_2680 state) {
        if (!state.method_28498((class_2769)class_2741.field_12548)) {
            class_2338 relativePosition = pos.method_10093(result.method_17780());
            if (level.method_22347(relativePosition)) {
                level.method_8501(relativePosition, class_4770.method_24416((class_1922)level, (class_2338)relativePosition));
            }
        } else {
            level.method_8652(pos, (class_2680)state.method_11657((class_2769)class_2741.field_12548, (Comparable)Boolean.valueOf(true)), 3);
        }
    }

    private static void bambooArrowHitsBlock(class_1937 level, class_2338 pos, class_2680 state) {
        if (class_2246.field_10211.method_9564().method_26184((class_4538)level, pos)) {
            if (class_3031.method_23396((class_2680)state)) {
                level.method_8652(pos, class_2246.field_10520.method_9564(), 3);
                level.method_8652(pos.method_10084(), class_2246.field_10211.method_9564(), 3);
            } else if (state.method_27852(class_2246.field_10211)) {
                level.method_8652(pos.method_10084(), class_2246.field_10211.method_9564(), 3);
            }
        }
    }

    private static void paperArrowHitsBlock(class_1297 owner, class_1937 level, class_2338 pos) {
        Random random = new Random();
        switch (random.nextInt(1, 9)) {
            case 1: {
                level.method_8537(null, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), 2.0f, true, class_1937.class_7867.field_40891);
                break;
            }
            case 2: {
                if (owner == null) break;
                owner.method_5859(owner.field_6014, owner.field_6036 + 10.0, owner.field_5969);
                break;
            }
            case 3: {
                if (owner == null) break;
                owner.method_5859((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260());
                break;
            }
            case 4: {
                if (owner == null) break;
                owner.method_5859((double)pos.method_10263(), (double)(pos.method_10264() + 10), (double)pos.method_10260());
                break;
            }
            case 5: {
                class_1538 lightningBolt = (class_1538)class_1299.field_6112.method_5883(level);
                lightningBolt.method_29495(class_243.method_24955((class_2382)pos.method_10084()));
                lightningBolt.method_6961(null);
                level.method_8649((class_1297)lightningBolt);
                break;
            }
            case 6: {
                level.method_8537(null, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), 1.0f, true, class_1937.class_7867.field_40891);
                break;
            }
            case 7: {
                for (int i = 0; i < 4; ++i) {
                    class_1428 chicken = (class_1428)class_1299.field_6132.method_5883(level);
                    chicken.method_24203((double)pos.method_10263(), (double)(pos.method_10264() + i), (double)pos.method_10260());
                    level.method_8649((class_1297)chicken);
                }
                break;
            }
            case 8: {
                for (int i = 0; i < 4; ++i) {
                    class_1642 zombie = (class_1642)class_1299.field_6051.method_5883(level);
                    zombie.method_24203((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260());
                    level.method_8649((class_1297)zombie);
                }
                break;
            }
        }
    }

    private static void paperArrowHitsEntity(class_1297 owner, class_1937 level, class_1297 entity) {
        Random random = new Random();
        switch (random.nextInt(1, 9)) {
            case 1: {
                entity.method_5639(2);
                break;
            }
            case 2: {
                if (owner == null) break;
                entity.method_5859(owner.field_6014, owner.field_6036, owner.field_5969);
                break;
            }
            case 3: {
                if (owner == null) break;
                owner.method_5859(entity.field_6014, entity.field_6036, entity.field_5969);
                break;
            }
            case 4: {
                if (owner == null) break;
                entity.method_5859(entity.field_6014, entity.field_6036 + 10.0, entity.field_5969);
                break;
            }
            case 5: {
                class_1538 lightningBolt = (class_1538)class_1299.field_6112.method_5883(level);
                lightningBolt.method_29495(class_243.method_24955((class_2382)entity.method_24515().method_10084()));
                lightningBolt.method_6961(null);
                level.method_8649((class_1297)lightningBolt);
                break;
            }
            case 6: {
                level.method_8537(null, entity.field_6014, entity.field_6036, entity.field_5969, 2.0f, true, class_1937.class_7867.field_40891);
                break;
            }
            case 7: {
                for (int i = 0; i < 4; ++i) {
                    class_1428 chicken = (class_1428)class_1299.field_6132.method_5883(level);
                    chicken.method_24203(entity.field_6014, entity.field_6036 + (double)i, entity.field_5969);
                    level.method_8649((class_1297)chicken);
                }
                break;
            }
            case 8: {
                for (int i = 0; i < 4; ++i) {
                    class_1642 zombie = (class_1642)class_1299.field_6051.method_5883(level);
                    zombie.method_24203(entity.field_6014, entity.field_6036, entity.field_5969);
                    level.method_8649((class_1297)zombie);
                }
                break;
            }
        }
    }
}

