/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.locomotion.common.item;

import cofh.core.common.entity.AbstractMinecartCoFH;
import cofh.core.common.item.MinecartItemCoFH;
import cofh.core.util.helpers.AugmentDataHelper;
import cofh.core.util.helpers.AugmentableHelper;
import cofh.lib.api.ContainerType;
import cofh.lib.common.energy.EnergyStorageCoFH;
import cofh.lib.util.helpers.StringHelper;
import cofh.thermal.lib.common.item.IFlexibleEnergyContainerItem;
import cofh.thermal.locomotion.common.entity.EnergyMinecart;
import cofh.thermal.locomotion.common.item.AugmentableMinecartItem;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class EnergyMinecartItem
extends AugmentableMinecartItem
implements IFlexibleEnergyContainerItem {
    public EnergyMinecartItem(Item.Properties builder) {
        super((MinecartItemCoFH.IMinecartFactory<? extends AbstractMinecartCoFH>)((MinecartItemCoFH.IMinecartFactory)EnergyMinecart::new), builder);
        this.setEnchantability(10);
    }

    protected void tooltipDelegate(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        boolean creative = this.isCreative(stack, ContainerType.ENERGY);
        if (this.getMaxEnergyStored(stack) > 0) {
            tooltip.add((Component)(creative ? StringHelper.getTextComponent((String)"info.cofh.infinite").m_130940_(ChatFormatting.LIGHT_PURPLE).m_130940_(ChatFormatting.ITALIC) : StringHelper.getTextComponent((String)(StringHelper.localize((String)"info.cofh.energy") + ": " + StringHelper.getScaledNumber((long)this.getEnergyStored(stack)) + " / " + StringHelper.getScaledNumber((long)this.getMaxEnergyStored(stack)) + " " + StringHelper.localize((String)"info.cofh.unit_rf")))));
        }
        this.addEnergyTooltip(stack, worldIn, tooltip, flagIn, this.getExtract(stack), this.getReceive(stack), creative);
    }

    protected void setAttributesFromAugment(ItemStack container, CompoundTag augmentData) {
        CompoundTag subTag = container.m_41737_("Properties");
        if (subTag == null) {
            return;
        }
        AugmentableHelper.setAttributeFromAugmentMax((CompoundTag)subTag, (CompoundTag)augmentData, (String)"BaseMod");
        AugmentableHelper.setAttributeFromAugmentMax((CompoundTag)subTag, (CompoundTag)augmentData, (String)"RFMax");
        AugmentableHelper.setAttributeFromAugmentMax((CompoundTag)subTag, (CompoundTag)augmentData, (String)"RFXfer");
        AugmentableHelper.setAttributeFromAugmentMax((CompoundTag)subTag, (CompoundTag)augmentData, (String)"RFCre");
    }

    public CompoundTag getOrCreateEnergyTag(ItemStack container) {
        CompoundTag tag = container.m_41784_();
        if (!tag.m_128441_("EnergyMax")) {
            new EnergyStorageCoFH(1000000, 1000).writeWithParams(tag);
        }
        return container.m_41783_();
    }

    public int getExtract(ItemStack container) {
        CompoundTag tag = this.getOrCreateEnergyTag(container);
        return Math.round(tag.m_128451_("EnergySend"));
    }

    public int getReceive(ItemStack container) {
        CompoundTag tag = this.getOrCreateEnergyTag(container);
        return Math.round(tag.m_128451_("EnergyRecv"));
    }

    public int getMaxEnergyStored(ItemStack container) {
        CompoundTag tag = this.getOrCreateEnergyTag(container);
        float base = AugmentableHelper.getPropertyWithDefault((ItemStack)container, (String)"BaseMod", (float)1.0f);
        float mod = AugmentableHelper.getPropertyWithDefault((ItemStack)container, (String)"RFMax", (float)1.0f);
        return this.getMaxStored(container, Math.round((float)tag.m_128451_("EnergyMax") * mod * base));
    }

    @Override
    public void updateAugmentState(ItemStack container, List<ItemStack> augments) {
        container.m_41784_().m_128365_("Properties", (Tag)new CompoundTag());
        for (ItemStack augment : augments) {
            CompoundTag augmentData = AugmentDataHelper.getAugmentData((ItemStack)augment);
            if (augmentData == null) continue;
            this.setAttributesFromAugment(container, augmentData);
        }
        int energyExcess = this.getEnergyStored(container) - this.getMaxEnergyStored(container);
        if (energyExcess > 0) {
            this.setEnergyStored(container, this.getMaxEnergyStored(container));
        }
    }
}

