/*
 * Decompiled with CFR 0.152.
 */
package forge.com.cursee.longer_following_time.util;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;

public class Config {
    private Map<String, String> data = new HashMap<String, String>();
    private String filePath;

    public Config(String filePath) {
        this.filePath = filePath;
        this.load();
    }

    public void load() {
        try (BufferedReader r = new BufferedReader(new FileReader(this.filePath));){
            String line;
            while ((line = r.readLine()) != null) {
                if (!line.contains("=")) continue;
                String[] parts = line.split("=", 2);
                this.data.put(parts[0].trim(), parts[1].trim());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void save() {
        try (PrintWriter w = new PrintWriter(new FileWriter(this.filePath));){
            for (Map.Entry<String, String> entry : this.data.entrySet()) {
                w.println(entry.getKey() + "=" + entry.getValue());
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to save config", e);
        }
    }

    public void set(String key, String value) {
        this.data.put(key, value);
    }

    public void set(String key, int value) {
        this.data.put(key, String.valueOf(value));
    }

    public void set(String key, boolean value) {
        this.data.put(key, String.valueOf(value));
    }

    public void set(String key, float value) {
        this.data.put(key, String.valueOf(value));
    }

    public String getString(String key, String defaultValue) {
        return this.data.getOrDefault(key, defaultValue);
    }

    public int getInt(String key, int defaultValue) {
        try {
            return Integer.parseInt(this.data.get(key));
        }
        catch (NullPointerException | NumberFormatException e) {
            return defaultValue;
        }
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        String value = this.data.get(key);
        return value != null ? Boolean.parseBoolean(value) : defaultValue;
    }

    public float getFloat(String key, float defaultValue) {
        try {
            return Float.parseFloat(this.data.get(key));
        }
        catch (NullPointerException | NumberFormatException e) {
            return defaultValue;
        }
    }
}

