/*
 * Decompiled with CFR 0.152.
 */
package com.pedrorok.hypertube.network.packets;

import com.pedrorok.hypertube.core.travel.ClientTravelPathMover;
import com.pedrorok.hypertube.network.Packet;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkEvent;

public record MovePathPacket(int entityId, List<Vec3> pathPoints, Set<BlockPos> actionPoints, double travelSpeed) implements Packet<MovePathPacket>
{
    public MovePathPacket(FriendlyByteBuf buf) {
        this(buf.readInt(), MovePathPacket.readPathPoints(buf), MovePathPacket.readActionPoints(buf), buf.readDouble());
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        buf.writeInt(this.entityId);
        buf.writeInt(this.pathPoints.size());
        for (Vec3 vec : this.pathPoints) {
            buf.writeDouble(vec.f_82479_);
            buf.writeDouble(vec.f_82480_);
            buf.writeDouble(vec.f_82481_);
        }
        buf.writeInt(this.actionPoints.size());
        for (BlockPos blockPos : this.actionPoints) {
            buf.m_130064_(blockPos);
        }
        buf.writeDouble(this.travelSpeed);
    }

    @Override
    public void execute(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> ClientTravelPathMover.startMoving(this));
        ctx.get().setPacketHandled(true);
    }

    private static List<Vec3> readPathPoints(FriendlyByteBuf buf) {
        int size = buf.readInt();
        ArrayList<Vec3> points = new ArrayList<Vec3>(size);
        for (int i = 0; i < size; ++i) {
            double x = buf.readDouble();
            double y = buf.readDouble();
            double z = buf.readDouble();
            points.add(new Vec3(x, y, z));
        }
        return points;
    }

    public static Set<BlockPos> readActionPoints(FriendlyByteBuf buf) {
        int size = buf.readInt();
        HashSet<BlockPos> actionPoints = new HashSet<BlockPos>();
        for (int i = 0; i < size; ++i) {
            actionPoints.add(buf.m_130135_());
        }
        return actionPoints;
    }
}

