/*
 * Decompiled with CFR 0.152.
 */
package com.pedrorok.hypertube.core.sound;

import com.pedrorok.hypertube.core.camera.DetachedCameraController;
import com.pedrorok.hypertube.core.sound.TubeSound;
import com.pedrorok.hypertube.registry.ModSounds;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSoundPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class TubeSoundManager {
    private static final Map<UUID, TubeAmbientSound> ambientSounds = new HashMap<UUID, TubeAmbientSound>();

    @OnlyIn(value=Dist.CLIENT)
    public static void tickClientPlayerSounds() {
        TravelSound.tickClientPlayerSounds();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static TubeAmbientSound getAmbientSound(UUID uuid) {
        return ambientSounds.computeIfAbsent(uuid, k -> new TubeAmbientSound());
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void removeAmbientSound(UUID uuid) {
        TubeAmbientSound sound = ambientSounds.remove(uuid);
        if (sound != null) {
            sound.stopSound();
        }
    }

    public static void playTubeSuctionSound(LivingEntity entity, Vec3 pos) {
        RandomSource random = entity.m_9236_().f_46441_;
        float pitch = 0.8f + random.m_188501_() * 0.4f;
        int seed = random.m_188503_(1000);
        for (Player oPlayer : entity.m_9236_().m_6907_()) {
            ((ServerPlayer)oPlayer).f_8906_.m_9829_((Packet)new ClientboundSoundPacket((Holder)ModSounds.HYPERTUBE_SUCTION.getHolder().get(), SoundSource.BLOCKS, pos.f_82479_, pos.f_82480_, pos.f_82481_, 1.0f, pitch, (long)seed));
        }
    }

    public static class TravelSound {
        private static boolean isClientPlayerInTravel;
        private static TubeSound travelSound;

        @OnlyIn(value=Dist.CLIENT)
        public static void enableClientPlayerSound(Entity e, float maxVolume, float pitch) {
            if (e != Minecraft.m_91087_().m_91288_()) {
                return;
            }
            isClientPlayerInTravel = true;
            float cameraYaw = Math.abs(DetachedCameraController.get().getYaw());
            float cameraPitch = Math.abs(DetachedCameraController.get().getPitch());
            float yRot = Math.abs(Minecraft.m_91087_().f_91074_.m_146908_());
            float xRot = Math.abs(Minecraft.m_91087_().f_91074_.m_146909_());
            float equalYaw = Math.abs(cameraYaw - yRot);
            float equalPitch = Math.abs(cameraPitch - xRot);
            if (travelSound == null || travelSound.m_7801_()) {
                travelSound = new TubeSound((SoundEvent)ModSounds.TRAVELING.get(), pitch);
                Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)travelSound);
            }
            boolean isCameraInside = equalYaw < 12.0f && equalPitch < 12.0f;
            travelSound.setPitch(isCameraInside ? pitch : 1.5f);
            travelSound.fadeIn(maxVolume * (isCameraInside ? 1.5f : 0.8f));
        }

        @OnlyIn(value=Dist.CLIENT)
        private static void tickClientPlayerSounds() {
            if (!isClientPlayerInTravel && travelSound != null) {
                if (travelSound.isFaded()) {
                    travelSound.stopSound();
                } else {
                    travelSound.fadeOut();
                }
            }
            isClientPlayerInTravel = false;
        }
    }

    public static class TubeAmbientSound {
        private boolean isClientNear;
        private TubeSound travelSound;

        @OnlyIn(value=Dist.CLIENT)
        public void enableClientPlayerSound(Entity e, Vec3 normal, double distance, boolean isOpen) {
            if (e != Minecraft.m_91087_().m_91288_()) {
                return;
            }
            if (distance > 32.0) {
                this.tickClientPlayerSounds();
                return;
            }
            this.isClientNear = true;
            float pitch = isOpen ? 1.5f : 0.5f;
            float maxVolume = Math.max(0.0f, (float)(1.0 - distance / 48.0));
            if (this.travelSound == null || this.travelSound.m_7801_()) {
                this.travelSound = new TubeSound((SoundEvent)ModSounds.TRAVELING.get(), pitch);
                Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)this.travelSound);
            }
            this.travelSound.updateLocation(normal);
            this.travelSound.setPitch(pitch);
            this.travelSound.fadeIn(maxVolume);
        }

        @OnlyIn(value=Dist.CLIENT)
        public void tickClientPlayerSounds() {
            if (!this.isClientNear && this.travelSound != null) {
                if (this.travelSound.isFaded()) {
                    this.travelSound.stopSound();
                } else {
                    this.travelSound.fadeOut();
                }
            }
            this.isClientNear = false;
        }

        @OnlyIn(value=Dist.CLIENT)
        public void stopSound() {
            if (this.travelSound != null) {
                this.travelSound.stopSound();
                this.travelSound = null;
            }
        }
    }
}

