/*
 * Decompiled with CFR 0.152.
 */
package com.pedrorok.hypertube.blocks.blockentities;

import com.pedrorok.hypertube.HypertubeMod;
import com.pedrorok.hypertube.blocks.HyperAcceleratorBlock;
import com.pedrorok.hypertube.blocks.HypertubeBlock;
import com.pedrorok.hypertube.blocks.blockentities.ActionTubeBlockEntity;
import com.pedrorok.hypertube.config.ServerConfig;
import com.pedrorok.hypertube.core.connection.TubeConnectionException;
import com.pedrorok.hypertube.core.connection.interfaces.IConnection;
import com.pedrorok.hypertube.core.sound.TubeSoundManager;
import com.simibubi.create.api.equipment.goggles.IHaveHoveringInformation;
import com.simibubi.create.content.kinetics.base.IRotate;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class HyperAcceleratorBlockEntity
extends ActionTubeBlockEntity
implements IHaveHoveringInformation {
    private final UUID tubeSoundId = UUID.randomUUID();
    private IConnection connectionOne;
    private IConnection connectionTwo;

    public HyperAcceleratorBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        if (compound.m_128441_("ConnectionOne")) {
            this.connectionOne = this.getConnection(compound, "ConnectionOne");
        }
        if (compound.m_128441_("ConnectionTwo")) {
            this.connectionTwo = this.getConnection(compound, "ConnectionTwo");
        }
    }

    protected void write(CompoundTag compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        this.writeConnection(compound, new Tuple[]{new Tuple((Object)this.connectionOne, (Object)"ConnectionOne"), new Tuple((Object)this.connectionTwo, (Object)"ConnectionTwo")});
    }

    @Override
    public boolean wrenchClicked(Direction direction) {
        IConnection connectionInDirection = this.getConnectionInDirection(direction);
        if (connectionInDirection == null) {
            return false;
        }
        connectionInDirection.updateTubeSegments(this.f_58857_);
        return true;
    }

    public void tick() {
        super.tick();
        if (this.f_58857_.f_46443_) {
            this.tickClient();
            return;
        }
        BlockState state = this.m_58900_();
        BlockPos pos = this.m_58899_();
        float actualSpeed = Math.abs(this.getSpeed());
        Boolean isOpen = (Boolean)state.m_61143_((Property)HyperAcceleratorBlock.OPEN);
        LivingEntity nearbyEntity = this.getNearbyLivingEntities((ServerLevel)this.f_58857_, pos.m_252807_());
        boolean canOpen = nearbyEntity != null && nearbyEntity.getPersistentData().m_128471_("hypertube_travel");
        this.isTubeClosed(canOpen, isOpen);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void tickClient() {
        float actualSpeed = Math.abs(this.getSpeed());
        TubeSoundManager.TubeAmbientSound sound = TubeSoundManager.getAmbientSound(this.tubeSoundId);
        if (actualSpeed < 16.0f) {
            sound.tickClientPlayerSounds();
            return;
        }
        this.playClientEffects(sound);
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        super.addToGoggleTooltip(tooltip, isPlayerSneaking);
        float finalSpeed = Math.abs(this.getSpeed());
        boolean hasNeededSpeed = finalSpeed < 16.0f;
        IRotate.SpeedLevel.getFormattedSpeedText((float)this.speed, (boolean)hasNeededSpeed).forGoggles(tooltip);
        if (hasNeededSpeed) {
            tooltip.add((Component)Component.m_237113_((String)"     ").m_7220_((Component)Component.m_237113_((String)"\u2592 ")).m_7220_((Component)Component.m_237115_((String)"tooltip.create_hypertube.entrance_no_speed")).m_130940_(ChatFormatting.RED));
        } else {
            MutableComponent literalTooltip = Component.m_237113_((String)"     ");
            literalTooltip = literalTooltip.m_7220_((Component)((Boolean)this.m_58900_().m_61143_((Property)HyperAcceleratorBlock.ACCELERATE) != false ? Component.m_237115_((String)"block.hypertube.hyper_accelerator.accelerate_mode").m_130940_(ChatFormatting.YELLOW) : Component.m_237115_((String)"block.hypertube.hyper_accelerator.brake_mode").m_130940_(ChatFormatting.GOLD)));
            tooltip.add((Component)literalTooltip);
        }
        return true;
    }

    @Override
    public List<IConnection> getConnections() {
        ArrayList<IConnection> connections = new ArrayList<IConnection>();
        if (this.connectionOne != null) {
            connections.add(this.connectionOne);
        }
        if (this.connectionTwo != null) {
            connections.add(this.connectionTwo);
        }
        return connections;
    }

    @Override
    public void setConnection(IConnection connection, Direction thisConnectionDir) {
        BlockState blockState;
        Block block;
        if (this.connectionOne == null) {
            this.connectionOne = connection;
        } else if (this.connectionTwo == null) {
            this.connectionTwo = connection;
        } else {
            HypertubeMod.LOGGER.error(new TubeConnectionException("Connection could not define connection", connection, this.connectionOne, this.connectionTwo).getMessage());
            return;
        }
        if (this.f_58857_ != null && !this.f_58857_.m_5776_() && (block = (blockState = this.f_58857_.m_8055_(this.f_58858_)).m_60734_()) instanceof HypertubeBlock) {
            HypertubeBlock hypertubeBlock = (HypertubeBlock)block;
            hypertubeBlock.updateBlockStateFromEntity(blockState, this.f_58857_, this.f_58858_);
            if (thisConnectionDir != null) {
                BlockState state = hypertubeBlock.getState(blockState, List.of(thisConnectionDir), true);
                hypertubeBlock.updateBlockState(this.f_58857_, this.f_58858_, state);
            }
        }
        this.m_6596_();
        this.sync();
    }

    @Override
    public void clearConnection(IConnection connection) {
        if (this.connectionOne != null && this.connectionOne.isSameConnection(connection)) {
            this.connectionOne = null;
        } else if (this.connectionTwo != null && this.connectionTwo.isSameConnection(connection)) {
            this.connectionTwo = null;
        } else {
            HypertubeMod.LOGGER.error(new TubeConnectionException("Connection could not be cleared", connection, this.connectionOne, this.connectionTwo).getMessage());
            return;
        }
        this.m_6596_();
        this.sync();
    }

    @Override
    protected int getConnectionCount() {
        return 2;
    }

    public void onSpeedChanged(float previousSpeed) {
        this.f_58857_.m_7731_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)HyperAcceleratorBlock.ACTIVE, (Comparable)Boolean.valueOf(Math.abs(this.getSpeed()) >= 16.0f)), 3);
    }

    @Override
    public void remove() {
        super.remove();
        if (this.f_58857_.f_46443_) {
            TubeSoundManager.TubeAmbientSound sound = TubeSoundManager.getAmbientSound(this.tubeSoundId);
            sound.stopSound();
        }
    }

    public float calculateStressApplied() {
        float impact;
        this.lastStressApplied = impact = ((Double)ServerConfig.get().STRESS_IMPACT_ACCELERATOR.get()).floatValue();
        return impact;
    }

    public IConnection getConnectionOne() {
        return this.connectionOne;
    }

    public IConnection getConnectionTwo() {
        return this.connectionTwo;
    }
}

