/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.util;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import top.ribs.scguns.cache.HotBarrelCache;
import top.ribs.scguns.common.Gun;
import top.ribs.scguns.common.ReloadType;
import top.ribs.scguns.init.ModEffects;
import top.ribs.scguns.init.ModEnchantments;
import top.ribs.scguns.item.GunItem;
import top.ribs.scguns.particles.TrailData;
import top.ribs.scguns.util.GunModifierHelper;

public class GunEnchantmentHelper {
    private static final Map<MobEffect, Integer> ELEMENTAL_EFFECTS = new HashMap<MobEffect, Integer>();

    public static float getChargeDamage(ItemStack weapon, float damage, float chargeProgress) {
        Item item = weapon.m_41720_();
        if (!(item instanceof GunItem)) {
            return damage;
        }
        GunItem gunItem = (GunItem)item;
        Gun modifiedGun = gunItem.getModifiedGun(weapon);
        if (modifiedGun.getGeneral().getFireTimer() <= 0) {
            return damage;
        }
        float minDamagePercent = 0.85f;
        float fullChargeThreshold = 0.95f;
        float effectiveCharge = chargeProgress >= fullChargeThreshold ? 1.0f : chargeProgress;
        float normalizedCharge = effectiveCharge < fullChargeThreshold ? effectiveCharge / fullChargeThreshold : 1.0f;
        float damageReductionFactor = minDamagePercent + (float)(Math.sqrt(normalizedCharge) * (double)(1.0f - minDamagePercent));
        return damage * damageReductionFactor;
    }

    public static int getRealReloadSpeed(ItemStack weapon) {
        Gun modifiedGun = ((GunItem)weapon.m_41720_()).getModifiedGun(weapon);
        if (modifiedGun.getReloads().getReloadType() == ReloadType.MAG_FED) {
            return GunEnchantmentHelper.getMagReloadSpeed(weapon);
        }
        return GunEnchantmentHelper.getReloadInterval(weapon);
    }

    public static int getReloadInterval(ItemStack weapon) {
        Gun modifiedGun = ((GunItem)weapon.m_41720_()).getModifiedGun(weapon);
        ReloadType reloadType = modifiedGun.getReloads().getReloadType();
        int level = EnchantmentHelper.m_44843_((Enchantment)((Enchantment)ModEnchantments.QUICK_HANDS.get()), (ItemStack)weapon);
        double decreaseFactor = 1.0 - 0.25 * (double)level;
        if (reloadType == ReloadType.MANUAL) {
            int bulletReloadTime = modifiedGun.getReloads().getReloadTimer();
            double interval = (double)bulletReloadTime * decreaseFactor;
            interval = GunModifierHelper.getModifiedReloadSpeed(weapon, interval);
            return Math.max((int)Math.round(interval), 1);
        }
        if (reloadType == ReloadType.SINGLE_ITEM) {
            int bulletReloadTime = modifiedGun.getReloads().getReloadTimer();
            double interval = (double)bulletReloadTime * decreaseFactor;
            interval = GunModifierHelper.getModifiedReloadSpeed(weapon, interval);
            return Math.max((int)Math.round(interval), 1);
        }
        int baseInterval = 10;
        double interval = (double)baseInterval * decreaseFactor;
        interval = GunModifierHelper.getModifiedReloadSpeed(weapon, interval);
        return Math.max((int)Math.round(interval), 1);
    }

    public static int getMagReloadSpeed(ItemStack weapon) {
        Gun modifiedGun = ((GunItem)weapon.m_41720_()).getModifiedGun(weapon);
        int baseSpeed = modifiedGun.getReloads().getReloadTimer();
        int level = EnchantmentHelper.m_44843_((Enchantment)((Enchantment)ModEnchantments.QUICK_HANDS.get()), (ItemStack)weapon);
        double decreaseFactor = 1.0 - 0.25 * (double)level;
        double speed = (double)baseSpeed * decreaseFactor;
        speed = GunModifierHelper.getModifiedReloadSpeed(weapon, speed);
        return Math.max((int)Math.round(speed), 4);
    }

    public static double getAimDownSightSpeed(ItemStack weapon) {
        int level = EnchantmentHelper.m_44843_((Enchantment)((Enchantment)ModEnchantments.LIGHTWEIGHT.get()), (ItemStack)weapon);
        return level > 0 ? 1.2 : 1.0;
    }

    public static double getProjectileSpeedModifier(ItemStack weapon) {
        int acceleratorLevel = EnchantmentHelper.m_44843_((Enchantment)((Enchantment)ModEnchantments.ACCELERATOR.get()), (ItemStack)weapon);
        int heavyShotLevel = EnchantmentHelper.m_44843_((Enchantment)((Enchantment)ModEnchantments.HEAVY_SHOT.get()), (ItemStack)weapon);
        double speedModifier = 1.0;
        if (acceleratorLevel > 0) {
            speedModifier += 0.25 * (double)acceleratorLevel;
        }
        if (heavyShotLevel > 0) {
            speedModifier -= 0.1 * (double)heavyShotLevel;
        }
        return Mth.m_14008_((double)speedModifier, (double)0.1, (double)5.0);
    }

    public static int getRate(ItemStack weapon, Gun modifiedGun) {
        int baseRate = modifiedGun.getGeneral().getRate();
        int triggerFingerLevel = EnchantmentHelper.m_44843_((Enchantment)((Enchantment)ModEnchantments.TRIGGER_FINGER.get()), (ItemStack)weapon);
        int heavyShotLevel = EnchantmentHelper.m_44843_((Enchantment)((Enchantment)ModEnchantments.HEAVY_SHOT.get()), (ItemStack)weapon);
        int puncturingLevel = EnchantmentHelper.m_44843_((Enchantment)((Enchantment)ModEnchantments.PUNCTURING.get()), (ItemStack)weapon);
        float rateModifier = GunEnchantmentHelper.getRateModifier(triggerFingerLevel, heavyShotLevel, puncturingLevel);
        int modifiedRate = Math.round((float)baseRate * rateModifier);
        modifiedRate = GunModifierHelper.getModifiedRate(weapon, modifiedRate);
        return Math.max(modifiedRate, 1);
    }

    public static float getRecoilModifier(ItemStack weapon) {
        int heavyShotLevel = EnchantmentHelper.m_44843_((Enchantment)((Enchantment)ModEnchantments.HEAVY_SHOT.get()), (ItemStack)weapon);
        int puncturingLevel = EnchantmentHelper.m_44843_((Enchantment)((Enchantment)ModEnchantments.PUNCTURING.get()), (ItemStack)weapon);
        float modifier = 1.0f;
        modifier += 0.25f * (float)heavyShotLevel;
        return modifier += 0.1f * (float)puncturingLevel;
    }

    public static float getRecoilModifier(Player player, ItemStack weapon) {
        float baseModifier = GunEnchantmentHelper.getRecoilModifier(weapon);
        if (player != null) {
            baseModifier = GunEnchantmentHelper.getHotBarrelRecoil(player, weapon, baseModifier);
        }
        return baseModifier;
    }

    public static float getKickModifier(ItemStack weapon) {
        int heavyShotLevel = EnchantmentHelper.m_44843_((Enchantment)((Enchantment)ModEnchantments.HEAVY_SHOT.get()), (ItemStack)weapon);
        return 1.0f + 0.05f * (float)heavyShotLevel;
    }

    public static float getKickModifier(Player player, ItemStack weapon) {
        float baseModifier = GunEnchantmentHelper.getKickModifier(weapon);
        if (player != null) {
            int hotBarrelLevel = HotBarrelCache.getHotBarrelLevel(player, weapon);
            float kickIncreaseFactor = 1.0f + (float)hotBarrelLevel / 100.0f * 0.5f;
            baseModifier *= kickIncreaseFactor;
        }
        return baseModifier;
    }

    private static float getRateModifier(int triggerFingerLevel, int heavyShotLevel, int puncturingLevel) {
        float heavyShotModifier = 1.0f + 0.15f * (float)heavyShotLevel;
        float puncturingModifier = 1.0f + 0.06f * (float)puncturingLevel;
        float triggerFingerModifier = 1.0f - 0.12f * (float)triggerFingerLevel;
        float combinedModifier = heavyShotModifier * puncturingModifier * triggerFingerModifier;
        return Mth.m_14036_((float)combinedModifier, (float)0.5f, (float)2.0f);
    }

    public static float getHeavyShotDamage(ItemStack weapon, float damage) {
        int level = EnchantmentHelper.m_44843_((Enchantment)((Enchantment)ModEnchantments.HEAVY_SHOT.get()), (ItemStack)weapon);
        if (level > 0) {
            damage += damage * (0.125f * (float)level);
        }
        return damage;
    }

    public static float getHeavyShotKnockback(ItemStack weapon, float baseKnockback) {
        int level = EnchantmentHelper.m_44843_((Enchantment)((Enchantment)ModEnchantments.HEAVY_SHOT.get()), (ItemStack)weapon);
        if (level > 0) {
            return baseKnockback + 0.2f * (float)level;
        }
        return baseKnockback;
    }

    public static float getAcceleratorDamage(ItemStack weapon, float damage) {
        int acceleratorLevel = EnchantmentHelper.m_44843_((Enchantment)((Enchantment)ModEnchantments.ACCELERATOR.get()), (ItemStack)weapon);
        if (acceleratorLevel > 0) {
            damage += damage * (0.06f * (float)acceleratorLevel);
        }
        return damage;
    }

    public static float getHotBarrelDamage(Player player, ItemStack weapon, float baseDamage) {
        int hotBarrelLevel = HotBarrelCache.getHotBarrelLevel(player, weapon);
        float damageBoost = (float)hotBarrelLevel / 100.0f * 0.6f;
        return baseDamage + baseDamage * damageBoost;
    }

    public static float getHotBarrelRecoil(Player player, ItemStack weapon, float baseRecoil) {
        int hotBarrelLevel = HotBarrelCache.getHotBarrelLevel(player, weapon);
        float recoilIncreaseFactor = 1.0f + (float)hotBarrelLevel / 100.0f * 0.75f;
        return baseRecoil * recoilIncreaseFactor;
    }

    public static float getHotBarrelSpread(Player player, ItemStack weapon, float baseSpread) {
        int hotBarrelLevel = HotBarrelCache.getHotBarrelLevel(player, weapon);
        float spreadIncrease = (float)hotBarrelLevel / 100.0f * 1.5f;
        return baseSpread + baseSpread * spreadIncrease;
    }

    public static boolean shouldSetOnFire(Player player, ItemStack weapon) {
        int hotBarrelLevel = HotBarrelCache.getHotBarrelLevel(player, weapon);
        return hotBarrelLevel >= 60;
    }

    public static ParticleOptions getParticle(ItemStack weapon) {
        Map enchantments = EnchantmentHelper.m_44831_((ItemStack)weapon);
        if (enchantments.containsKey(ModEnchantments.PUNCTURING.get())) {
            return ParticleTypes.f_123808_;
        }
        if (enchantments.containsKey(ModEnchantments.HEAVY_SHOT.get())) {
            return ParticleTypes.f_123757_;
        }
        if (enchantments.containsKey(ModEnchantments.ELEMENTAL_POP.get())) {
            return ParticleTypes.f_123784_;
        }
        return new TrailData(weapon.m_41793_());
    }

    public static float getPuncturingChance(ItemStack weapon) {
        int level = EnchantmentHelper.m_44843_((Enchantment)((Enchantment)ModEnchantments.PUNCTURING.get()), (ItemStack)weapon);
        return (float)level * 0.05f;
    }

    public static float getPuncturingArmorBypass(ItemStack weapon) {
        int puncturingLevel = EnchantmentHelper.m_44843_((Enchantment)((Enchantment)ModEnchantments.PUNCTURING.get()), (ItemStack)weapon);
        if (puncturingLevel > 0) {
            return 5.0f * (float)puncturingLevel;
        }
        return 0.0f;
    }

    public static float getPuncturingDamageReduction(ItemStack weapon, LivingEntity target, float damage) {
        return damage;
    }

    public static float getWaterProofDamage(ItemStack weapon, Player player, float damage) {
        int waterProofLevel = EnchantmentHelper.m_44843_((Enchantment)((Enchantment)ModEnchantments.WATER_PROOF.get()), (ItemStack)weapon);
        if (waterProofLevel > 0 && player != null && player.m_5842_()) {
            return damage * 1.15f;
        }
        return damage;
    }

    public static void applyElementalPopEffect(ItemStack weapon, LivingEntity target) {
        int enchantmentLevel = EnchantmentHelper.m_44843_((Enchantment)((Enchantment)ModEnchantments.ELEMENTAL_POP.get()), (ItemStack)weapon);
        if (enchantmentLevel > 0) {
            Random random = new Random();
            for (Map.Entry<MobEffect, Integer> entry : ELEMENTAL_EFFECTS.entrySet()) {
                MobEffect effect = entry.getKey();
                int baseChance = entry.getValue();
                int finalChance = baseChance + enchantmentLevel * 3;
                if (random.nextInt(100) >= finalChance) continue;
                int duration = GunEnchantmentHelper.getRandomEffectDuration(effect, enchantmentLevel, random);
                int amplifier = GunEnchantmentHelper.getRandomEffectAmplifier(enchantmentLevel, random);
                target.m_7292_(new MobEffectInstance(effect, duration, amplifier));
                GunEnchantmentHelper.triggerVisualSplashEffect(target, effect);
                break;
            }
        }
    }

    private static int getRandomEffectDuration(MobEffect effect, int enchantmentLevel, Random random) {
        int baseDuration = 60;
        int maxDuration = 200;
        if (effect.m_8093_()) {
            return 1;
        }
        int duration = baseDuration + random.nextInt(maxDuration - baseDuration) + enchantmentLevel * 20;
        return Math.min(duration, maxDuration);
    }

    private static int getRandomEffectAmplifier(int enchantmentLevel, Random random) {
        int baseAmplifier = 0;
        int maxAmplifier = 2;
        int amplifier = baseAmplifier + random.nextInt(enchantmentLevel + 1);
        return Math.min(amplifier, maxAmplifier);
    }

    private static void triggerVisualSplashEffect(LivingEntity target, MobEffect effect) {
        Level level = target.m_9236_();
        Vec3 position = target.m_20182_();
        int color = effect.m_19484_();
        double red = (double)(color >> 16 & 0xFF) / 255.0;
        double green = (double)(color >> 8 & 0xFF) / 255.0;
        double blue = (double)(color & 0xFF) / 255.0;
        for (int i = 0; i < 20; ++i) {
            double offsetX = (level.f_46441_.m_188500_() - 0.5) * 2.0;
            double offsetY = level.f_46441_.m_188500_() * 2.0;
            double offsetZ = (level.f_46441_.m_188500_() - 0.5) * 2.0;
            level.m_7106_((ParticleOptions)ParticleTypes.f_123811_, position.f_82479_ + offsetX, position.f_82480_ + offsetY, position.f_82481_ + offsetZ, red, green, blue);
        }
    }

    public static int getQuickHands(ItemStack stack) {
        return EnchantmentHelper.m_44843_((Enchantment)((Enchantment)ModEnchantments.QUICK_HANDS.get()), (ItemStack)stack);
    }

    public static int getLightweight(ItemStack stack) {
        return EnchantmentHelper.m_44843_((Enchantment)((Enchantment)ModEnchantments.LIGHTWEIGHT.get()), (ItemStack)stack);
    }

    static {
        ELEMENTAL_EFFECTS.put(MobEffects.f_19596_, 5);
        ELEMENTAL_EFFECTS.put(MobEffects.f_19614_, 6);
        ELEMENTAL_EFFECTS.put(MobEffects.f_19615_, 3);
        ELEMENTAL_EFFECTS.put(MobEffects.f_19601_, 6);
        ELEMENTAL_EFFECTS.put(MobEffects.f_19602_, 6);
        ELEMENTAL_EFFECTS.put(MobEffects.f_19605_, 5);
        ELEMENTAL_EFFECTS.put(MobEffects.f_19607_, 5);
        ELEMENTAL_EFFECTS.put(MobEffects.f_19620_, 3);
        ELEMENTAL_EFFECTS.put(MobEffects.f_19597_, 7);
        ELEMENTAL_EFFECTS.put(MobEffects.f_19613_, 3);
        ELEMENTAL_EFFECTS.put(MobEffects.f_19617_, 3);
        ELEMENTAL_EFFECTS.put(MobEffects.f_19606_, 6);
        ELEMENTAL_EFFECTS.put(MobEffects.f_19609_, 3);
        ELEMENTAL_EFFECTS.put(MobEffects.f_19610_, 2);
        ELEMENTAL_EFFECTS.put(MobEffects.f_19612_, 4);
        ELEMENTAL_EFFECTS.put(MobEffects.f_19599_, 4);
        ELEMENTAL_EFFECTS.put(MobEffects.f_19604_, 2);
        ELEMENTAL_EFFECTS.put(MobEffects.f_19608_, 4);
        ELEMENTAL_EFFECTS.put(MobEffects.f_19611_, 3);
        ELEMENTAL_EFFECTS.put((MobEffect)ModEffects.SULFUR_POISONING.get(), 5);
        ELEMENTAL_EFFECTS.put((MobEffect)ModEffects.BLINDED.get(), 2);
        ELEMENTAL_EFFECTS.put((MobEffect)ModEffects.DEAFENED.get(), 2);
        ELEMENTAL_EFFECTS.put((MobEffect)ModEffects.LACERATED.get(), 4);
    }
}

