/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.util;

import com.simibubi.create.content.equipment.armor.BacktankUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.IItemHandlerModifiable;
import top.ribs.scguns.ScorchedGuns;
import top.ribs.scguns.item.AirCanisterItem;
import top.theillusivec4.curios.api.CuriosApi;

public class AirSourceHelper {
    public static List<ItemStack> findAirCanistersWithAir(Player player) {
        ArrayList<ItemStack> airCanisters = new ArrayList<ItemStack>();
        for (ItemStack stack : player.m_150109_().f_35974_) {
            if (!AirSourceHelper.isAirCanisterWithAir(stack)) continue;
            airCanisters.add(stack);
        }
        CuriosApi.getCuriosInventory((LivingEntity)player).ifPresent(handler -> {
            IItemHandlerModifiable curios = handler.getEquippedCurios();
            for (int i = 0; i < curios.getSlots(); ++i) {
                ItemStack stack = curios.getStackInSlot(i);
                if (!AirSourceHelper.isAirCanisterWithAir(stack)) continue;
                airCanisters.add(stack);
            }
        });
        return airCanisters;
    }

    public static AirSource getBestAirSource(Player player) {
        List backtanks;
        if (ScorchedGuns.createLoaded && !(backtanks = BacktankUtil.getAllWithAir((LivingEntity)player)).isEmpty()) {
            return new AirSource(AirSource.Type.CREATE_BACKTANK, (ItemStack)backtanks.get(0));
        }
        List<ItemStack> airCanisters = AirSourceHelper.findAirCanistersWithAir(player);
        if (!airCanisters.isEmpty()) {
            return new AirSource(AirSource.Type.AIR_CANISTER, airCanisters.get(0));
        }
        return AirSource.NONE;
    }

    public static boolean consumeAir(Player player, float airCost) {
        AirSource airSource = AirSourceHelper.getBestAirSource(player);
        switch (airSource.getType()) {
            case CREATE_BACKTANK: {
                if (!ScorchedGuns.createLoaded) break;
                if (BacktankUtil.hasAirRemaining((ItemStack)airSource.getStack()) && BacktankUtil.getAir((ItemStack)airSource.getStack()) >= airCost) {
                    BacktankUtil.consumeAir((LivingEntity)player, (ItemStack)airSource.getStack(), (float)airCost);
                    return true;
                }
                return false;
            }
            case AIR_CANISTER: {
                IEnergyStorage energyStorage = (IEnergyStorage)airSource.getStack().getCapability(ForgeCapabilities.ENERGY).orElse(null);
                if ((float)energyStorage.getEnergyStored() >= airCost) {
                    int airExtracted = energyStorage.extractEnergy((int)airCost, false);
                    return (float)airExtracted >= airCost;
                }
                return false;
            }
            default: {
                return false;
            }
        }
        return false;
    }

    public static AirInfo getAirInfo(Player player) {
        AirSource airSource = AirSourceHelper.getBestAirSource(player);
        switch (airSource.getType()) {
            case CREATE_BACKTANK: {
                if (!ScorchedGuns.createLoaded) break;
                ItemStack backtank = airSource.getStack();
                int maxAir = BacktankUtil.maxAir((ItemStack)backtank);
                float air = BacktankUtil.getAir((ItemStack)backtank);
                int barWidth = Math.round(13.0f * air / (float)maxAir);
                int barColor = BacktankUtil.getBarColor((ItemStack)backtank, (int)1);
                return new AirInfo(barWidth, barColor, AirSource.Type.CREATE_BACKTANK);
            }
            case AIR_CANISTER: {
                float ratio;
                ItemStack canister = airSource.getStack();
                Item air = canister.m_41720_();
                if (!(air instanceof AirCanisterItem)) break;
                AirCanisterItem airCanisterItem = (AirCanisterItem)air;
                int stored = airCanisterItem.getAirStored(canister);
                int max = airCanisterItem.getMaxAirStored(canister);
                int barWidth = max > 0 ? Math.round(13.0f * (float)stored / (float)max) : 0;
                float f = ratio = max > 0 ? (float)stored / (float)max : 0.0f;
                int barColor = ratio < 0.25f ? 0xFF4444 : (ratio < 0.5f ? 0xFFAA00 : 43775);
                return new AirInfo(barWidth, barColor, AirSource.Type.AIR_CANISTER);
            }
        }
        return AirInfo.NONE;
    }

    private static boolean isAirCanisterWithAir(ItemStack stack) {
        if (!(stack.m_41720_() instanceof AirCanisterItem)) {
            return false;
        }
        IEnergyStorage energyStorage = (IEnergyStorage)stack.getCapability(ForgeCapabilities.ENERGY).orElse(null);
        return energyStorage.getEnergyStored() > 0;
    }

    public static class AirSource {
        public static final AirSource NONE = new AirSource(Type.NONE, ItemStack.f_41583_);
        private final Type type;
        private final ItemStack stack;

        public AirSource(Type type, ItemStack stack) {
            this.type = type;
            this.stack = stack;
        }

        public Type getType() {
            return this.type;
        }

        public ItemStack getStack() {
            return this.stack;
        }

        public boolean isAvailable() {
            return this.type != Type.NONE && !this.stack.m_41619_();
        }

        public static enum Type {
            NONE,
            CREATE_BACKTANK,
            AIR_CANISTER;

        }
    }

    public record AirInfo(int barWidth, int barColor, AirSource.Type sourceType) {
        public static final AirInfo NONE = new AirInfo(0, 0x808080, AirSource.Type.NONE);
    }
}

