/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.network.message;

import com.mrcrayfish.framework.api.network.MessageContext;
import com.mrcrayfish.framework.api.network.message.PlayMessage;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import top.ribs.scguns.client.network.ClientPlayHandler;

public class S2CMessageBeamPenetration
extends PlayMessage<S2CMessageBeamPenetration> {
    private UUID playerId;
    private List<GlassPenetrationData> penetrations;

    public S2CMessageBeamPenetration() {
        this.penetrations = new ArrayList<GlassPenetrationData>();
    }

    public S2CMessageBeamPenetration(UUID playerId, List<BlockHitResult> glassPenetrations) {
        this.playerId = playerId;
        this.penetrations = glassPenetrations.stream().map(hit -> new GlassPenetrationData(hit.m_82450_(), hit.m_82434_(), hit.m_82425_())).collect(Collectors.toList());
    }

    public void encode(S2CMessageBeamPenetration message, FriendlyByteBuf buffer) {
        buffer.m_130077_(message.playerId);
        buffer.writeInt(message.penetrations.size());
        for (GlassPenetrationData penetration : message.penetrations) {
            buffer.writeDouble(penetration.position.f_82479_);
            buffer.writeDouble(penetration.position.f_82480_);
            buffer.writeDouble(penetration.position.f_82481_);
            buffer.m_130068_((Enum)penetration.face);
            buffer.m_130064_(penetration.blockPos);
        }
    }

    public S2CMessageBeamPenetration decode(FriendlyByteBuf buffer) {
        UUID playerId = buffer.m_130259_();
        int size = buffer.readInt();
        ArrayList<BlockHitResult> penetrations = new ArrayList<BlockHitResult>();
        for (int i = 0; i < size; ++i) {
            Vec3 position = new Vec3(buffer.readDouble(), buffer.readDouble(), buffer.readDouble());
            Direction face = (Direction)buffer.m_130066_(Direction.class);
            BlockPos blockPos = buffer.m_130135_();
            penetrations.add(new BlockHitResult(position, face, blockPos, false));
        }
        return new S2CMessageBeamPenetration(playerId, penetrations);
    }

    public void handle(S2CMessageBeamPenetration message, MessageContext context) {
        context.execute(() -> ClientPlayHandler.handleBeamPenetration(message));
        context.setHandled(true);
    }

    public UUID getPlayerId() {
        return this.playerId;
    }

    public List<GlassPenetrationData> getPenetrations() {
        return this.penetrations;
    }

    public static class GlassPenetrationData {
        private final Vec3 position;
        private final Direction face;
        private final BlockPos blockPos;

        public GlassPenetrationData(Vec3 position, Direction face, BlockPos blockPos) {
            this.position = position;
            this.face = face;
            this.blockPos = blockPos;
        }

        public Vec3 getPosition() {
            return this.position;
        }

        public Direction getFace() {
            return this.face;
        }

        public BlockPos getBlockPos() {
            return this.blockPos;
        }
    }
}

