/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.network.message;

import com.mrcrayfish.framework.api.network.LevelLocation;
import com.mrcrayfish.framework.api.network.MessageContext;
import com.mrcrayfish.framework.api.network.message.PlayMessage;
import com.mrcrayfish.framework.network.message.IMessage;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import top.ribs.scguns.common.Gun;
import top.ribs.scguns.common.ReloadTracker;
import top.ribs.scguns.common.ReloadType;
import top.ribs.scguns.init.ModSyncedDataKeys;
import top.ribs.scguns.item.GunItem;
import top.ribs.scguns.item.animated.AnimatedGunItem;
import top.ribs.scguns.network.PacketHandler;
import top.ribs.scguns.network.message.S2CMessageReload;
import top.ribs.scguns.network.message.S2CMessageUpdateAmmo;

public class C2SMessageGunLoaded
extends PlayMessage<C2SMessageGunLoaded> {
    public void encode(C2SMessageGunLoaded message, FriendlyByteBuf buffer) {
    }

    public C2SMessageGunLoaded decode(FriendlyByteBuf buffer) {
        return new C2SMessageGunLoaded();
    }

    public void handle(C2SMessageGunLoaded message, MessageContext context) {
        context.execute(() -> {
            ItemStack heldItem;
            ServerPlayer player = context.getPlayer();
            if (player != null && !player.m_5833_() && (heldItem = player.m_21205_()).m_41720_() instanceof GunItem) {
                if (!heldItem.m_41720_().getClass().getPackageName().startsWith("top.ribs.scguns")) {
                    return;
                }
                Gun gun = ((GunItem)heldItem.m_41720_()).getModifiedGun(heldItem);
                CompoundTag tag = heldItem.m_41784_();
                ReloadTracker tracker = new ReloadTracker((Player)player);
                if (gun.getReloads().getReloadType() == ReloadType.MAG_FED) {
                    tracker.increaseMagAmmo((Player)player);
                    ModSyncedDataKeys.RELOADING.setValue((Entity)player, (Object)false);
                    tag.m_128473_("IsReloading");
                    tag.m_128473_("scguns:IsReloading");
                    tag.m_128473_("InCriticalReloadPhase");
                    PacketHandler.getPlayChannel().sendToNearbyPlayers(() -> LevelLocation.create((Level)player.m_9236_(), (double)player.m_20185_(), (double)player.m_20186_(), (double)player.m_20189_(), (double)64.0), (IMessage)new S2CMessageUpdateAmmo(tag.m_128451_("AmmoCount")));
                    PacketHandler.getPlayChannel().sendToNearbyPlayers(() -> LevelLocation.create((Level)player.m_9236_(), (double)player.m_20185_(), (double)player.m_20186_(), (double)player.m_20189_(), (double)64.0), (IMessage)new S2CMessageReload(false));
                } else if (gun.getReloads().getReloadType() == ReloadType.SINGLE_ITEM) {
                    tracker.reloadItem((Player)player);
                    ModSyncedDataKeys.RELOADING.setValue((Entity)player, (Object)false);
                    tag.m_128473_("IsReloading");
                    tag.m_128473_("scguns:IsReloading");
                    tag.m_128473_("InCriticalReloadPhase");
                    PacketHandler.getPlayChannel().sendToNearbyPlayers(() -> LevelLocation.create((Level)player.m_9236_(), (double)player.m_20185_(), (double)player.m_20186_(), (double)player.m_20189_(), (double)64.0), (IMessage)new S2CMessageUpdateAmmo(tag.m_128451_("AmmoCount")));
                    PacketHandler.getPlayChannel().sendToNearbyPlayers(() -> LevelLocation.create((Level)player.m_9236_(), (double)player.m_20185_(), (double)player.m_20186_(), (double)player.m_20189_(), (double)64.0), (IMessage)new S2CMessageReload(false));
                } else if (gun.getReloads().getReloadType() == ReloadType.MANUAL) {
                    tracker.increaseAmmo((Player)player);
                    PacketHandler.getPlayChannel().sendToNearbyPlayers(() -> LevelLocation.create((Level)player.m_9236_(), (double)player.m_20185_(), (double)player.m_20186_(), (double)player.m_20189_(), (double)64.0), (IMessage)new S2CMessageUpdateAmmo(tag.m_128451_("AmmoCount")));
                    boolean weaponFull = tracker.isWeaponFull((Player)player);
                    boolean hasNoAmmo = tracker.hasNoAmmo((Player)player);
                    if (weaponFull || hasNoAmmo) {
                        if (player.m_21205_().m_41720_() instanceof AnimatedGunItem) {
                            tag.m_128379_("scguns:ShouldStopAfterLoop", true);
                        } else {
                            ModSyncedDataKeys.RELOADING.setValue((Entity)player, (Object)false);
                            tag.m_128473_("IsReloading");
                            tag.m_128473_("scguns:IsReloading");
                            PacketHandler.getPlayChannel().sendToNearbyPlayers(() -> LevelLocation.create((Level)player.m_9236_(), (double)player.m_20185_(), (double)player.m_20186_(), (double)player.m_20189_(), (double)64.0), (IMessage)new S2CMessageReload(false));
                        }
                    }
                }
            }
        });
        context.setHandled(true);
    }
}

