/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import top.ribs.scguns.item.AmmoItem;

public class TooltipAmmo
extends AmmoItem {
    private final int armorBypassAmount;
    private final String descriptionKey;

    public TooltipAmmo(Item.Properties properties, int armorBypassAmount) {
        super(properties);
        this.armorBypassAmount = armorBypassAmount;
        this.descriptionKey = null;
    }

    public TooltipAmmo(Item.Properties properties, String descriptionKey) {
        super(properties);
        this.armorBypassAmount = -1;
        this.descriptionKey = descriptionKey;
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        super.m_7373_(stack, level, tooltip, flag);
        if (this.armorBypassAmount >= 0) {
            tooltip.add(this.getArmorBypassTooltip());
        }
        if (this.descriptionKey != null) {
            tooltip.add(this.getDescriptionTooltip());
        }
    }

    private Component getArmorBypassTooltip() {
        return Component.m_237110_((String)"tooltip.scguns.armor_bypass", (Object[])new Object[]{this.armorBypassAmount}).m_130944_(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC});
    }

    private Component getDescriptionTooltip() {
        assert (this.descriptionKey != null);
        return Component.m_237115_((String)this.descriptionKey).m_130944_(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC});
    }
}

