/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.item;

import com.mrcrayfish.framework.network.message.IMessage;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import top.ribs.scguns.entity.monster.TheMerchantEntity;
import top.ribs.scguns.init.ModEntities;
import top.ribs.scguns.network.PacketHandler;
import top.ribs.scguns.network.message.S2CShowTotemAnimationMessage;

public class ThePactItem
extends Item {
    private static final double SUMMON_RANGE = 12.0;
    private static final int BLINDNESS_DURATION = 100;
    private static final int SLOWNESS_DURATION = 100;

    public ThePactItem(Item.Properties pProperties) {
        super(pProperties);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(Level pLevel, Player pPlayer, @NotNull InteractionHand pUsedHand) {
        ItemStack itemStack = pPlayer.m_21120_(pUsedHand);
        if (!pLevel.m_5776_()) {
            ServerLevel serverLevel = (ServerLevel)pLevel;
            if (this.hasNearbyMerchant(serverLevel, pPlayer)) {
                return InteractionResultHolder.m_19100_((Object)itemStack);
            }
            this.applyPactEffects(pPlayer);
            if (pPlayer instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)pPlayer;
                PacketHandler.getPlayChannel().sendToPlayer(() -> serverPlayer, (IMessage)new S2CShowTotemAnimationMessage(itemStack));
            }
            pLevel.m_6263_(null, pPlayer.m_20185_(), pPlayer.m_20186_(), pPlayer.m_20189_(), SoundEvents.f_12513_, SoundSource.PLAYERS, 1.0f, 0.8f);
            Vec3 spawnPos = this.findSpawnPosition(pPlayer);
            TheMerchantEntity merchant = new TheMerchantEntity((EntityType<? extends PathfinderMob>)((EntityType)ModEntities.THE_MERCHANT.get()), (Level)serverLevel, true);
            merchant.m_6034_(spawnPos.f_82479_, spawnPos.f_82480_, spawnPos.f_82481_);
            merchant.setSummoner(pPlayer);
            merchant.setWalkingToSummoner(true);
            if (serverLevel.m_7967_((Entity)merchant)) {
                merchant.createSpawnEffect();
                if (!pPlayer.m_7500_()) {
                    itemStack.m_41774_(1);
                }
                return InteractionResultHolder.m_19092_((Object)itemStack, (boolean)pLevel.m_5776_());
            }
            return InteractionResultHolder.m_19100_((Object)itemStack);
        }
        return InteractionResultHolder.m_19092_((Object)itemStack, (boolean)pLevel.m_5776_());
    }

    private void applyPactEffects(Player player) {
        float currentHealth = player.m_21223_();
        float maxHealth = player.m_21233_();
        if (currentHealth > 1.0f) {
            player.m_21153_(1.0f);
        }
        player.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 100, 0, false, false, false));
        player.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 100, 3, false, false, false));
        player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)SoundEvents.f_12325_.get(), SoundSource.PLAYERS, 0.8f, 0.7f);
    }

    private boolean hasNearbyMerchant(ServerLevel level, Player player) {
        return level.m_45976_(TheMerchantEntity.class, player.m_20191_().m_82400_(20.0)).stream().anyMatch(merchant -> merchant.getSummoner() != null && merchant.getSummoner().m_20148_().equals(player.m_20148_()));
    }

    private Vec3 findSpawnPosition(Player player) {
        double[] spawnRadii;
        Vec3 playerPos = player.m_20182_();
        Level level = player.m_9236_();
        for (double radius : spawnRadii = new double[]{12.0, 17.0, 22.0}) {
            for (int attempts = 0; attempts < 32; ++attempts) {
                double angle = (double)attempts * Math.PI * 2.0 / 32.0;
                double x = playerPos.f_82479_ + Math.cos(angle) * radius;
                double z = playerPos.f_82481_ + Math.sin(angle) * radius;
                for (int yOffset = 5; yOffset >= -10; --yOffset) {
                    int y = (int)playerPos.f_82480_ + yOffset;
                    if (!this.isValidMerchantSpawnPosition(level, x, y, z)) continue;
                    return new Vec3(x, (double)(y + 1), z);
                }
            }
        }
        return playerPos.m_82520_(0.0, 1.0, 0.0);
    }

    private boolean isValidMerchantSpawnPosition(Level level, double x, int y, double z) {
        BlockPos groundPos = new BlockPos((int)x, y, (int)z);
        BlockPos spawnPos = groundPos.m_7494_();
        BlockPos headPos = spawnPos.m_7494_();
        if (!level.m_8055_(groundPos).m_60804_((BlockGetter)level, groundPos)) {
            return false;
        }
        if (!level.m_8055_(spawnPos).m_60795_() || !level.m_8055_(headPos).m_60795_()) {
            return false;
        }
        for (int dx = -1; dx <= 1; ++dx) {
            for (int dz = -1; dz <= 1; ++dz) {
                BlockPos checkPos = spawnPos.m_7918_(dx, 0, dz);
                if (level.m_8055_(checkPos).m_60795_()) continue;
                return false;
            }
        }
        boolean foundGroundNearby = false;
        for (int checkY = y; checkY >= y - 5; --checkY) {
            if (!level.m_8055_(new BlockPos((int)x, checkY, (int)z)).m_60804_((BlockGetter)level, new BlockPos((int)x, checkY, (int)z))) continue;
            foundGroundNearby = true;
            break;
        }
        return foundGroundNearby;
    }
}

