/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.item;

import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import top.ribs.scguns.init.ModParticleTypes;

@Mod.EventBusSubscriber(modid="scguns", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class RangeFinderItem
extends Item {
    public RangeFinderItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (level.f_46443_) {
            ClientEventHandler.calculateAndDisplayRange(player);
        }
        return InteractionResultHolder.m_19096_((Object)itemstack);
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.NONE;
    }

    public int m_8105_(ItemStack stack) {
        return 0;
    }

    @Mod.EventBusSubscriber(modid="scguns", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
    public static class ClientEventHandler {
        private static int tickCounter = 0;
        private static final int TICK_DELAY = 2;
        private static final double OFFSET = 0.1;
        private static final int MAX_RANGE = 200;

        @SubscribeEvent
        public static void onClientTick(TickEvent.ClientTickEvent event) {
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (player != null && ++tickCounter >= 2) {
                tickCounter = 0;
                ItemStack heldItem = player.m_21120_(InteractionHand.MAIN_HAND);
                if (heldItem.m_41720_() instanceof RangeFinderItem) {
                    ClientEventHandler.showLaserParticles(player);
                }
            }
        }

        private static void showLaserParticles(LocalPlayer player) {
            Level world = player.m_9236_();
            Vec3 start = player.m_20299_(1.0f);
            Vec3 direction = player.m_20154_();
            Vec3 end = start.m_82549_(direction.m_82490_(200.0));
            BlockHitResult hitResult = player.m_9236_().m_45547_(new ClipContext(start, end, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)player));
            Vec3 finalEnd = hitResult.m_6662_() != HitResult.Type.MISS ? hitResult.m_82450_() : end;
            AABB aabb = new AABB(start, finalEnd).m_82400_(0.5);
            List entities = world.m_6249_((Entity)player, aabb, e -> !e.m_5833_() && e.m_6087_());
            EntityHitResult entityHitResult = null;
            double closestDistance = Double.MAX_VALUE;
            for (Entity entity : entities) {
                Vec3 hitVec;
                double distance;
                AABB entityAABB = entity.m_20191_().m_82400_(0.3);
                Optional optionalHit = entityAABB.m_82371_(start, finalEnd);
                if (!optionalHit.isPresent() || !((distance = start.m_82554_(hitVec = (Vec3)optionalHit.get())) < closestDistance)) continue;
                closestDistance = distance;
                entityHitResult = new EntityHitResult(entity, hitVec);
            }
            if (entityHitResult != null) {
                finalEnd = entityHitResult.m_82450_();
            }
            Vec3 adjustedPosition = finalEnd.m_82546_(direction.m_82490_(0.1));
            world.m_7106_((ParticleOptions)ModParticleTypes.LASER.get(), adjustedPosition.f_82479_, adjustedPosition.f_82480_, adjustedPosition.f_82481_, 2.0, 0.0, 0.0);
        }

        private static void calculateAndDisplayRange(Player player) {
            Vec3 start = player.m_20299_(1.0f);
            Vec3 direction = player.m_20154_();
            Vec3 end = start.m_82549_(direction.m_82490_(200.0));
            BlockHitResult hitResult = player.m_9236_().m_45547_(new ClipContext(start, end, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)player));
            AABB aabb = new AABB(start, end).m_82400_(0.5);
            List entities = player.m_9236_().m_6249_((Entity)player, aabb, e -> !e.m_5833_() && e.m_6087_());
            EntityHitResult entityHitResult = null;
            double closestDistance = Double.MAX_VALUE;
            for (Entity entity : entities) {
                Vec3 hitVec;
                double distance;
                AABB entityAABB = entity.m_20191_().m_82400_(0.3);
                Optional optionalHit = entityAABB.m_82371_(start, end);
                if (!optionalHit.isPresent() || !((distance = start.m_82554_(hitVec = (Vec3)optionalHit.get())) < closestDistance)) continue;
                closestDistance = distance;
                entityHitResult = new EntityHitResult(entity, hitVec);
            }
            if (entityHitResult != null) {
                double distance = start.m_82554_(entityHitResult.m_82450_());
                String entityName = entityHitResult.m_82443_().m_7755_().getString();
                player.m_5661_((Component)Component.m_237113_((String)("Target: " + entityName + " - Distance: " + String.format("%.1f", distance) + " blocks")), true);
            } else if (hitResult.m_6662_() != HitResult.Type.MISS) {
                double distance = start.m_82554_(hitResult.m_82450_());
                BlockPos blockPos = hitResult instanceof BlockHitResult ? hitResult.m_82425_() : null;
                String blockName = player.m_9236_().m_8055_(blockPos).m_60734_().m_49954_().getString();
                player.m_5661_((Component)Component.m_237113_((String)("Target: " + blockName + " - Distance: " + String.format("%.1f", distance) + " blocks")), true);
            } else {
                player.m_5661_((Component)Component.m_237113_((String)"No target in range"), true);
            }
        }
    }
}

