/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.event;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraftforge.event.entity.EntityMountEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import top.ribs.scguns.ScorchedGuns;

@Mod.EventBusSubscriber(modid="scguns", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class VehicleDetectionHandler {
    private static final Map<UUID, VehicleInfo> playersInVehicles = new HashMap<UUID, VehicleInfo>();

    @SubscribeEvent
    public static void onEntityMount(EntityMountEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        Entity vehicle = event.getEntityBeingMounted();
        if (event.isMounting()) {
            if (VehicleDetectionHandler.isVehicle(vehicle)) {
                String vehicleType = VehicleDetectionHandler.getVehicleType(vehicle);
                playersInVehicles.put(player.m_20148_(), new VehicleInfo(vehicleType, vehicle));
                ScorchedGuns.LOGGER.debug("Player {} mounted {}: {} - Gun poses will be adjusted", (Object)player.m_7755_().getString(), (Object)vehicleType, (Object)vehicle.getClass().getSimpleName());
            }
        } else if (playersInVehicles.remove(player.m_20148_()) != null) {
            ScorchedGuns.LOGGER.debug("Player {} dismounted - Gun poses restored to normal", (Object)player.m_7755_().getString());
        }
    }

    public static boolean isPlayerInVehicle(Player player) {
        return playersInVehicles.containsKey(player.m_20148_()) || player.m_20159_() && VehicleDetectionHandler.isVehicle(player.m_20202_());
    }

    public static VehicleInfo getPlayerVehicleInfo(Player player) {
        VehicleInfo cached = playersInVehicles.get(player.m_20148_());
        if (cached != null) {
            return cached;
        }
        if (player.m_20159_() && VehicleDetectionHandler.isVehicle(player.m_20202_())) {
            Entity vehicle = player.m_20202_();
            return new VehicleInfo(VehicleDetectionHandler.getVehicleType(vehicle), vehicle);
        }
        return null;
    }

    public static String getVehicleTypeForPlayer(Player player) {
        VehicleInfo info = VehicleDetectionHandler.getPlayerVehicleInfo(player);
        return info != null ? info.vehicleType : null;
    }

    private static boolean isVehicle(Entity entity) {
        if (entity == null) {
            return false;
        }
        return entity instanceof Boat || entity instanceof AbstractMinecart || entity instanceof AbstractHorse || entity.getClass().getSimpleName().toLowerCase().contains("vehicle");
    }

    private static String getVehicleType(Entity vehicle) {
        if (vehicle == null) {
            return "unknown";
        }
        if (vehicle instanceof Boat) {
            return "boat";
        }
        if (vehicle instanceof AbstractMinecart) {
            return "minecart";
        }
        if (vehicle instanceof AbstractHorse) {
            return "horse";
        }
        return vehicle.getClass().getSimpleName().toLowerCase();
    }

    public static void cleanup() {
        playersInVehicles.clear();
    }

    public static class VehicleInfo {
        public final String vehicleType;
        public final Entity vehicle;

        public VehicleInfo(String vehicleType, Entity vehicle) {
            this.vehicleType = vehicleType;
            this.vehicle = vehicle;
        }
    }
}

