/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.event;

import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.items.IItemHandlerModifiable;
import top.ribs.scguns.item.ammo_boxes.RockPouch;
import top.theillusivec4.curios.api.CuriosApi;

@Mod.EventBusSubscriber(modid="scguns", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class RockPickupEventHandler {
    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onEntityItemPickup(EntityItemPickupEvent event) {
        if (!(event.getEntity() instanceof Player)) {
            return;
        }
        Player player = event.getEntity();
        ItemStack pickedItem = event.getItem().m_32055_();
        if (RockPickupEventHandler.isRockItem(pickedItem) && RockPickupEventHandler.addRockToPouch(player, pickedItem)) {
            event.setCanceled(true);
            event.getItem().m_32045_(ItemStack.f_41583_);
        }
    }

    private static boolean isRockItem(ItemStack stack) {
        return stack.m_204117_(ItemTags.create((ResourceLocation)new ResourceLocation("scguns", "rocks")));
    }

    private static boolean addRockToPouch(Player player, ItemStack rockStack) {
        for (ItemStack itemStack : player.m_150109_().f_35974_) {
            int insertedItems;
            if (!(itemStack.m_41720_() instanceof RockPouch) || (insertedItems = RockPouch.add(itemStack, rockStack)) <= 0) continue;
            rockStack.m_41774_(insertedItems);
            return true;
        }
        AtomicBoolean result = new AtomicBoolean(false);
        CuriosApi.getCuriosInventory((LivingEntity)player).ifPresent(handler -> {
            IItemHandlerModifiable curios = handler.getEquippedCurios();
            for (int i = 0; i < curios.getSlots(); ++i) {
                int insertedItems;
                ItemStack stack = curios.getStackInSlot(i);
                if (!(stack.m_41720_() instanceof RockPouch) || (insertedItems = RockPouch.add(stack, rockStack)) <= 0) continue;
                rockStack.m_41774_(insertedItems);
                result.set(true);
                break;
            }
        });
        return result.get();
    }
}

